/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.ComparisonFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

public class POUserComparisonFunc
extends ExpressionOperator {
    private static final Log log = LogFactory.getLog(POUserComparisonFunc.class);
    private static final long serialVersionUID = 1L;
    FuncSpec funcSpec;
    Tuple t1;
    Tuple t2;
    transient ComparisonFunc func;

    public POUserComparisonFunc(OperatorKey k, int rp, List inp, FuncSpec funcSpec, ComparisonFunc func) {
        super(k, rp);
        super.setInputs(inp);
        this.funcSpec = funcSpec;
        this.func = func;
        if (func == null) {
            this.instantiateFunc();
        }
    }

    public POUserComparisonFunc(OperatorKey k, int rp, List inp, FuncSpec funcSpec) {
        this(k, rp, inp, funcSpec, null);
    }

    private void instantiateFunc() {
        this.func = (ComparisonFunc)((Object)PigContext.instantiateFuncFromSpec(this.funcSpec));
        this.func.setReporter(POUserComparisonFunc.getReporter());
    }

    public ComparisonFunc getComparator() {
        return this.func;
    }

    @Override
    public Result getNextInteger() throws ExecException {
        Result result = new Result();
        result.result = this.func.compare(this.t1, this.t2);
        result.returnStatus = (byte)(this.t1 != null && this.t2 != null ? 0 : 2);
        this.inputAttached = false;
        if (result.returnStatus == 0) {
            this.illustratorMarkup(null, result.result, (Integer)result.result == 0 ? 0 : ((Integer)result.result > 0 ? 1 : 2));
        }
        return result;
    }

    private Result getNext() {
        Result res = null;
        log.error((Object)"getNext being called with non-integer");
        return res;
    }

    @Override
    public Result getNextBoolean() throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNextDataBag() throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNextDataByteArray() throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNextDouble() throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNextFloat() throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNextLong() throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNextDateTime() throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNextMap() throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNextString() throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNextTuple() throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNextBigInteger() throws ExecException {
        return this.getNext();
    }

    @Override
    public Result getNextBigDecimal() throws ExecException {
        return this.getNext();
    }

    public void attachInput(Tuple t1, Tuple t2) {
        this.t1 = t1;
        this.t2 = t2;
        this.inputAttached = true;
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        this.instantiateFunc();
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitComparisonFunc(this);
    }

    @Override
    public String name() {
        return "POUserComparisonFunc(" + ((Object)((Object)this.func)).getClass().getName() + ")" + "[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    public FuncSpec getFuncSpec() {
        return this.funcSpec;
    }

    @Override
    public POUserComparisonFunc clone() throws CloneNotSupportedException {
        FuncSpec cloneFs = null;
        if (this.funcSpec != null) {
            cloneFs = this.funcSpec.clone();
        }
        POUserComparisonFunc clone = new POUserComparisonFunc(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)), this.requestedParallelism, null, cloneFs);
        clone.cloneHelper(this);
        return clone;
    }

    @Override
    public List<ExpressionOperator> getChildExpressions() {
        return null;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        if (this.illustrator != null) {
            this.illustrator.getInputs().add(this.t1);
            this.illustrator.getEquivalenceClasses().get(eqClassIndex).add(this.t1);
            this.illustrator.getInputs().add(this.t2);
            this.illustrator.getEquivalenceClasses().get(eqClassIndex).add(this.t2);
        }
        return null;
    }
}

