/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.mql.dialect;

import org.pentaho.pms.mql.dialect.DefaultSQLDialect;
import org.pentaho.pms.mql.dialect.SQLQueryModel;

public class MySQLDialect
extends DefaultSQLDialect {
    public MySQLDialect() {
        super("MYSQL");
    }

    protected MySQLDialect(String compatibleDialect) {
        super(compatibleDialect);
    }

    @Override
    public String getDateSQL(int year, int month, int day) {
        return "DATE(" + this.quoteStringLiteral(year + "-" + this.displayAsTwoOrMoreDigits(month) + "-" + this.displayAsTwoOrMoreDigits(day)) + ")";
    }

    @Override
    public int getMaxTableNameLength() {
        return 64;
    }

    @Override
    protected String getStringConcatOperator() {
        return null;
    }

    @Override
    protected String generateStringConcat(String ... vals) {
        StringBuilder sb = new StringBuilder();
        sb.append("CONCAT(");
        for (int i = 0; i < vals.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(vals[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean supportsNLSLiteral() {
        return true;
    }

    @Override
    protected void generatePostOrderBy(SQLQueryModel query, StringBuilder sql) {
        this.generateLimit(query, sql);
    }

    @Override
    protected void generateSelectPredicate(SQLQueryModel query, StringBuilder sql) {
        this.generateDistinct(query, sql);
    }
}

