/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.openerp.objectdelete;

import java.util.List;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.openerp.objectdelete.OpenERPObjectDelete;
import org.pentaho.di.trans.steps.openerp.objectdelete.OpenERPObjectDeleteData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="OpenERPObjectDelete", image="ui/images/deprecated.svg", i18nPackageName="org.pentaho.di.trans.steps.openerp.objectdelete", name="OpenERPObjectDelete.TransName", description="OpenERPObjectDelete.TransDescription", documentationUrl="http://wiki.pentaho.com/display/EAI/OpenERP+Object+Delete", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Deprecated")
public class OpenERPObjectDeleteMeta
extends BaseStepMeta
implements StepMetaInterface {
    private DatabaseMeta databaseMeta;
    private String modelName;
    private int commitBatchSize = 1000;
    private String idFieldName = "";

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        return new OpenERPObjectDelete(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        try {
            return new OpenERPObjectDeleteData(this.databaseMeta);
        }
        catch (Exception e) {
            return null;
        }
    }

    public final String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"modelName", (String)this.modelName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"readBatchSize", (int)this.commitBatchSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"idFieldName", (String)this.idFieldName));
        return retval.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId idStep, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(idStep, "connection", databases);
            this.modelName = rep.getStepAttributeString(idStep, "modelName");
            this.commitBatchSize = Integer.parseInt(rep.getStepAttributeString(idStep, "readBatchSize"));
            this.idFieldName = rep.getStepAttributeString(idStep, "idFieldName");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId idTransformation, ObjectId idStep) throws KettleException {
        try {
            rep.saveDatabaseMetaStepAttribute(idTransformation, idStep, "connection", this.databaseMeta);
            rep.saveStepAttribute(idTransformation, idStep, "modelName", this.modelName);
            rep.saveStepAttribute(idTransformation, idStep, "readBatchSize", (long)this.commitBatchSize);
            rep.saveStepAttribute(idTransformation, idStep, "idFieldName", this.idFieldName);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for idStep=" + idStep, (Throwable)e);
        }
    }

    public void setDefault() {
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)XMLHandler.getTagValue((Node)stepnode, (String)"connection"));
            this.modelName = XMLHandler.getTagValue((Node)stepnode, (String)"modelName");
            this.commitBatchSize = Integer.parseInt(XMLHandler.getTagValue((Node)stepnode, (String)"readBatchSize"));
            this.idFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"idFieldName");
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public final void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public final DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setCommitBatchSize(int commitBatchSize) {
        this.commitBatchSize = commitBatchSize;
    }

    public int getCommitBatchSize() {
        return this.commitBatchSize;
    }

    public void setIdFieldName(String idFieldName) {
        this.idFieldName = idFieldName;
    }

    public String getIdFieldName() {
        return this.idFieldName == null ? "" : this.idFieldName;
    }
}

