/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import org.jets3t.gui.ErrorDialog;
import org.jets3t.gui.GuiUtils;
import org.jets3t.gui.HyperlinkActivatedListener;
import org.jets3t.gui.ProgressDialog;
import org.jets3t.gui.TableSorter;
import org.jets3t.service.CloudFrontService;
import org.jets3t.service.CloudFrontServiceException;
import org.jets3t.service.model.cloudfront.Distribution;
import org.jets3t.service.model.cloudfront.DistributionConfig;
import org.jets3t.service.model.cloudfront.LoggingStatus;
import org.jets3t.service.model.cloudfront.S3Origin;

public class ManageDistributionsDialog
extends JDialog
implements ActionListener,
ListSelectionListener,
HyperlinkActivatedListener {
    private static final long serialVersionUID = 4375982994004017092L;
    private CloudFrontService cloudFrontService = null;
    private final GuiUtils guiUtils = new GuiUtils();
    private Frame ownerFrame = null;
    private JTable distributionListTable = null;
    private DistributionListTableModel distributionListTableModel = null;
    private TableSorter distributionListTableModelSorter = null;
    private JComboBox bucketComboBox = null;
    private JCheckBox enabledCheckbox = null;
    private JCheckBox httpsOnlyCheckbox = null;
    private JComboBox loggingBucketComboBox = null;
    private JTextField defaultRootObjectTextField = null;
    private JTextField loggingPrefixTextField = null;
    private JTable cnamesTable = null;
    private CNAMETableModel cnamesTableModel = null;
    private JButton addCname = null;
    private JButton removeCname = null;
    private JTextArea commentTextArea = null;
    private JTextField minTTLTextField = null;
    private JButton actionButton = null;
    private JButton deleteButton = null;
    private JButton finishedButton = null;
    private final Insets insetsDefault = new Insets(3, 5, 3, 5);
    private final Insets insetsHorizontalOnly = new Insets(0, 5, 0, 5);

    public ManageDistributionsDialog(Frame ownerFrame, CloudFrontService cloudFrontService, String[] bucketNames, HyperlinkActivatedListener hyperlinkListener) {
        super(ownerFrame, "CloudFront Distributions", true);
        this.ownerFrame = ownerFrame;
        this.cloudFrontService = cloudFrontService;
        this.distributionListTableModel = new DistributionListTableModel();
        this.distributionListTableModelSorter = new TableSorter(this.distributionListTableModel);
        this.distributionListTable = new JTable(this.distributionListTableModelSorter);
        this.distributionListTableModelSorter.setTableHeader(this.distributionListTable.getTableHeader());
        this.distributionListTable.setSelectionMode(0);
        this.distributionListTable.getSelectionModel().addListSelectionListener(this);
        JLabel bucketLabel = new JLabel("Bucket");
        this.bucketComboBox = new JComboBox<String>(bucketNames);
        JLabel enabledLabel = new JLabel("Enabled");
        this.enabledCheckbox = new JCheckBox();
        JLabel httpsOnlyLabel = new JLabel("HTTPS Only");
        this.httpsOnlyCheckbox = new JCheckBox();
        JLabel defaultRootObjectLabel = new JLabel("Default Root Object");
        this.defaultRootObjectTextField = new JTextField();
        JLabel minTTLLabel = new JLabel("Minimum TTL");
        this.minTTLTextField = new JTextField("0");
        JLabel loggingBucketLabel = new JLabel("Logging bucket");
        this.loggingBucketComboBox = new JComboBox<String>(bucketNames);
        this.loggingBucketComboBox.insertItemAt("-- Logging Disabled --", 0);
        this.loggingBucketComboBox.setSelectedIndex(0);
        this.loggingBucketComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ManageDistributionsDialog.this.loggingPrefixTextField.setEnabled(ManageDistributionsDialog.this.loggingBucketComboBox.getSelectedIndex() > 0);
            }
        });
        JLabel loggingPrefixLabel = new JLabel("Logging prefix");
        this.loggingPrefixTextField = new JTextField();
        this.loggingPrefixTextField.setEnabled(false);
        this.cnamesTableModel = new CNAMETableModel();
        TableSorter cnamesTableModelSorter = new TableSorter(this.cnamesTableModel);
        this.cnamesTable = new JTable(cnamesTableModelSorter);
        cnamesTableModelSorter.setTableHeader(this.cnamesTable.getTableHeader());
        this.cnamesTable.getSelectionModel().addListSelectionListener(this);
        this.removeCname = new JButton();
        this.removeCname.setToolTipText("Remove the selected CNAME");
        this.guiUtils.applyIcon(this.removeCname, "/images/nuvola/16x16/actions/viewmag-.png");
        this.removeCname.addActionListener(this);
        this.removeCname.setActionCommand("RemoveCname");
        this.removeCname.setEnabled(false);
        this.addCname = new JButton();
        this.addCname.setToolTipText("Add a new CNAME");
        this.guiUtils.applyIcon(this.addCname, "/images/nuvola/16x16/actions/viewmag+.png");
        this.addCname.setActionCommand("AddCname");
        this.addCname.addActionListener(this);
        JLabel commentLabel = new JLabel("Comment");
        this.commentTextArea = new JTextArea();
        this.commentTextArea.setLineWrap(true);
        JButton refreshButton = new JButton("Refresh Distributions");
        refreshButton.setActionCommand("RefreshDistributions");
        refreshButton.addActionListener(this);
        this.guiUtils.applyIcon(refreshButton, "/images/nuvola/16x16/actions/reload.png");
        this.deleteButton = new JButton("Delete Distribution");
        this.deleteButton.setActionCommand("DeleteDistribution");
        this.deleteButton.addActionListener(this);
        this.deleteButton.setEnabled(false);
        this.deleteButton.setToolTipText("To delete a distribution it must first be disabled and deployed");
        this.guiUtils.applyIcon(this.deleteButton, "/images/nuvola/16x16/actions/cancel.png");
        this.actionButton = new JButton("New Distribution");
        this.actionButton.setActionCommand("NewDistribution");
        this.actionButton.addActionListener(this);
        this.finishedButton = new JButton("Finished");
        this.finishedButton.setActionCommand("Finished");
        this.finishedButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.finishedButton);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){
            private static final long serialVersionUID = -7782288899638043533L;

            public void actionPerformed(ActionEvent actionEvent) {
                ManageDistributionsDialog.this.setVisible(false);
            }
        });
        JPanel distributionsButtonsPanel = new JPanel(new GridBagLayout());
        distributionsButtonsPanel.add((Component)refreshButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, this.insetsHorizontalOnly, 0, 0));
        distributionsButtonsPanel.add((Component)this.deleteButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, this.insetsHorizontalOnly, 0, 0));
        JPanel tablePanel = new JPanel(new GridBagLayout());
        tablePanel.add((Component)new JScrollPane(this.distributionListTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 5, 0, 3), 0, 0));
        tablePanel.add((Component)distributionsButtonsPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, this.insetsHorizontalOnly, 0, 0));
        JPanel cnameAddRemoveButtonsPanel = new JPanel(new GridBagLayout());
        cnameAddRemoveButtonsPanel.add((Component)this.removeCname, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, this.insetsHorizontalOnly, 0, 0));
        cnameAddRemoveButtonsPanel.add((Component)this.addCname, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, this.insetsHorizontalOnly, 0, 0));
        JPanel detailPanel = new JPanel(new GridBagLayout());
        detailPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Distribution Details"));
        int row = 0;
        detailPanel.add((Component)bucketLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
        detailPanel.add((Component)this.bucketComboBox, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        detailPanel.add((Component)enabledLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
        detailPanel.add((Component)this.enabledCheckbox, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        detailPanel.add((Component)httpsOnlyLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
        detailPanel.add((Component)this.httpsOnlyCheckbox, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        detailPanel.add((Component)defaultRootObjectLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
        detailPanel.add((Component)this.defaultRootObjectTextField, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        detailPanel.add((Component)minTTLLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
        detailPanel.add((Component)this.minTTLTextField, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        detailPanel.add((Component)loggingBucketLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
        detailPanel.add((Component)this.loggingBucketComboBox, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        detailPanel.add((Component)loggingPrefixLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, this.insetsDefault, 0, 0));
        detailPanel.add((Component)this.loggingPrefixTextField, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        detailPanel.add((Component)new JScrollPane(this.cnamesTable), new GridBagConstraints(0, row++, 2, 1, 1.0, 2.0, 17, 1, new Insets(3, 5, 0, 5), 0, 0));
        detailPanel.add((Component)cnameAddRemoveButtonsPanel, new GridBagConstraints(0, row++, 2, 1, 1.0, 0.0, 13, 0, this.insetsHorizontalOnly, 0, 0));
        detailPanel.add((Component)commentLabel, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 17, 0, this.insetsHorizontalOnly, 0, 0));
        detailPanel.add((Component)new JScrollPane(this.commentTextArea), new GridBagConstraints(0, row++, 2, 1, 0.0, 1.0, 10, 1, this.insetsDefault, 0, 0));
        detailPanel.add((Component)this.actionButton, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 10, 0, this.insetsHorizontalOnly, 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)tablePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 2.0, 10, 1, this.insetsDefault, 0, 0));
        this.getContentPane().add((Component)detailPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, this.insetsHorizontalOnly, 0, 0));
        this.getContentPane().add((Component)this.finishedButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, this.insetsHorizontalOnly, 0, 0));
        this.pack();
        this.setSize(690, 600);
        TableColumnModel columnModel = this.distributionListTable.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(40);
        columnModel.getColumn(1).setPreferredWidth(50);
        columnModel.getColumn(2).setPreferredWidth(170);
        columnModel.getColumn(3).setPreferredWidth(210);
        columnModel.getColumn(4).setPreferredWidth(220);
        this.setLocationRelativeTo(ownerFrame);
        this.refreshDistributions();
    }

    protected void refreshDistributions() {
        new Thread(){

            public void run() {
                final ProgressDialog progressDialog = new ProgressDialog(ManageDistributionsDialog.this.ownerFrame, "Listing Distributions", null);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        progressDialog.startDialog("Listing Distributions", null, 0, 0, null, null);
                    }
                });
                try {
                    final Distribution[] distributions = ManageDistributionsDialog.this.cloudFrontService.listDistributions();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            int priorSelection = ManageDistributionsDialog.this.distributionListTable.getSelectedRow();
                            ManageDistributionsDialog.this.distributionListTableModel.removeAll();
                            for (int i = 0; i < distributions.length; ++i) {
                                ManageDistributionsDialog.this.distributionListTableModel.addDistribution(distributions[i]);
                            }
                            if (priorSelection >= 0 && priorSelection < ManageDistributionsDialog.this.distributionListTable.getRowCount()) {
                                ManageDistributionsDialog.this.distributionListTable.setRowSelectionInterval(priorSelection, priorSelection);
                            } else if (ManageDistributionsDialog.this.distributionListTable.getRowCount() > 0) {
                                ManageDistributionsDialog.this.distributionListTable.setRowSelectionInterval(0, 0);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            progressDialog.stopDialog();
                        }
                    });
                    String errorMessage = "Failed to list distributions";
                    if (e instanceof CloudFrontServiceException) {
                        errorMessage = ((CloudFrontServiceException)e).getErrorMessage();
                    }
                    ErrorDialog.showDialog(ManageDistributionsDialog.this.ownerFrame, null, errorMessage, (Throwable)e);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        progressDialog.stopDialog();
                    }
                });
            }
        }.start();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (e.getSource().equals(this.distributionListTable.getSelectionModel())) {
            int tableIndex = this.distributionListTable.getSelectedRow();
            if (tableIndex < 0) {
                return;
            }
            Distribution distribution = this.distributionListTableModel.getDistributionAtRow(this.distributionListTableModelSorter.modelIndex(tableIndex));
            if (distribution == null) {
                this.deleteButton.setEnabled(false);
                this.bucketComboBox.setEnabled(true);
                this.enabledCheckbox.setSelected(false);
                this.httpsOnlyCheckbox.setEnabled(false);
                this.defaultRootObjectTextField.setText("");
                this.minTTLTextField.setText("");
                this.loggingBucketComboBox.setSelectedIndex(0);
                this.loggingPrefixTextField.setText("");
                this.cnamesTableModel.removeAll();
                this.commentTextArea.setText("");
                this.actionButton.setText("New Distribution");
                this.actionButton.setActionCommand("NewDistribution");
                this.actionButton.setEnabled(true);
            } else {
                DistributionConfig distributionConfig = null;
                try {
                    distributionConfig = this.cloudFrontService.getDistributionConfig(distribution.getId());
                }
                catch (CloudFrontServiceException ex) {
                    String message = "Unable to retrieve configuration information for distribution: " + distribution.getId();
                    ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, message, (Throwable)ex);
                    return;
                }
                if (distribution.getOrigin() instanceof S3Origin) {
                    this.bucketComboBox.setSelectedItem(((S3Origin)distribution.getOrigin()).getOriginAsBucketName());
                }
                this.bucketComboBox.setEnabled(false);
                this.enabledCheckbox.setSelected(distribution.isEnabled());
                this.httpsOnlyCheckbox.setSelected(distributionConfig.isHttpsProtocolRequired());
                this.defaultRootObjectTextField.setText(distributionConfig.getDefaultRootObject());
                if (distributionConfig.isStreamingDistributionConfig()) {
                    this.minTTLTextField.setEnabled(false);
                    this.minTTLTextField.setText("N/A");
                } else {
                    this.minTTLTextField.setEnabled(true);
                    Long minTTL = distributionConfig.getMinTTL();
                    if (minTTL == null) {
                        this.minTTLTextField.setText("0");
                    } else {
                        this.minTTLTextField.setText(minTTL.toString());
                    }
                }
                if (distributionConfig.getLoggingStatus() != null) {
                    this.loggingBucketComboBox.setSelectedItem(distributionConfig.getLoggingStatus().getShortBucketName());
                    this.loggingPrefixTextField.setText(distributionConfig.getLoggingStatus().getPrefix());
                } else {
                    this.loggingBucketComboBox.setSelectedIndex(0);
                    this.loggingPrefixTextField.setText("");
                }
                this.cnamesTableModel.removeAll();
                String[] cnames = distribution.getCNAMEs();
                for (int i = 0; i < cnames.length; ++i) {
                    this.cnamesTableModel.addCname(cnames[i]);
                }
                this.commentTextArea.setText(distribution.getComment());
                this.deleteButton.setEnabled(!distribution.isEnabled() && distribution.isDeployed());
                this.actionButton.setText("Update Distribution");
                this.actionButton.setActionCommand("UpdateDistribution");
                this.actionButton.setEnabled(distribution.isDeployed());
            }
        } else if (e.getSource().equals(this.cnamesTable.getSelectionModel())) {
            this.removeCname.setEnabled(this.cnamesTable.getSelectedRowCount() != 0);
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.finishedButton)) {
            this.setVisible(false);
        } else if (event.getActionCommand().equals("AddCname")) {
            this.cnamesTableModel.addCname("New CNAME");
            int newRowIndex = this.cnamesTable.getRowCount() - 1;
            this.cnamesTable.setRowSelectionInterval(newRowIndex, newRowIndex);
            this.cnamesTable.editCellAt(newRowIndex, 0);
        } else if (event.getActionCommand().equals("RemoveCname")) {
            this.cnamesTableModel.removeRow(this.cnamesTable.getSelectedRow());
        } else if (event.getActionCommand().equals("RefreshDistributions")) {
            this.refreshDistributions();
        } else if (event.getActionCommand().equals("DeleteDistribution")) {
            final Distribution distribution = this.distributionListTableModel.getDistributionAtRow(this.distributionListTableModelSorter.modelIndex(this.distributionListTable.getSelectedRow()));
            int answer = JOptionPane.showConfirmDialog(this, "Delete the distribution " + distribution.getDomainName() + "?", "Delete Distribution", 0);
            if (answer == 1) {
                return;
            }
            new Thread(){

                public void run() {
                    final ProgressDialog progressDialog = new ProgressDialog(ManageDistributionsDialog.this.ownerFrame, "Deleting Distribution", null);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            progressDialog.startDialog("Deleting distribution: " + distribution.getDomainName(), null, 0, 0, null, null);
                        }
                    });
                    try {
                        ManageDistributionsDialog.this.cloudFrontService.deleteDistribution(distribution.getId());
                        ManageDistributionsDialog.this.refreshDistributions();
                    }
                    catch (Exception e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                progressDialog.stopDialog();
                            }
                        });
                        String errorMessage = "Failed to delete distribution";
                        if (e instanceof CloudFrontServiceException) {
                            errorMessage = ((CloudFrontServiceException)e).getErrorMessage();
                        }
                        ErrorDialog.showDialog(ManageDistributionsDialog.this.ownerFrame, null, errorMessage, (Throwable)e);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            progressDialog.stopDialog();
                        }
                    });
                }
            }.start();
        } else if (event.getActionCommand().equals("NewDistribution")) {
            final String bucketName = this.bucketComboBox.getSelectedItem() + ".s3.amazonaws.com";
            new Thread(){

                public void run() {
                    final ProgressDialog progressDialog = new ProgressDialog(ManageDistributionsDialog.this.ownerFrame, "Creating Distribution", null);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            progressDialog.startDialog("Creating distribution for: " + ManageDistributionsDialog.this.bucketComboBox.getSelectedItem(), null, 0, 0, null, null);
                        }
                    });
                    try {
                        LoggingStatus loggingStatus = null;
                        if (ManageDistributionsDialog.this.loggingBucketComboBox.getSelectedIndex() > 0) {
                            String loggingBucket = (String)ManageDistributionsDialog.this.loggingBucketComboBox.getSelectedItem() + ".s3.amazonaws.com";
                            loggingStatus = new LoggingStatus(loggingBucket, ManageDistributionsDialog.this.loggingPrefixTextField.getText());
                        }
                        String[] requiredProtocols = null;
                        requiredProtocols = ManageDistributionsDialog.this.httpsOnlyCheckbox.isSelected() ? new String[]{"https"} : new String[]{};
                        String defaultRootObject = ManageDistributionsDialog.this.defaultRootObjectTextField.getText();
                        if (defaultRootObject.length() == 0) {
                            defaultRootObject = null;
                        }
                        Long minTTL = null;
                        if (ManageDistributionsDialog.this.minTTLTextField.isEnabled()) {
                            try {
                                minTTL = new Long(ManageDistributionsDialog.this.minTTLTextField.getText());
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                            if (minTTL == null || minTTL < 0L) {
                                throw new Exception("Minimum TTL must be an integer value 0 or greater");
                            }
                        }
                        ManageDistributionsDialog.this.cloudFrontService.createDistribution(new S3Origin(bucketName), null, ManageDistributionsDialog.this.cnamesTableModel.getCnames(), ManageDistributionsDialog.this.commentTextArea.getText(), ManageDistributionsDialog.this.enabledCheckbox.isSelected(), loggingStatus, false, null, requiredProtocols, defaultRootObject, minTTL);
                        ManageDistributionsDialog.this.refreshDistributions();
                    }
                    catch (Exception e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                progressDialog.stopDialog();
                            }
                        });
                        String errorMessage = "Failed to create distribution";
                        if (e instanceof CloudFrontServiceException) {
                            errorMessage = ((CloudFrontServiceException)e).getErrorMessage();
                        }
                        ErrorDialog.showDialog(ManageDistributionsDialog.this.ownerFrame, null, errorMessage, (Throwable)e);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            progressDialog.stopDialog();
                        }
                    });
                }
            }.start();
        } else if (event.getActionCommand().equals("UpdateDistribution")) {
            final Distribution distribution = this.distributionListTableModel.getDistributionAtRow(this.distributionListTableModelSorter.modelIndex(this.distributionListTable.getSelectedRow()));
            new Thread(){

                public void run() {
                    final ProgressDialog progressDialog = new ProgressDialog(ManageDistributionsDialog.this.ownerFrame, "Updating Distribution", null);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            progressDialog.startDialog("Updating distribution: " + distribution.getDomainName(), null, 0, 0, null, null);
                        }
                    });
                    try {
                        LoggingStatus loggingStatus = null;
                        if (ManageDistributionsDialog.this.loggingBucketComboBox.getSelectedIndex() > 0) {
                            String loggingBucket = (String)ManageDistributionsDialog.this.loggingBucketComboBox.getSelectedItem() + ".s3.amazonaws.com";
                            loggingStatus = new LoggingStatus(loggingBucket, ManageDistributionsDialog.this.loggingPrefixTextField.getText());
                        }
                        String[] requiredProtocols = null;
                        requiredProtocols = ManageDistributionsDialog.this.httpsOnlyCheckbox.isSelected() ? new String[]{"https"} : new String[]{};
                        String defaultRootObject = ManageDistributionsDialog.this.defaultRootObjectTextField.getText();
                        if (defaultRootObject.length() == 0) {
                            defaultRootObject = null;
                        }
                        Long minTTL = null;
                        if (ManageDistributionsDialog.this.minTTLTextField.isEnabled()) {
                            try {
                                minTTL = new Long(ManageDistributionsDialog.this.minTTLTextField.getText());
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                            if (minTTL == null || minTTL < 0L) {
                                throw new Exception("Minimum TTL must be an integer value 0 or greater");
                            }
                        }
                        ManageDistributionsDialog.this.cloudFrontService.updateDistributionConfig(distribution.getId(), null, ManageDistributionsDialog.this.cnamesTableModel.getCnames(), ManageDistributionsDialog.this.commentTextArea.getText(), ManageDistributionsDialog.this.enabledCheckbox.isSelected(), loggingStatus, false, null, requiredProtocols, defaultRootObject, minTTL);
                        ManageDistributionsDialog.this.refreshDistributions();
                    }
                    catch (Exception e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                progressDialog.stopDialog();
                            }
                        });
                        String errorMessage = "Failed to update distribution";
                        if (e instanceof CloudFrontServiceException) {
                            errorMessage = ((CloudFrontServiceException)e).getErrorMessage();
                        }
                        ErrorDialog.showDialog(ManageDistributionsDialog.this.ownerFrame, null, errorMessage, (Throwable)e);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            progressDialog.stopDialog();
                        }
                    });
                }
            }.start();
        }
    }

    public static void showDialog(Frame ownerFrame, CloudFrontService cloudFrontService, String[] bucketNames, HyperlinkActivatedListener hyperlinkListener) {
        ManageDistributionsDialog dialog = new ManageDistributionsDialog(ownerFrame, cloudFrontService, bucketNames, hyperlinkListener);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public void followHyperlink(URL url, String target) {
    }

    private class CNAMETableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 7975150589167172506L;

        public CNAMETableModel() {
            super(new String[]{"CNAME Aliases"}, 0);
        }

        public void addCname(String cname) {
            this.addRow(new Object[]{cname});
        }

        public String[] getCnames() {
            String[] cnames = new String[this.getRowCount()];
            for (int i = 0; i < this.getRowCount(); ++i) {
                cnames[i] = (String)this.getValueAt(i, 0);
            }
            return cnames;
        }

        public void removeAll() {
            int rowCount = this.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                this.removeRow(0);
            }
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }
    }

    private class DistributionListTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = -8315527286580422385L;
        private final ArrayList distributionList;
        private Icon inProgressIcon;
        private Icon deployedIcon;

        public DistributionListTableModel() {
            super(new String[]{"Status", "Enabled", "Bucket", "Domain Name", "Last Modified"}, 0);
            this.distributionList = new ArrayList();
            this.inProgressIcon = null;
            this.deployedIcon = null;
            this.addRow(new Object[]{null, null, "Add New Distribution", null, null});
            JLabel dummyLabel = new JLabel();
            if (ManageDistributionsDialog.this.guiUtils.applyIcon(dummyLabel, "/images/nuvola/16x16/actions/noatunloopsong.png")) {
                this.inProgressIcon = dummyLabel.getIcon();
            }
            if (ManageDistributionsDialog.this.guiUtils.applyIcon(dummyLabel, "/images/nuvola/16x16/actions/ok.png")) {
                this.deployedIcon = dummyLabel.getIcon();
            }
        }

        protected int findDistributionIndex(String bucketName) {
            return Collections.binarySearch(this.distributionList, bucketName, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String b1Name = ((Distribution)o1).getOrigin().getDnsName();
                    String b2Name = (String)o2;
                    int result = b1Name.compareTo(b2Name);
                    return result;
                }
            });
        }

        public void addDistribution(Distribution distribution) {
            this.distributionList.add(distribution);
            this.insertRow(this.distributionList.size() - 1, new Object[]{distribution.isDeployed() ? this.deployedIcon : this.inProgressIcon, distribution.isEnabled(), distribution.getOrigin().getDnsName(), distribution.getDomainName(), distribution.getLastModifiedTime()});
        }

        public Distribution getDistributionAtRow(int rowIndex) {
            if (rowIndex < this.distributionList.size()) {
                return (Distribution)this.distributionList.get(rowIndex);
            }
            return null;
        }

        public void removeDistribution(String bucketName) {
            int index = this.findDistributionIndex(bucketName);
            this.removeRow(index);
            this.distributionList.remove(index);
        }

        public void removeAll() {
            int rowCount = this.distributionList.size();
            for (int i = 0; i < rowCount; ++i) {
                this.removeRow(0);
            }
            this.distributionList.clear();
        }

        public boolean isCellEditable(int row, int column) {
            return column == 3 && row < this.distributionList.size();
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Icon.class;
                }
                case 1: {
                    return Boolean.class;
                }
            }
            return String.class;
        }
    }
}

