/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import com.google.common.base.Preconditions;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.VectorPartitionConversion;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorAssignRow {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(VectorAssignRow.class);
    boolean[] isConvert;
    int[] projectionColumnNums;
    ObjectInspector.Category[] targetCategories;
    PrimitiveObjectInspector.PrimitiveCategory[] targetPrimitiveCategories;
    int[] maxLengths;
    PrimitiveObjectInspector[] convertSourcePrimitiveObjectInspectors;
    Writable[] convertTargetWritables;

    private void allocateArrays(int count) {
        this.isConvert = new boolean[count];
        this.projectionColumnNums = new int[count];
        this.targetCategories = new ObjectInspector.Category[count];
        this.targetPrimitiveCategories = new PrimitiveObjectInspector.PrimitiveCategory[count];
        this.maxLengths = new int[count];
    }

    private void allocateConvertArrays(int count) {
        this.convertSourcePrimitiveObjectInspectors = new PrimitiveObjectInspector[count];
        this.convertTargetWritables = new Writable[count];
    }

    private void initTargetEntry(int logicalColumnIndex, int projectionColumnNum, TypeInfo typeInfo) {
        ObjectInspector.Category category;
        this.isConvert[logicalColumnIndex] = false;
        this.projectionColumnNums[logicalColumnIndex] = projectionColumnNum;
        this.targetCategories[logicalColumnIndex] = category = typeInfo.getCategory();
        if (category == ObjectInspector.Category.PRIMITIVE) {
            PrimitiveObjectInspector.PrimitiveCategory primitiveCategory;
            PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
            this.targetPrimitiveCategories[logicalColumnIndex] = primitiveCategory = primitiveTypeInfo.getPrimitiveCategory();
            switch (primitiveCategory) {
                case CHAR: {
                    this.maxLengths[logicalColumnIndex] = ((CharTypeInfo)primitiveTypeInfo).getLength();
                    break;
                }
                case VARCHAR: {
                    this.maxLengths[logicalColumnIndex] = ((VarcharTypeInfo)primitiveTypeInfo).getLength();
                    break;
                }
            }
        }
    }

    private void initConvertSourceEntry(int logicalColumnIndex, TypeInfo convertSourceTypeInfo) {
        this.isConvert[logicalColumnIndex] = true;
        ObjectInspector.Category convertSourceCategory = convertSourceTypeInfo.getCategory();
        if (convertSourceCategory == ObjectInspector.Category.PRIMITIVE) {
            PrimitiveTypeInfo convertSourcePrimitiveTypeInfo = (PrimitiveTypeInfo)convertSourceTypeInfo;
            this.convertSourcePrimitiveObjectInspectors[logicalColumnIndex] = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(convertSourcePrimitiveTypeInfo);
            PrimitiveObjectInspector.PrimitiveCategory targetPrimitiveCategory = this.targetPrimitiveCategories[logicalColumnIndex];
            switch (targetPrimitiveCategory) {
                case DATE: {
                    this.convertTargetWritables[logicalColumnIndex] = new DateWritable();
                    break;
                }
                case STRING: {
                    this.convertTargetWritables[logicalColumnIndex] = new Text();
                    break;
                }
            }
        }
    }

    public void init(StructObjectInspector structObjectInspector, List<Integer> projectedColumns) throws HiveException {
        List<? extends StructField> fields = structObjectInspector.getAllStructFieldRefs();
        int count = fields.size();
        this.allocateArrays(count);
        for (int i = 0; i < count; ++i) {
            int projectionColumnNum = projectedColumns.get(i);
            StructField field = fields.get(i);
            ObjectInspector fieldInspector = field.getFieldObjectInspector();
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString(fieldInspector.getTypeName());
            this.initTargetEntry(i, projectionColumnNum, typeInfo);
        }
    }

    public void init(StructObjectInspector structObjectInspector) throws HiveException {
        List<? extends StructField> fields = structObjectInspector.getAllStructFieldRefs();
        int count = fields.size();
        this.allocateArrays(count);
        for (int i = 0; i < count; ++i) {
            StructField field = fields.get(i);
            ObjectInspector fieldInspector = field.getFieldObjectInspector();
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString(fieldInspector.getTypeName());
            this.initTargetEntry(i, i, typeInfo);
        }
    }

    public void init(List<String> typeNames) throws HiveException {
        int count = typeNames.size();
        this.allocateArrays(count);
        for (int i = 0; i < count; ++i) {
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString(typeNames.get(i));
            this.initTargetEntry(i, i, typeInfo);
        }
    }

    public int initConversion(TypeInfo[] sourceTypeInfos, TypeInfo[] targetTypeInfos, boolean[] columnsToIncludeTruncated) {
        int targetColumnCount = columnsToIncludeTruncated == null ? targetTypeInfos.length : Math.min(targetTypeInfos.length, columnsToIncludeTruncated.length);
        int sourceColumnCount = Math.min(sourceTypeInfos.length, targetColumnCount);
        this.allocateArrays(sourceColumnCount);
        this.allocateConvertArrays(sourceColumnCount);
        for (int i = 0; i < sourceColumnCount; ++i) {
            TypeInfo targetTypeInfo;
            if (columnsToIncludeTruncated != null && !columnsToIncludeTruncated[i] || (targetTypeInfo = targetTypeInfos[i]).getCategory() != ObjectInspector.Category.PRIMITIVE) continue;
            TypeInfo sourceTypeInfo = sourceTypeInfos[i];
            if (!sourceTypeInfo.equals(targetTypeInfo)) {
                if (VectorPartitionConversion.isImplicitVectorColumnConversion(sourceTypeInfo, targetTypeInfo)) {
                    this.initTargetEntry(i, i, sourceTypeInfo);
                    continue;
                }
                this.initTargetEntry(i, i, targetTypeInfo);
                this.initConvertSourceEntry(i, sourceTypeInfo);
                continue;
            }
            this.initTargetEntry(i, i, targetTypeInfo);
        }
        return sourceColumnCount;
    }

    public void assignRowColumn(VectorizedRowBatch batch, int batchIndex, int logicalColumnIndex, Object object) {
        int projectionColumnNum = this.projectionColumnNums[logicalColumnIndex];
        if (object == null) {
            VectorizedBatchUtil.setNullColIsNullValue(batch.cols[projectionColumnNum], batchIndex);
            return;
        }
        ObjectInspector.Category targetCategory = this.targetCategories[logicalColumnIndex];
        if (targetCategory == null) {
            return;
        }
        block0 : switch (targetCategory) {
            case PRIMITIVE: {
                PrimitiveObjectInspector.PrimitiveCategory targetPrimitiveCategory = this.targetPrimitiveCategories[logicalColumnIndex];
                switch (targetPrimitiveCategory) {
                    case VOID: {
                        VectorizedBatchUtil.setNullColIsNullValue(batch.cols[projectionColumnNum], batchIndex);
                        return;
                    }
                    case BOOLEAN: {
                        ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((BooleanWritable)object).get() ? 1 : 0;
                        break block0;
                    }
                    case BYTE: {
                        ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((ByteWritable)((Object)object)).get();
                        break block0;
                    }
                    case SHORT: {
                        ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((ShortWritable)object).get();
                        break block0;
                    }
                    case INT: {
                        ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((IntWritable)object).get();
                        break block0;
                    }
                    case LONG: {
                        ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((LongWritable)object).get();
                        break block0;
                    }
                    case TIMESTAMP: {
                        ((TimestampColumnVector)batch.cols[projectionColumnNum]).set(batchIndex, ((TimestampWritable)object).getTimestamp());
                        break block0;
                    }
                    case DATE: {
                        ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((DateWritable)object).getDays();
                        break block0;
                    }
                    case FLOAT: {
                        ((DoubleColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((FloatWritable)object).get();
                        break block0;
                    }
                    case DOUBLE: {
                        ((DoubleColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((DoubleWritable)((Object)object)).get();
                        break block0;
                    }
                    case BINARY: {
                        BytesWritable bw = (BytesWritable)object;
                        ((BytesColumnVector)batch.cols[projectionColumnNum]).setVal(batchIndex, bw.getBytes(), 0, bw.getLength());
                        break block0;
                    }
                    case STRING: {
                        Text tw = (Text)object;
                        ((BytesColumnVector)batch.cols[projectionColumnNum]).setVal(batchIndex, tw.getBytes(), 0, tw.getLength());
                        break block0;
                    }
                    case VARCHAR: {
                        HiveVarchar hiveVarchar = object instanceof HiveVarchar ? (HiveVarchar)object : ((HiveVarcharWritable)object).getHiveVarchar();
                        byte[] bytes = hiveVarchar.getValue().getBytes();
                        ((BytesColumnVector)batch.cols[projectionColumnNum]).setVal(batchIndex, bytes, 0, bytes.length);
                        break block0;
                    }
                    case CHAR: {
                        HiveChar hiveChar = object instanceof HiveChar ? (HiveChar)object : ((HiveCharWritable)object).getHiveChar();
                        byte[] bytes = hiveChar.getStrippedValue().getBytes();
                        ((BytesColumnVector)batch.cols[projectionColumnNum]).setVal(batchIndex, bytes, 0, bytes.length);
                        break block0;
                    }
                    case DECIMAL: {
                        if (object instanceof HiveDecimal) {
                            ((DecimalColumnVector)batch.cols[projectionColumnNum]).set(batchIndex, (HiveDecimal)object);
                            break block0;
                        }
                        ((DecimalColumnVector)batch.cols[projectionColumnNum]).set(batchIndex, (HiveDecimalWritable)object);
                        break block0;
                    }
                    case INTERVAL_YEAR_MONTH: {
                        ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((HiveIntervalYearMonthWritable)object).getHiveIntervalYearMonth().getTotalMonths();
                        break block0;
                    }
                    case INTERVAL_DAY_TIME: {
                        ((IntervalDayTimeColumnVector)batch.cols[projectionColumnNum]).set(batchIndex, ((HiveIntervalDayTimeWritable)object).getHiveIntervalDayTime());
                        break block0;
                    }
                }
                throw new RuntimeException("Primitive category " + targetPrimitiveCategory.name() + " not supported");
            }
            default: {
                throw new RuntimeException("Category " + targetCategory.name() + " not supported");
            }
        }
        batch.cols[projectionColumnNum].isNull[batchIndex] = false;
    }

    public void assignConvertRowColumn(VectorizedRowBatch batch, int batchIndex, int logicalColumnIndex, Object object) {
        Preconditions.checkState(this.isConvert[logicalColumnIndex]);
        int projectionColumnNum = this.projectionColumnNums[logicalColumnIndex];
        if (object == null) {
            VectorizedBatchUtil.setNullColIsNullValue(batch.cols[projectionColumnNum], batchIndex);
            return;
        }
        try {
            ObjectInspector.Category targetCategory = this.targetCategories[logicalColumnIndex];
            if (targetCategory == null) {
                return;
            }
            block1 : switch (targetCategory) {
                case PRIMITIVE: {
                    PrimitiveObjectInspector.PrimitiveCategory targetPrimitiveCategory = this.targetPrimitiveCategories[logicalColumnIndex];
                    switch (targetPrimitiveCategory) {
                        case VOID: {
                            VectorizedBatchUtil.setNullColIsNullValue(batch.cols[projectionColumnNum], batchIndex);
                            return;
                        }
                        case BOOLEAN: {
                            ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = PrimitiveObjectInspectorUtils.getBoolean(object, this.convertSourcePrimitiveObjectInspectors[logicalColumnIndex]) ? 1 : 0;
                            break block1;
                        }
                        case BYTE: {
                            ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = PrimitiveObjectInspectorUtils.getByte(object, this.convertSourcePrimitiveObjectInspectors[logicalColumnIndex]);
                            break block1;
                        }
                        case SHORT: {
                            ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = PrimitiveObjectInspectorUtils.getShort(object, this.convertSourcePrimitiveObjectInspectors[logicalColumnIndex]);
                            break block1;
                        }
                        case INT: {
                            ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = PrimitiveObjectInspectorUtils.getInt(object, this.convertSourcePrimitiveObjectInspectors[logicalColumnIndex]);
                            break block1;
                        }
                        case LONG: {
                            ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = PrimitiveObjectInspectorUtils.getLong(object, this.convertSourcePrimitiveObjectInspectors[logicalColumnIndex]);
                            break block1;
                        }
                        case TIMESTAMP: {
                            Timestamp timestamp = PrimitiveObjectInspectorUtils.getTimestamp(object, this.convertSourcePrimitiveObjectInspectors[logicalColumnIndex]);
                            if (timestamp == null) {
                                VectorizedBatchUtil.setNullColIsNullValue(batch.cols[projectionColumnNum], batchIndex);
                                return;
                            }
                            ((TimestampColumnVector)batch.cols[projectionColumnNum]).set(batchIndex, timestamp);
                            break block1;
                        }
                        case DATE: {
                            Date date = PrimitiveObjectInspectorUtils.getDate(object, this.convertSourcePrimitiveObjectInspectors[logicalColumnIndex]);
                            if (date == null) {
                                VectorizedBatchUtil.setNullColIsNullValue(batch.cols[projectionColumnNum], batchIndex);
                                return;
                            }
                            DateWritable dateWritable = (DateWritable)this.convertTargetWritables[logicalColumnIndex];
                            dateWritable.set(date);
                            ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = dateWritable.getDays();
                            break block1;
                        }
                        case FLOAT: {
                            ((DoubleColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = PrimitiveObjectInspectorUtils.getFloat(object, this.convertSourcePrimitiveObjectInspectors[logicalColumnIndex]);
                            break block1;
                        }
                        case DOUBLE: {
                            ((DoubleColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = PrimitiveObjectInspectorUtils.getDouble(object, this.convertSourcePrimitiveObjectInspectors[logicalColumnIndex]);
                            break block1;
                        }
                        case BINARY: {
                            BytesWritable bytesWritable = PrimitiveObjectInspectorUtils.getBinary(object, this.convertSourcePrimitiveObjectInspectors[logicalColumnIndex]);
                            if (bytesWritable == null) {
                                VectorizedBatchUtil.setNullColIsNullValue(batch.cols[projectionColumnNum], batchIndex);
                                return;
                            }
                            ((BytesColumnVector)batch.cols[projectionColumnNum]).setVal(batchIndex, bytesWritable.getBytes(), 0, bytesWritable.getLength());
                            break block1;
                        }
                        case STRING: {
                            String string = PrimitiveObjectInspectorUtils.getString(object, this.convertSourcePrimitiveObjectInspectors[logicalColumnIndex]);
                            if (string == null) {
                                VectorizedBatchUtil.setNullColIsNullValue(batch.cols[projectionColumnNum], batchIndex);
                                return;
                            }
                            Text text = (Text)this.convertTargetWritables[logicalColumnIndex];
                            text.set(string);
                            ((BytesColumnVector)batch.cols[projectionColumnNum]).setVal(batchIndex, text.getBytes(), 0, text.getLength());
                            break block1;
                        }
                        case VARCHAR: {
                            HiveVarchar hiveVarchar = PrimitiveObjectInspectorUtils.getHiveVarchar(object, this.convertSourcePrimitiveObjectInspectors[logicalColumnIndex]);
                            if (hiveVarchar == null) {
                                VectorizedBatchUtil.setNullColIsNullValue(batch.cols[projectionColumnNum], batchIndex);
                                return;
                            }
                            byte[] bytes = hiveVarchar.getValue().getBytes();
                            ((BytesColumnVector)batch.cols[projectionColumnNum]).setVal(batchIndex, bytes, 0, bytes.length);
                            break block1;
                        }
                        case CHAR: {
                            HiveChar hiveChar = PrimitiveObjectInspectorUtils.getHiveChar(object, this.convertSourcePrimitiveObjectInspectors[logicalColumnIndex]);
                            if (hiveChar == null) {
                                VectorizedBatchUtil.setNullColIsNullValue(batch.cols[projectionColumnNum], batchIndex);
                                return;
                            }
                            byte[] bytes = hiveChar.getStrippedValue().getBytes();
                            ((BytesColumnVector)batch.cols[projectionColumnNum]).setVal(batchIndex, bytes, 0, bytes.length);
                            break block1;
                        }
                        case DECIMAL: {
                            HiveDecimal hiveDecimal = PrimitiveObjectInspectorUtils.getHiveDecimal(object, this.convertSourcePrimitiveObjectInspectors[logicalColumnIndex]);
                            if (hiveDecimal == null) {
                                VectorizedBatchUtil.setNullColIsNullValue(batch.cols[projectionColumnNum], batchIndex);
                                return;
                            }
                            ((DecimalColumnVector)batch.cols[projectionColumnNum]).set(batchIndex, hiveDecimal);
                            break block1;
                        }
                        case INTERVAL_YEAR_MONTH: {
                            HiveIntervalYearMonth intervalYearMonth = PrimitiveObjectInspectorUtils.getHiveIntervalYearMonth(object, this.convertSourcePrimitiveObjectInspectors[logicalColumnIndex]);
                            if (intervalYearMonth == null) {
                                VectorizedBatchUtil.setNullColIsNullValue(batch.cols[projectionColumnNum], batchIndex);
                                return;
                            }
                            ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = intervalYearMonth.getTotalMonths();
                            break block1;
                        }
                        case INTERVAL_DAY_TIME: {
                            HiveIntervalDayTime intervalDayTime = PrimitiveObjectInspectorUtils.getHiveIntervalDayTime(object, this.convertSourcePrimitiveObjectInspectors[logicalColumnIndex]);
                            if (intervalDayTime == null) {
                                VectorizedBatchUtil.setNullColIsNullValue(batch.cols[projectionColumnNum], batchIndex);
                                return;
                            }
                            ((IntervalDayTimeColumnVector)batch.cols[projectionColumnNum]).set(batchIndex, intervalDayTime);
                            break block1;
                        }
                    }
                    throw new RuntimeException("Primitive category " + targetPrimitiveCategory.name() + " not supported");
                }
                default: {
                    throw new RuntimeException("Category " + targetCategory.name() + " not supported");
                }
            }
        }
        catch (NumberFormatException e) {
            VectorizedBatchUtil.setNullColIsNullValue(batch.cols[projectionColumnNum], batchIndex);
            return;
        }
        batch.cols[projectionColumnNum].isNull[batchIndex] = false;
    }

    public void assignRow(VectorizedRowBatch batch, int batchIndex, Object[] objects) {
        int count = this.isConvert.length;
        for (int i = 0; i < count; ++i) {
            if (this.isConvert[i]) {
                this.assignConvertRowColumn(batch, batchIndex, i, objects[i]);
                continue;
            }
            this.assignRowColumn(batch, batchIndex, i, objects[i]);
        }
    }

    public void assignRow(VectorizedRowBatch batch, int batchIndex, List<Object> standardObjects, int columnCount) {
        for (int i = 0; i < columnCount; ++i) {
            if (this.isConvert[i]) {
                this.assignConvertRowColumn(batch, batchIndex, i, standardObjects.get(i));
                continue;
            }
            this.assignRowColumn(batch, batchIndex, i, standardObjects.get(i));
        }
    }
}

