/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveClientCache;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hive.common.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetaStoreUtils {
    protected static final Logger LOG = LoggerFactory.getLogger((String)"hive.log");
    private static volatile HiveClientCache hiveClientCache;
    private static final String FROM_SERIALIZER = "from deserializer";

    public static Deserializer getDeserializer(Configuration conf, Table table, boolean skipConfError) throws MetaException {
        String lib = table.getSd().getSerdeInfo().getSerializationLib();
        if (lib == null) {
            return null;
        }
        return HiveMetaStoreUtils.getDeserializer(conf, table, skipConfError, lib);
    }

    public static Deserializer getDeserializer(Configuration conf, Table table, boolean skipConfError, String lib) throws MetaException {
        try {
            Deserializer deserializer = (Deserializer)ReflectionUtil.newInstance(conf.getClassByName(lib).asSubclass(Deserializer.class), (Configuration)conf);
            if (skipConfError) {
                SerDeUtils.initializeSerDeWithoutErrorCheck((Deserializer)deserializer, (Configuration)conf, (Properties)MetaStoreUtils.getTableMetadata((Table)table), null);
            } else {
                SerDeUtils.initializeSerDe((Deserializer)deserializer, (Configuration)conf, (Properties)MetaStoreUtils.getTableMetadata((Table)table), null);
            }
            return deserializer;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error("error in initSerDe: " + e.getClass().getName() + " " + e.getMessage(), e);
            throw new MetaException(e.getClass().getName() + " " + e.getMessage());
        }
    }

    public static Class<? extends Deserializer> getDeserializerClass(Configuration conf, Table table) throws Exception {
        String lib = table.getSd().getSerdeInfo().getSerializationLib();
        return lib == null ? null : conf.getClassByName(lib).asSubclass(Deserializer.class);
    }

    public static Deserializer getDeserializer(Configuration conf, Partition part, Table table) throws MetaException {
        String lib = part.getSd().getSerdeInfo().getSerializationLib();
        try {
            Deserializer deserializer = (Deserializer)ReflectionUtil.newInstance(conf.getClassByName(lib).asSubclass(Deserializer.class), (Configuration)conf);
            SerDeUtils.initializeSerDe((Deserializer)deserializer, (Configuration)conf, (Properties)MetaStoreUtils.getTableMetadata((Table)table), (Properties)MetaStoreUtils.getPartitionMetadata((Partition)part, (Table)table));
            return deserializer;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error("error in initSerDe: " + e.getClass().getName() + " " + e.getMessage(), e);
            throw new MetaException(e.getClass().getName() + " " + e.getMessage());
        }
    }

    public static List<FieldSchema> getFieldsFromDeserializer(String tableName, Deserializer deserializer) throws SerDeException, MetaException {
        ObjectInspector oi = deserializer.getObjectInspector();
        String[] names = tableName.split("\\.");
        String last_name = names[names.length - 1];
        for (int i = 1; i < names.length; ++i) {
            MapObjectInspector moi;
            if (oi instanceof StructObjectInspector) {
                StructObjectInspector soi = (StructObjectInspector)oi;
                StructField sf = soi.getStructFieldRef(names[i]);
                if (sf == null) {
                    throw new MetaException("Invalid Field " + names[i]);
                }
                oi = sf.getFieldObjectInspector();
                continue;
            }
            if (oi instanceof ListObjectInspector && names[i].equalsIgnoreCase("$elem$")) {
                ListObjectInspector loi = (ListObjectInspector)oi;
                oi = loi.getListElementObjectInspector();
                continue;
            }
            if (oi instanceof MapObjectInspector && names[i].equalsIgnoreCase("$key$")) {
                moi = (MapObjectInspector)oi;
                oi = moi.getMapKeyObjectInspector();
                continue;
            }
            if (oi instanceof MapObjectInspector && names[i].equalsIgnoreCase("$value$")) {
                moi = (MapObjectInspector)oi;
                oi = moi.getMapValueObjectInspector();
                continue;
            }
            throw new MetaException("Unknown type for " + names[i]);
        }
        ArrayList<FieldSchema> str_fields = new ArrayList<FieldSchema>();
        if (oi.getCategory() != ObjectInspector.Category.STRUCT) {
            str_fields.add(new FieldSchema(last_name, oi.getTypeName(), FROM_SERIALIZER));
        } else {
            List fields = ((StructObjectInspector)oi).getAllStructFieldRefs();
            for (int i = 0; i < fields.size(); ++i) {
                StructField structField = (StructField)fields.get(i);
                String fieldName = structField.getFieldName();
                String fieldTypeName = structField.getFieldObjectInspector().getTypeName();
                String fieldComment = HiveMetaStoreUtils.determineFieldComment(structField.getFieldComment());
                str_fields.add(new FieldSchema(fieldName, fieldTypeName, fieldComment));
            }
        }
        return str_fields;
    }

    private static String determineFieldComment(String comment) {
        return comment == null ? FROM_SERIALIZER : comment;
    }

    public static FieldSchema getFieldSchemaFromTypeInfo(String fieldName, TypeInfo typeInfo) {
        return new FieldSchema(fieldName, typeInfo.getTypeName(), "generated by TypeInfoUtils.getFieldSchemaFromTypeInfo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static IMetaStoreClient getHiveMetastoreClient(HiveConf hiveConf) throws MetaException, IOException {
        if (!HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_CLIENT_CACHE_ENABLED)) {
            return HiveClientCache.getNonCachedHiveMetastoreClient(hiveConf);
        }
        if (hiveClientCache == null) {
            Class<IMetaStoreClient> clazz = IMetaStoreClient.class;
            // MONITORENTER : org.apache.hadoop.hive.metastore.IMetaStoreClient.class
            if (hiveClientCache == null) {
                hiveClientCache = new HiveClientCache(hiveConf);
            }
            // MONITOREXIT : clazz
        }
        try {
            return hiveClientCache.get(hiveConf);
        }
        catch (LoginException e) {
            throw new IOException("Couldn't create hiveMetaStoreClient, Error getting UGI for user", e);
        }
    }
}

