/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.graph;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.pentaho.metaverse.graph.BaseGraphWriter;

public class GraphCsvWriter
extends BaseGraphWriter {
    private static final String CSV_ENCLOSURE = "\"";

    @Override
    public void outputGraphImpl(Graph graph, OutputStream out) throws IOException {
        Iterable iterable = graph.getEdges();
        Iterator it = iterable.iterator();
        this.writeCSVField("SourceId", out, true, false);
        this.writeCSVField("SourceVirtual", out, false, false);
        this.writeCSVField("SourceFileType", out, false, false);
        this.writeCSVField("SourceName", out, false, false);
        this.writeCSVField("SourceAuthor", out, false, false);
        this.writeCSVField("SourceModified", out, false, false);
        this.writeCSVField("LinkType", out, false, false);
        this.writeCSVField("DestinationId", out, false, false);
        this.writeCSVField("DestinationVirtual", out, false, false);
        this.writeCSVField("DestinationFileType", out, false, false);
        this.writeCSVField("DestinationName", out, false, false);
        this.writeCSVField("DestinationAuthor", out, false, false);
        this.writeCSVField("DestinationModified", out, false, true);
        while (it.hasNext()) {
            Edge edge = (Edge)it.next();
            Vertex fromV = edge.getVertex(Direction.OUT);
            Vertex toV = edge.getVertex(Direction.IN);
            this.writeCSVField(fromV.getId(), out, true, false);
            this.writeCSVField(fromV.getProperty("virtual"), out, false, false);
            this.writeCSVField(fromV.getProperty("type"), out, false, false);
            this.writeCSVField(fromV.getProperty("name"), out, false, false);
            this.writeCSVField(fromV.getProperty("author"), out, false, false);
            this.writeCSVField(fromV.getProperty("lastmodified"), out, false, false);
            this.writeCSVField(edge.getLabel(), out, false, false);
            this.writeCSVField(toV.getId(), out, false, false);
            this.writeCSVField(toV.getProperty("virtual"), out, false, false);
            this.writeCSVField(toV.getProperty("type"), out, false, false);
            this.writeCSVField(toV.getProperty("name"), out, false, false);
            this.writeCSVField(toV.getProperty("author"), out, false, false);
            this.writeCSVField(toV.getProperty("lastmodified"), out, false, true);
        }
    }

    protected void writeCSVField(Object obj, OutputStream out, boolean isFirst, boolean isLast) throws IOException {
        if (!isFirst) {
            out.write(",".getBytes());
        }
        if (obj != null) {
            if (obj instanceof String) {
                out.write(CSV_ENCLOSURE.getBytes());
                out.write(obj.toString().replace(CSV_ENCLOSURE, "\\\"").getBytes());
                out.write(CSV_ENCLOSURE.getBytes());
            } else {
                out.write(obj.toString().getBytes());
            }
        }
        if (isLast) {
            out.write("\n".getBytes());
        }
    }
}

