/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.textfileoutput;

import java.util.HashSet;
import java.util.Set;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.textfileoutput.TextFileField;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputMeta;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.IMetaverseObjectFactory;
import org.pentaho.metaverse.api.MetaverseException;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.step.ExternalResourceStepAnalyzer;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextFileOutputStepAnalyzer
extends ExternalResourceStepAnalyzer<TextFileOutputMeta> {
    private Logger log = LoggerFactory.getLogger(TextFileOutputStepAnalyzer.class);

    protected Set<StepField> getUsedFields(TextFileOutputMeta meta) {
        HashSet<StepField> usedFields = new HashSet<StepField>();
        if (meta.isFileNameInField()) {
            usedFields.addAll(this.createStepFields(meta.getFileNameField(), this.getInputs()));
        }
        return usedFields;
    }

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        return new HashSet<Class<? extends BaseStepMeta>>(){
            {
                this.add(TextFileOutputMeta.class);
            }
        };
    }

    public String getResourceInputNodeType() {
        return null;
    }

    public String getResourceOutputNodeType() {
        return "File Field";
    }

    public boolean isOutput() {
        return true;
    }

    public boolean isInput() {
        return false;
    }

    public IMetaverseNode createResourceNode(IExternalResourceInfo resource) throws MetaverseException {
        return this.createFileNode(resource.getName(), this.descriptor);
    }

    public Set<String> getOutputResourceFields(TextFileOutputMeta meta) {
        HashSet<String> fields = new HashSet<String>();
        TextFileField[] outputFields = meta.getOutputFields();
        for (int i = 0; i < outputFields.length; ++i) {
            TextFileField outputField = outputFields[i];
            fields.add(outputField.getName());
        }
        return fields;
    }

    protected void setObjectFactory(IMetaverseObjectFactory factory) {
        this.metaverseObjectFactory = factory;
    }
}

