/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import org.apache.sshd.SshServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshServerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SshServerFactory.class);
    private long idleTimeout;
    private boolean start;
    private SshServer server;
    private String welcomeBanner;

    public SshServerFactory(SshServer server) {
        this.server = server;
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public String getWelcomeBanner() {
        return this.welcomeBanner;
    }

    public void setWelcomeBanner(String welcomeBanner) {
        this.welcomeBanner = welcomeBanner;
    }

    public void start() {
        if (this.start) {
            try {
                this.server.getProperties().put("idle-timeout", new Long(this.idleTimeout).toString());
                if (this.getWelcomeBanner() != null && !this.getWelcomeBanner().isEmpty()) {
                    this.server.getProperties().put("welcome-banner", this.getWelcomeBanner());
                }
                this.server.start();
            }
            catch (Exception e) {
                LOGGER.info("Error updating SSH server", (Throwable)e);
            }
        }
    }

    public void stop() {
        if (this.start && this.server != null) {
            try {
                this.server.stop(true);
            }
            catch (Exception e) {
                LOGGER.info("Error stopping SSH server", (Throwable)e);
            }
            finally {
                this.server = null;
            }
        }
    }
}

