/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.shell;

import java.util.HashMap;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.SubsetConfiguration;

public class ClientContext {
    private final Configuration configuration = new MapConfiguration(new HashMap());
    private final PoolContext poolContext = new PoolContext(this);
    private final SocketContext socketContext = new SocketContext(this);
    private final ConnectionContext connectionContext = new ConnectionContext(this);

    private ClientContext() {
    }

    public PoolContext pool() {
        return this.poolContext;
    }

    public SocketContext socket() {
        return this.socketContext;
    }

    public ConnectionContext connection() {
        return this.connectionContext;
    }

    public static ClientContext with(String username, String password, String url) {
        ClientContext context = new ClientContext();
        context.configuration.addProperty("username", (Object)username);
        context.configuration.addProperty("password", (Object)password);
        context.configuration.addProperty("url", (Object)url);
        return context;
    }

    public static ClientContext with(String url) {
        ClientContext context = new ClientContext();
        context.configuration.addProperty("url", (Object)url);
        return context;
    }

    public String username() {
        return this.configuration.getString("username");
    }

    public String password() {
        return this.configuration.getString("password");
    }

    public String url() {
        return this.configuration.getString("url");
    }

    public static class ConnectionContext
    extends Context {
        private ConnectionContext(ClientContext clientContext) {
            super(clientContext, "connection");
        }

        public int timeout() {
            return this.configuration.getInt("timeout", 0);
        }

        public ConnectionContext timeout(int timeout) {
            this.configuration.addProperty("timeout", (Object)timeout);
            return this;
        }

        public boolean staleChecking() {
            return this.configuration.getBoolean("stalecheck", true);
        }

        public ConnectionContext staleChecking(boolean value) {
            this.configuration.addProperty("stalecheck", (Object)value);
            return this;
        }

        public boolean secure() {
            return this.configuration.getBoolean("secure", true);
        }

        public ConnectionContext secure(boolean value) {
            this.configuration.addProperty("secure", (Object)value);
            return this;
        }

        public int bufferSize() {
            return this.configuration.getInt("buffer-size", -1);
        }

        public ConnectionContext bufferSize(int size) {
            this.configuration.addProperty("buffer-size", (Object)size);
            return this;
        }
    }

    public static class SocketContext
    extends Context {
        private SocketContext(ClientContext clientContext) {
            super(clientContext, "socket");
        }

        public int timeout() {
            return this.configuration.getInt("timeout", 0);
        }

        public SocketContext timeout(int timeout) {
            this.configuration.addProperty("timeout", (Object)timeout);
            return this;
        }

        public boolean reuseAddress() {
            return this.configuration.getBoolean("reuse-address", false);
        }

        public SocketContext reuseAddress(boolean reuseAddress) {
            this.configuration.addProperty("reuse-address", (Object)reuseAddress);
            return this;
        }

        public int linger() {
            return this.configuration.getInt("linger", -1);
        }

        public SocketContext linger(int value) {
            this.configuration.addProperty("linger", (Object)value);
            return this;
        }

        public boolean keepalive() {
            return this.configuration.getBoolean("keepalive", false);
        }

        public SocketContext keepalive(boolean enableKeepalive) {
            this.configuration.addProperty("keepalive", (Object)enableKeepalive);
            return this;
        }

        public boolean tcpNoDelay() {
            return this.configuration.getBoolean("nodelay", true);
        }

        public SocketContext tcpNoDelay(boolean value) {
            this.configuration.addProperty("nodelay", (Object)value);
            return this;
        }
    }

    public static class PoolContext
    extends Context {
        private PoolContext(ClientContext clientContext) {
            super(clientContext, "pool");
        }

        public int maxTotal() {
            return this.configuration.getInt("total", 20);
        }

        public PoolContext maxTotal(int timeout) {
            this.configuration.addProperty("total", (Object)timeout);
            return this;
        }

        public int defaultMaxPerRoute() {
            return this.configuration.getInt("max-per-route", 20);
        }

        public PoolContext defaultMaxPerRoute(int reuseaddr) {
            this.configuration.addProperty("max-per-route", (Object)reuseaddr);
            return this;
        }
    }

    private static class Context {
        private final ClientContext clientContext;
        protected final Configuration configuration;

        private Context(ClientContext clientContext, String prefix) {
            this.clientContext = clientContext;
            this.configuration = new SubsetConfiguration(clientContext.configuration, prefix);
        }

        public ClientContext end() {
            return this.clientContext;
        }
    }
}

