/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.legacy.charts.propertyeditor;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.libraries.designtime.swing.BasicFontPropertiesPane;

public class FontStringPropertyEditor
implements PropertyEditor {
    private String value;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private BasicFontPropertiesPane basicFontPropertiesPane;

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void setValue(Object value) {
        String oldValue = this.value;
        this.value = value instanceof String ? (String)value : null;
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.value);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getJavaInitializationString() {
        return null;
    }

    @Override
    public String getAsText() {
        return this.value;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(text);
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        if (this.basicFontPropertiesPane == null) {
            this.basicFontPropertiesPane = new BasicFontPropertiesPane();
            this.basicFontPropertiesPane.setExtendedFontPropertiesShowing(false);
            this.basicFontPropertiesPane.init();
            this.basicFontPropertiesPane.addChangeListener((ChangeListener)new FontPropertiesHandler());
        }
        if (this.value != null) {
            Font font = Font.decode(this.value);
            this.basicFontPropertiesPane.setFontFamily(font.getFamily());
            this.basicFontPropertiesPane.setFontStyle(font.getStyle());
            this.basicFontPropertiesPane.setFontSize(font.getSize());
        }
        return this.basicFontPropertiesPane;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    private class FontPropertiesHandler
    implements ChangeListener {
        private FontPropertiesHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            String fontName = FontStringPropertyEditor.this.basicFontPropertiesPane.getFontFamily();
            int fontSize = FontStringPropertyEditor.this.basicFontPropertiesPane.getFontSize();
            int fontStyle = FontStringPropertyEditor.this.basicFontPropertiesPane.getFontStyle();
            String fontStyleText = (fontStyle & 3) == 3 ? "BOLDITALIC" : ((fontStyle & 1) == 1 ? "BOLD" : ((fontStyle & 2) == 2 ? "ITALIC" : "PLAIN"));
            FontStringPropertyEditor.this.setValue(fontName + "-" + fontStyleText + "-" + fontSize);
        }
    }
}

