/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;

public class ColorHelper {
    private static final Map<String, Color> colors = new HashMap<String, Color>();

    private ColorHelper() {
    }

    public static String lookupName(Color c) {
        if (c == null) {
            return null;
        }
        for (Map.Entry<String, Color> entry : colors.entrySet()) {
            if (!((Object)entry.getValue()).equals(c)) continue;
            return entry.getKey();
        }
        String color = Integer.toHexString(c.getRGB() & 0xFFFFFF);
        StringBuilder retval = new StringBuilder(7);
        retval.append('#');
        int fillUp = 6 - color.length();
        for (int i = 0; i < fillUp; ++i) {
            retval.append('0');
        }
        retval.append(color);
        return retval.toString();
    }

    public static Color lookupColor(String col) {
        if (col == null) {
            return null;
        }
        return ColorHelper.lookupColor(col.toLowerCase(), null);
    }

    public static Color lookupColor(String col, Color def) {
        if (col == null) {
            return def;
        }
        Color rtn = colors.get(col.toLowerCase());
        return rtn != null ? rtn : def;
    }

    static {
        colors.put("alice blue", Color.decode("#f0f8ff"));
        colors.put("antique white", Color.decode("#faebd7"));
        colors.put("aquamarine", Color.decode("#7fffd4"));
        colors.put("azure", Color.decode("#f0ffff"));
        colors.put("beige", Color.decode("#f5f5dc"));
        colors.put("bisque", Color.decode("#ffe4c4"));
        colors.put("black", Color.decode("#000000"));
        colors.put("blanched almond", Color.decode("#ffebcd"));
        colors.put("blue", Color.decode("#0000ff"));
        colors.put("blue violet", Color.decode("#8a2be2"));
        colors.put("brown", Color.decode("#a52a2a"));
        colors.put("burlywood", Color.decode("#deb887"));
        colors.put("cadet blue", Color.decode("#5f9ea0"));
        colors.put("chartreuse", Color.decode("#7fff00"));
        colors.put("chocolate", Color.decode("#d2691e"));
        colors.put("coral", Color.decode("#ff7f50"));
        colors.put("cornflower blue", Color.decode("#6495ed"));
        colors.put("cornsilk", Color.decode("#fff8dc"));
        colors.put("crimson", Color.decode("#dc143c"));
        colors.put("cyan", Color.decode("#00ffff"));
        colors.put("dark blue", Color.decode("#00008b"));
        colors.put("dark cyan", Color.decode("#008b8b"));
        colors.put("dark goldenrod", Color.decode("#b8860b"));
        colors.put("dark gray", Color.decode("#a9a9a9"));
        colors.put("dark green", Color.decode("#006400"));
        colors.put("dark khaki", Color.decode("#bdb76b"));
        colors.put("dark magenta", Color.decode("#8b008b"));
        colors.put("dark olive green", Color.decode("#556b2f"));
        colors.put("dark orange", Color.decode("#ff8c00"));
        colors.put("dark orchid", Color.decode("#9932cc"));
        colors.put("dark red", Color.decode("#8b0000"));
        colors.put("dark salmon", Color.decode("#e9967a"));
        colors.put("dark seagreen", Color.decode("#8dbc8f"));
        colors.put("dark slate blue", Color.decode("#483d8b"));
        colors.put("dark slate gray", Color.decode("#2f4f4f"));
        colors.put("dark turquoise", Color.decode("#00ded1"));
        colors.put("dark violet", Color.decode("#9400d3"));
        colors.put("deep pink", Color.decode("#ff1493"));
        colors.put("deep sky blue", Color.decode("#00bfff"));
        colors.put("dim gray", Color.decode("#696969"));
        colors.put("dodger blue", Color.decode("#1e90ff"));
        colors.put("firebrick", Color.decode("#b22222"));
        colors.put("floral white", Color.decode("#fffaf0"));
        colors.put("forest green", Color.decode("#228b22"));
        colors.put("gainsboro", Color.decode("#dcdcdc"));
        colors.put("ghost white", Color.decode("#f8f8ff"));
        colors.put("gold", Color.decode("#ffd700"));
        colors.put("goldenrod", Color.decode("#daa520"));
        colors.put("gray", Color.decode("#808080"));
        if (!ClassicEngineBoot.getInstance().getExtendedConfig().getBoolProperty("org.pentaho.reporting.engine.classic.extensions.legacy.charts.LegacyColorMode")) {
            colors.put("green", Color.decode("#00ff00"));
        } else {
            colors.put("green", Color.decode("#008000"));
        }
        colors.put("green yellow", Color.decode("#adff2f"));
        colors.put("honeydew", Color.decode("#f0fff0"));
        colors.put("hot pink", Color.decode("#ff69b4"));
        colors.put("indian red", Color.decode("#cd5c5c"));
        colors.put("indigo", Color.decode("#4b0082"));
        colors.put("ivory", Color.decode("#fffff0"));
        colors.put("khaki", Color.decode("#f0e68c"));
        colors.put("lavender", Color.decode("#e6e6fa"));
        colors.put("lavender blush", Color.decode("#fff0f5"));
        colors.put("lawngreen", Color.decode("#7cfc00"));
        colors.put("lemon chiffon", Color.decode("#fffacd"));
        colors.put("lime", Color.decode("#00ff00"));
        colors.put("light blue", Color.decode("#add8e6"));
        colors.put("light coral", Color.decode("#f08080"));
        colors.put("light cyan", Color.decode("#e0ffff"));
        colors.put("light goldenrod yellow", Color.decode("#fafad2"));
        colors.put("light green", Color.decode("#90ee90"));
        colors.put("light grey", Color.decode("#d3d3d3"));
        colors.put("light pink", Color.decode("#ffb6c1"));
        colors.put("light salmon", Color.decode("#ffa07a"));
        colors.put("light seagreen", Color.decode("#20b2aa"));
        colors.put("light sky blue", Color.decode("#87cefa"));
        colors.put("light slate gray", Color.decode("#778899"));
        colors.put("light steel blue", Color.decode("#b0c4de"));
        colors.put("light yellow", Color.decode("#ffffe0"));
        colors.put("lime green", Color.decode("#32cd32"));
        colors.put("linen", Color.decode("#faf0e6"));
        colors.put("magenta", Color.decode("#ff00ff"));
        colors.put("maroon", Color.decode("#800000"));
        colors.put("medium aquamarine", Color.decode("#66cdaa"));
        colors.put("medium blue", Color.decode("#0000cd"));
        colors.put("medium orchid", Color.decode("#ba55d3"));
        colors.put("medium purple", Color.decode("#9370db"));
        colors.put("medium sea green", Color.decode("#3cb371"));
        colors.put("medium slate blue", Color.decode("#7b68ee"));
        colors.put("medium spring green", Color.decode("#00fa9a"));
        colors.put("medium turquoise", Color.decode("#48d1cc"));
        colors.put("medium violet red", Color.decode("#c71585"));
        colors.put("midnight blue", Color.decode("#191970"));
        colors.put("mint cream", Color.decode("#f5fffa"));
        colors.put("misty rose", Color.decode("#ffe4e1"));
        colors.put("moccasin", Color.decode("#ffe4b5"));
        colors.put("navajo white", Color.decode("#ffdead"));
        colors.put("navy", Color.decode("#000080"));
        colors.put("old lace", Color.decode("#fdf5e6"));
        colors.put("olive drab", Color.decode("#6b8e23"));
        colors.put("orange", Color.decode("#ffa500"));
        colors.put("orange red", Color.decode("#ff4500"));
        colors.put("orchid", Color.decode("#da70d6"));
        colors.put("pale goldenrod", Color.decode("#eee8aa"));
        colors.put("pale green", Color.decode("#98fb98"));
        colors.put("pale turquoise", Color.decode("#afeeee"));
        colors.put("pale violet red", Color.decode("#db7093"));
        colors.put("papaya whip", Color.decode("#ffefd5"));
        colors.put("peach puff", Color.decode("#ffdab9"));
        colors.put("peru", Color.decode("#cd853f"));
        colors.put("pink", Color.decode("#ffc8cb"));
        colors.put("plum", Color.decode("#dda0dd"));
        colors.put("powder blue", Color.decode("#b0e0e6"));
        colors.put("purple", Color.decode("#800080"));
        colors.put("red", Color.decode("#ff0000"));
        colors.put("rosy brown", Color.decode("#bc8f8f"));
        colors.put("royal blue", Color.decode("#4169e1"));
        colors.put("saddle brown", Color.decode("#8b4513"));
        colors.put("salmon", Color.decode("#fa8072"));
        colors.put("sandy brown", Color.decode("#f4a460"));
        colors.put("sea green", Color.decode("#2e8b57"));
        colors.put("sea shell", Color.decode("#fff5ee"));
        colors.put("sienna", Color.decode("#a0522d"));
        colors.put("silver", Color.decode("#c0c0c0"));
        colors.put("sky blue", Color.decode("#87ceeb"));
        colors.put("slate blue", Color.decode("#6a5acd"));
        colors.put("snow", Color.decode("#fffafa"));
        colors.put("spring green", Color.decode("#00ff7f"));
        colors.put("steelblue", Color.decode("#4682b4"));
        colors.put("tan", Color.decode("#d2b48c"));
        colors.put("teal", Color.decode("#008080"));
        colors.put("thistle", Color.decode("#d8bfd8"));
        colors.put("tomato", Color.decode("#ff6347"));
        colors.put("turquoise", Color.decode("#40e0d0"));
        colors.put("violet", Color.decode("#ee82ee"));
        colors.put("wheat", Color.decode("#f5deb3"));
        colors.put("white", Color.decode("#ffffff"));
        colors.put("whitesmoke", Color.decode("#f5f5f5"));
        colors.put("yellow", Color.decode("#ffff00"));
        colors.put("yellow green", Color.decode("#9acd32"));
    }
}

