/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.List;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.coord.CoordActionUpdateXCommand;
import org.apache.oozie.command.wf.NotificationXCommand;
import org.apache.oozie.command.wf.WorkflowXCommand;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionRetryManualGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobUpdateJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.InstrumentUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.lite.LiteWorkflowInstance;

public class SuspendXCommand
extends WorkflowXCommand<Void> {
    private final String wfid;
    private WorkflowJobBean wfJobBean;
    private JPAService jpaService;

    public SuspendXCommand(String id) {
        super("suspend", "suspend", 1);
        this.wfid = ParamChecker.notEmpty(id, "wfid");
    }

    @Override
    protected Void execute() throws CommandException {
        InstrumentUtils.incrJobCounter(this.getName(), 1, this.getInstrumentation());
        try {
            SuspendXCommand.suspendJob(this.jpaService, this.wfJobBean, this.wfid, null);
            this.jpaService.execute(new WorkflowJobUpdateJPAExecutor(this.wfJobBean));
            this.queue(new NotificationXCommand(this.wfJobBean));
        }
        catch (WorkflowException e) {
            throw new CommandException(e);
        }
        catch (JPAExecutorException je) {
            throw new CommandException(je);
        }
        finally {
            new CoordActionUpdateXCommand(this.wfJobBean).call();
        }
        return null;
    }

    public static void suspendJob(JPAService jpaService, WorkflowJobBean workflow, String id, String actionId) throws WorkflowException, CommandException {
        if (workflow.getStatus() == WorkflowJob.Status.RUNNING) {
            workflow.getWorkflowInstance().suspend();
            WorkflowInstance wfInstance = workflow.getWorkflowInstance();
            ((LiteWorkflowInstance)wfInstance).setStatus(WorkflowInstance.Status.SUSPENDED);
            workflow.setStatus(WorkflowJob.Status.SUSPENDED);
            workflow.setWorkflowInstance(wfInstance);
            SuspendXCommand.setPendingFalseForActions(jpaService, id, actionId);
        }
    }

    private static void setPendingFalseForActions(JPAService jpaService, String id, String actionId) throws CommandException {
        try {
            List<WorkflowActionBean> actions = jpaService.execute(new WorkflowActionRetryManualGetJPAExecutor(id));
            for (WorkflowActionBean action : actions) {
                if (actionId != null && actionId.equals(action.getId())) continue;
                action.resetPendingOnly();
                jpaService.execute(new WorkflowActionUpdateJPAExecutor(action));
            }
        }
        catch (JPAExecutorException je) {
            throw new CommandException(je);
        }
    }

    @Override
    protected void eagerLoadState() throws CommandException {
        super.eagerLoadState();
        try {
            this.jpaService = Services.get().get(JPAService.class);
            if (this.jpaService == null) {
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            this.wfJobBean = this.jpaService.execute(new WorkflowJobGetJPAExecutor(this.wfid));
        }
        catch (Exception ex) {
            throw new CommandException(ErrorCode.E0603, ex);
        }
        LogUtils.setLogInfo(this.wfJobBean, this.logInfo);
    }

    @Override
    protected void eagerVerifyPrecondition() throws CommandException, PreconditionException {
        super.eagerVerifyPrecondition();
        if (this.wfJobBean.getStatus() != WorkflowJob.Status.RUNNING) {
            throw new PreconditionException(ErrorCode.E0727, this.wfJobBean.getStatus());
        }
    }

    @Override
    protected String getEntityKey() {
        return this.wfid;
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void loadState() throws CommandException {
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }
}

