/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.terafast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SourceToTargetMapping;
import org.pentaho.di.core.database.TeradataDatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.KeyValue;
import org.pentaho.di.core.util.PluginProperty;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.terafast.TeraFastMeta;
import org.pentaho.di.ui.core.SimpleFileSelection;
import org.pentaho.di.ui.core.dialog.EnterMappingDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.PluginWidgetFactory;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;
import org.pentaho.di.ui.trans.steps.terafast.TeraFastAboutDialog;

public class TeraFastDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = TeraFastMeta.class;
    private static final int FORM_ATTACHMENT_OFFSET = 100;
    private static final int FORM_ATTACHMENT_FACTOR = -15;
    private TeraFastMeta meta;
    private CCombo wConnection;
    private Label wlConnection;
    private Button wbwConnection;
    private Button wbnConnection;
    private Button wbeConnection;
    private Label wlTable;
    private TextVar wTable;
    private Label wlFastLoadPath;
    private TextVar wFastLoadPath;
    private Button wbFastLoadPath;
    private Label wlControlFile;
    private TextVar wControlFile;
    private Button wbControlFile;
    private Label wlDataFile;
    private TextVar wDataFile;
    private Button wbDataFile;
    private Label wlLogFile;
    private Button wbLogFile;
    private TextVar wLogFile;
    private Label wlErrLimit;
    private TextVar wErrLimit;
    private Label wlSessions;
    private TextVar wSessions;
    private Label wlUseControlFile;
    private Button wUseControlFile;
    private Label wlVariableSubstitution;
    private Button wVariableSubstitution;
    private Label wlTruncateTable;
    private Button wbTruncateTable;
    private Link wAscLink;
    private Label wlReturn;
    private TableView wReturn;
    private Button wGetLU;
    private FormData fdGetLU;
    private Listener lsGetLU;
    private Button wDoMapping;
    private FormData fdDoMapping;
    private Button wAbout;
    private ColumnInfo[] ciReturn;
    private Map<String, Integer> inputFields = new HashMap<String, Integer>();
    private List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();

    public TeraFastDialog(Shell parent, Object baseStepMeta, TransMeta transMeta, String stepname) {
        super(parent, (BaseStepMeta)baseStepMeta, transMeta, stepname);
        this.meta = (TeraFastMeta)baseStepMeta;
    }

    public static void setTextIfPropertyValue(PluginProperty property, TextVar textVar) {
        if (property.evaluate()) {
            textVar.setText(((KeyValue)property).stringValue());
        }
    }

    public static void setTextIfPropertyValue(PluginProperty property, CCombo combo) {
        if (property.evaluate()) {
            combo.setText(((KeyValue)property).stringValue());
        }
    }

    public String open() {
        this.changed = this.meta.hasChanged();
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.meta);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"TeraFastDialog.Shell.Title", (String[])new String[0]));
        this.buildUi();
        this.assignChangeListener();
        this.listeners();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMetaSearchFields = TeraFastDialog.this.transMeta.findStep(TeraFastDialog.this.stepname);
                if (stepMetaSearchFields == null) {
                    return;
                }
                try {
                    RowMetaInterface row = TeraFastDialog.this.transMeta.getPrevStepFields(stepMetaSearchFields);
                    for (int i = 0; i < row.size(); ++i) {
                        TeraFastDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                    }
                    TeraFastDialog.this.setComboBoxes();
                }
                catch (KettleException e) {
                    TeraFastDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.setSize();
        this.getData();
        this.meta.setChanged(this.changed);
        this.disableInputs();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciReturn[1].setComboValues(fieldNames);
    }

    public void getData() {
        TeraFastDialog.setTextIfPropertyValue((PluginProperty)this.meta.getFastloadPath(), this.wFastLoadPath);
        TeraFastDialog.setTextIfPropertyValue((PluginProperty)this.meta.getControlFile(), this.wControlFile);
        TeraFastDialog.setTextIfPropertyValue((PluginProperty)this.meta.getDataFile(), this.wDataFile);
        TeraFastDialog.setTextIfPropertyValue((PluginProperty)this.meta.getLogFile(), this.wLogFile);
        TeraFastDialog.setTextIfPropertyValue((PluginProperty)this.meta.getTargetTable(), this.wTable);
        TeraFastDialog.setTextIfPropertyValue((PluginProperty)this.meta.getErrorLimit(), this.wErrLimit);
        TeraFastDialog.setTextIfPropertyValue((PluginProperty)this.meta.getSessions(), this.wSessions);
        TeraFastDialog.setTextIfPropertyValue((PluginProperty)this.meta.getConnectionName(), this.wConnection);
        this.wbTruncateTable.setSelection(((Boolean)this.meta.getTruncateTable().getValue()).booleanValue());
        this.wUseControlFile.setSelection(((Boolean)this.meta.getUseControlFile().getValue()).booleanValue());
        this.wVariableSubstitution.setSelection(((Boolean)this.meta.getVariableSubstitution().getValue()).booleanValue());
        if (((List)this.meta.getTableFieldList().getValue()).size() == ((List)this.meta.getStreamFieldList().getValue()).size()) {
            for (int i = 0; i < ((List)this.meta.getTableFieldList().getValue()).size(); ++i) {
                TableItem item = this.wReturn.table.getItem(i);
                item.setText(1, (String)((List)this.meta.getTableFieldList().getValue()).get(i));
                item.setText(2, (String)((List)this.meta.getStreamFieldList().getValue()).get(i));
            }
        }
        if (this.meta.getDbMeta() != null) {
            this.wConnection.setText((String)this.meta.getConnectionName().getValue());
        } else if (this.transMeta.nrDatabases() == 1) {
            this.wConnection.setText(this.transMeta.getDatabase(0).getName());
        }
        this.setTableFieldCombo();
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void listeners() {
        this.lsCancel = new Listener(){

            public void handleEvent(Event event) {
                TeraFastDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event event) {
                TeraFastDialog.this.ok();
            }
        };
        this.wAbout.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                new TeraFastAboutDialog(TeraFastDialog.this.shell).open();
            }
        });
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                TeraFastDialog.this.ok();
            }
        };
        this.lsGetLU = new Listener(){

            public void handleEvent(Event event) {
                TeraFastDialog.this.getUpdate();
            }
        };
        this.wGetLU.addListener(13, this.lsGetLU);
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        String allFileTypes = BaseMessages.getString(PKG, (String)"TeraFastDialog.Filetype.All", (String[])new String[0]);
        this.wbControlFile.addSelectionListener((SelectionListener)new SimpleFileSelection(this.shell, this.wControlFile, allFileTypes));
        this.wbDataFile.addSelectionListener((SelectionListener)new SimpleFileSelection(this.shell, this.wDataFile, allFileTypes));
        this.wbFastLoadPath.addSelectionListener((SelectionListener)new SimpleFileSelection(this.shell, this.wFastLoadPath, allFileTypes));
        this.wbLogFile.addSelectionListener((SelectionListener)new SimpleFileSelection(this.shell, this.wLogFile, allFileTypes));
        this.wDoMapping.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TeraFastDialog.this.generateMappings();
            }
        });
        this.wAscLink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Program.launch((String)event.text);
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent event) {
                TeraFastDialog.this.cancel();
            }
        });
    }

    public void generateMappings() {
        RowMetaInterface targetFields;
        RowMetaInterface sourceFields;
        try {
            sourceFields = this.transMeta.getPrevStepFields(this.stepMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TeraFastDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TeraFastDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.meta.getTargetTable().setValue((Object)this.wTable.getText());
        try {
            targetFields = this.meta.getRequiredFields((VariableSpace)this.transMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TeraFastDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TeraFastDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        String[] inputNames = new String[sourceFields.size()];
        for (int i = 0; i < sourceFields.size(); ++i) {
            ValueMetaInterface value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName() + "            (" + value.getOrigin() + ")";
        }
        List<SourceToTargetMapping> mappings = new ArrayList<SourceToTargetMapping>();
        StringBuilder missingSourceFields = new StringBuilder();
        StringBuilder missingTargetFields = new StringBuilder();
        int nrFields = this.wReturn.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            int targetIndex;
            TableItem item = this.wReturn.getNonEmpty(i);
            String source = item.getText(2);
            String target = item.getText(1);
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        EnterMappingDialog d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings);
        mappings = d.open();
        if (mappings != null) {
            this.wReturn.table.removeAll();
            this.wReturn.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = mappings.get(i);
                TableItem item = this.wReturn.table.getItem(i);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
            }
            this.wReturn.setRowNums();
            this.wReturn.optWidth(true);
        }
    }

    public void getUpdate() {
        try {
            RowMetaInterface row = this.transMeta.getPrevStepFields(this.stepname);
            if (row != null) {
                TableItemInsertListener listener = new TableItemInsertListener(){

                    @Override
                    public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface value) {
                        return true;
                    }
                };
                BaseStepDialog.getFieldsFromPrevious(row, this.wReturn, 1, new int[]{1, 2}, new int[0], -1, -1, listener);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TeraFastDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TeraFastDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public void cancel() {
        this.stepname = null;
        this.meta.setChanged(this.changed);
        this.dispose();
    }

    public void ok() {
        this.stepname = this.wStepname.getText();
        this.meta.getUseControlFile().setValue((Object)this.wUseControlFile.getSelection());
        this.meta.getVariableSubstitution().setValue((Object)this.wVariableSubstitution.getSelection());
        this.meta.getControlFile().setValue((Object)this.wControlFile.getText());
        this.meta.getFastloadPath().setValue((Object)this.wFastLoadPath.getText());
        this.meta.getDataFile().setValue((Object)this.wDataFile.getText());
        this.meta.getLogFile().setValue((Object)this.wLogFile.getText());
        this.meta.getErrorLimit().setValue((Object)Const.toInt((String)this.wErrLimit.getText(), (int)25));
        this.meta.getSessions().setValue((Object)Const.toInt((String)this.wSessions.getText(), (int)2));
        this.meta.getTargetTable().setValue((Object)this.wTable.getText());
        this.meta.getConnectionName().setValue((Object)this.wConnection.getText());
        this.meta.getTruncateTable().setValue((Object)(this.wbTruncateTable.getSelection() && this.wbTruncateTable.getEnabled() ? 1 : 0));
        this.meta.setDbMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        ((List)this.meta.getTableFieldList().getValue()).clear();
        ((List)this.meta.getStreamFieldList().getValue()).clear();
        int nrfields = this.wReturn.nrNonEmpty();
        for (int i = 0; i < nrfields; ++i) {
            TableItem item = this.wReturn.getNonEmpty(i);
            ((List)this.meta.getTableFieldList().getValue()).add(item.getText(1));
            ((List)this.meta.getStreamFieldList().getValue()).add(item.getText(2));
        }
        this.dispose();
    }

    protected void buildUi() {
        PluginWidgetFactory factory = new PluginWidgetFactory(this.shell, (VariableSpace)this.transMeta);
        factory.setMiddle(this.props.getMiddlePct());
        this.buildStepNameLine(factory);
        this.buildUseControlFileLine(factory);
        this.buildControlFileLine(factory);
        this.buildVariableSubstitutionLine(factory);
        this.buildFastloadLine(factory);
        this.buildLogFileLine(factory);
        this.wbwConnection = new Button((Composite)this.shell, 8);
        this.wbnConnection = new Button((Composite)this.shell, 8);
        this.wbeConnection = new Button((Composite)this.shell, 8);
        this.wlConnection = new Label((Composite)this.shell, 131072);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wLogFile, factory.getMiddle(), factory.getMargin(), this.wlConnection, this.wbwConnection, this.wbnConnection, this.wbeConnection, TeradataDatabaseMeta.class);
        this.buildTableLine(factory);
        this.buildTruncateTableLine(factory);
        this.buildDataFileLine(factory);
        this.buildSessionsLine(factory);
        this.buildErrorLimitLine(factory);
        this.buildFieldTable(factory);
        this.buildAscLink(factory);
        this.wOK = factory.createPushButton(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = factory.createPushButton(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wAbout = factory.createPushButton(BaseMessages.getString(PKG, (String)"TeraFastDialog.About.Button", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel, this.wAbout}, factory.getMargin(), (Control)this.wAscLink);
    }

    protected void buildControlFileLine(PluginWidgetFactory factory) {
        Button topControl = this.wUseControlFile;
        this.wlControlFile = factory.createRightLabel(BaseMessages.getString(PKG, (String)"TeraFastDialog.ControlFile.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlControlFile);
        this.wlControlFile.setLayoutData((Object)factory.createLabelLayoutData((Control)topControl));
        this.wbControlFile = factory.createPushButton(BaseMessages.getString(PKG, (String)"TeraFastDialog.Browse.Button", (String[])new String[0]));
        this.props.setLook((Control)this.wbControlFile);
        FormData formData = factory.createControlLayoutData((Control)topControl);
        formData.left = null;
        this.wbControlFile.setLayoutData((Object)formData);
        this.wControlFile = factory.createSingleTextVarLeft();
        this.props.setLook((Control)this.wControlFile);
        formData = factory.createControlLayoutData((Control)topControl);
        formData.right = new FormAttachment((Control)this.wbControlFile, -factory.getMargin());
        this.wControlFile.setLayoutData(formData);
    }

    protected void buildFastloadLine(PluginWidgetFactory factory) {
        Button topControl = this.wVariableSubstitution;
        this.wlFastLoadPath = factory.createRightLabel(BaseMessages.getString(PKG, (String)"TeraFastDialog.FastloadPath.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFastLoadPath);
        this.wlFastLoadPath.setLayoutData((Object)factory.createLabelLayoutData((Control)topControl));
        this.wbFastLoadPath = factory.createPushButton(BaseMessages.getString(PKG, (String)"TeraFastDialog.Browse.Button", (String[])new String[0]));
        this.props.setLook((Control)this.wbFastLoadPath);
        FormData formData = factory.createControlLayoutData((Control)topControl);
        formData.left = null;
        this.wbFastLoadPath.setLayoutData((Object)formData);
        this.wFastLoadPath = factory.createSingleTextVarLeft();
        this.props.setLook((Control)this.wFastLoadPath);
        formData = factory.createControlLayoutData((Control)topControl);
        formData.right = new FormAttachment((Control)this.wbFastLoadPath, -factory.getMargin());
        this.wFastLoadPath.setLayoutData(formData);
    }

    protected void buildUseControlFileLine(PluginWidgetFactory factory) {
        Text topControl = this.wStepname;
        this.wlUseControlFile = factory.createRightLabel(BaseMessages.getString(PKG, (String)"TeraFastDialog.UseControlFile.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlUseControlFile);
        this.wlUseControlFile.setLayoutData((Object)factory.createLabelLayoutData((Control)topControl));
        this.wUseControlFile = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wUseControlFile);
        this.wUseControlFile.setLayoutData((Object)factory.createControlLayoutData((Control)topControl));
        this.wUseControlFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TeraFastDialog.this.disableInputs();
            }
        });
    }

    protected void buildVariableSubstitutionLine(PluginWidgetFactory factory) {
        TextVar topControl = this.wControlFile;
        this.wlVariableSubstitution = factory.createRightLabel(BaseMessages.getString(PKG, (String)"TeraFastDialog.VariableSubstitution.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlVariableSubstitution);
        this.wlVariableSubstitution.setLayoutData((Object)factory.createLabelLayoutData((Control)topControl));
        this.wVariableSubstitution = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wVariableSubstitution);
        this.wVariableSubstitution.setLayoutData((Object)factory.createControlLayoutData((Control)topControl));
    }

    protected void buildLogFileLine(PluginWidgetFactory factory) {
        TextVar topControl = this.wFastLoadPath;
        this.wlLogFile = factory.createRightLabel(BaseMessages.getString(PKG, (String)"TeraFastDialog.LogFile.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlLogFile);
        this.wlLogFile.setLayoutData((Object)factory.createLabelLayoutData((Control)topControl));
        this.wbLogFile = factory.createPushButton(BaseMessages.getString(PKG, (String)"TeraFastDialog.Browse.Button", (String[])new String[0]));
        this.props.setLook((Control)this.wbLogFile);
        FormData formData = factory.createControlLayoutData((Control)topControl);
        formData.left = null;
        this.wbLogFile.setLayoutData((Object)formData);
        this.wLogFile = factory.createSingleTextVarLeft();
        this.props.setLook((Control)this.wLogFile);
        formData = factory.createControlLayoutData((Control)topControl);
        formData.right = new FormAttachment((Control)this.wbLogFile, -factory.getMargin());
        this.wLogFile.setLayoutData(formData);
    }

    protected void buildStepNameLine(PluginWidgetFactory factory) {
        this.wlStepname = factory.createRightLabel(BaseMessages.getString(PKG, (String)"TeraFastDialog.StepName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = factory.createLabelLayoutData(null);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = factory.createSingleTextLeft(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.fdStepname = factory.createControlLayoutData(null);
        this.wStepname.setLayoutData((Object)this.fdStepname);
    }

    protected void buildTableLine(PluginWidgetFactory factory) {
        CCombo topControl = this.wConnection;
        this.wlTable = factory.createRightLabel(BaseMessages.getString(PKG, (String)"TeraFastDialog.TargetTable.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTable);
        this.wlTable.setLayoutData((Object)factory.createLabelLayoutData((Control)topControl));
        this.wTable = factory.createSingleTextVarLeft();
        this.props.setLook((Control)this.wTable);
        this.wTable.setLayoutData(factory.createControlLayoutData((Control)topControl));
        this.wTable.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                TeraFastDialog.this.setTableFieldCombo();
            }
        });
    }

    protected void buildTruncateTableLine(PluginWidgetFactory factory) {
        TextVar topControl = this.wTable;
        this.wlTruncateTable = factory.createRightLabel(BaseMessages.getString(PKG, (String)"TeraFastDialog.TruncateTable.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTruncateTable);
        this.wlTruncateTable.setLayoutData((Object)factory.createLabelLayoutData((Control)topControl));
        this.wbTruncateTable = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wbTruncateTable);
        this.wbTruncateTable.setLayoutData((Object)factory.createControlLayoutData((Control)topControl));
    }

    protected void buildDataFileLine(PluginWidgetFactory factory) {
        Button topControl = this.wbTruncateTable;
        this.wlDataFile = factory.createRightLabel(BaseMessages.getString(PKG, (String)"TeraFastDialog.DataFile.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDataFile);
        this.wlDataFile.setLayoutData((Object)factory.createLabelLayoutData((Control)topControl));
        this.wbDataFile = factory.createPushButton(BaseMessages.getString(PKG, (String)"TeraFastDialog.Browse.Button", (String[])new String[0]));
        this.props.setLook((Control)this.wbDataFile);
        FormData formData = factory.createControlLayoutData((Control)topControl);
        formData.left = null;
        this.wbDataFile.setLayoutData((Object)formData);
        this.wDataFile = factory.createSingleTextVarLeft();
        this.props.setLook((Control)this.wDataFile);
        formData = factory.createControlLayoutData((Control)topControl);
        formData.right = new FormAttachment((Control)this.wbDataFile, -factory.getMargin());
        this.wDataFile.setLayoutData(formData);
    }

    protected void buildSessionsLine(PluginWidgetFactory factory) {
        TextVar topControl = this.wDataFile;
        this.wlSessions = factory.createRightLabel(BaseMessages.getString(PKG, (String)"TeraFastDialog.Sessions.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSessions);
        this.wlSessions.setLayoutData((Object)factory.createLabelLayoutData((Control)topControl));
        this.wSessions = factory.createSingleTextVarLeft();
        this.props.setLook((Control)this.wSessions);
        this.wSessions.setLayoutData(factory.createControlLayoutData((Control)topControl));
    }

    protected void buildErrorLimitLine(PluginWidgetFactory factory) {
        TextVar topControl = this.wSessions;
        this.wlErrLimit = factory.createRightLabel(BaseMessages.getString(PKG, (String)"TeraFastDialog.ErrLimit.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlErrLimit);
        this.wlErrLimit.setLayoutData((Object)factory.createLabelLayoutData((Control)topControl));
        this.wErrLimit = factory.createSingleTextVarLeft();
        this.props.setLook((Control)this.wErrLimit);
        this.wErrLimit.setLayoutData(factory.createControlLayoutData((Control)topControl));
    }

    protected void buildAscLink(PluginWidgetFactory factory) {
        TableView topControl = this.wReturn;
        this.wAscLink = new Link((Composite)this.shell, 0);
        this.wAscLink.setText(BaseMessages.getString(PKG, (String)"TeraFastDialog.Provided.Info", (String[])new String[0]));
        FormData formData = factory.createLabelLayoutData((Control)topControl);
        formData.right = null;
        this.wAscLink.setLayoutData((Object)formData);
    }

    protected void buildFieldTable(PluginWidgetFactory factory) {
        TextVar topControl = this.wErrLimit;
        this.wlReturn = factory.createLabel(0, BaseMessages.getString(PKG, (String)"TeraFastDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlReturn);
        this.wlReturn.setLayoutData((Object)factory.createLabelLayoutData((Control)topControl));
        int upInsCols = 2;
        int upInsRows = this.meta.getTableFieldList().isEmpty() ? 1 : this.meta.getTableFieldList().size();
        this.ciReturn = new ColumnInfo[2];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"TeraFastDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"TeraFastDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.tableFieldColumns.add(this.ciReturn[0]);
        this.wReturn = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, this.ciReturn, upInsRows, null, this.props);
        this.wGetLU = factory.createPushButton(BaseMessages.getString(PKG, (String)"TeraFastDialog.GetFields.Label", (String[])new String[0]));
        this.fdGetLU = new FormData();
        this.fdGetLU.top = new FormAttachment((Control)this.wlReturn, factory.getMargin());
        this.fdGetLU.right = new FormAttachment(100, 0);
        this.wGetLU.setLayoutData((Object)this.fdGetLU);
        this.wDoMapping = factory.createPushButton(BaseMessages.getString(PKG, (String)"TeraFastDialog.EditMapping.Label", (String[])new String[0]));
        this.fdDoMapping = new FormData();
        this.fdDoMapping.top = new FormAttachment((Control)this.wGetLU, factory.getMargin());
        this.fdDoMapping.right = new FormAttachment(100, 0);
        this.wDoMapping.setLayoutData((Object)this.fdDoMapping);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment((Control)this.wlReturn, factory.getMargin());
        formData.right = new FormAttachment((Control)this.wGetLU, -factory.getMargin());
        formData.bottom = new FormAttachment(100, -15 * factory.getMargin());
        this.wReturn.setLayoutData(formData);
    }

    protected void assignChangeListener() {
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                TeraFastDialog.this.getMeta().setChanged();
            }
        };
        SelectionAdapter lsSel = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TeraFastDialog.this.getMeta().setChanged();
            }
        };
        this.wStepname.addModifyListener(lsMod);
        this.wControlFile.addModifyListener(lsMod);
        this.wFastLoadPath.addModifyListener(lsMod);
        this.wLogFile.addModifyListener(lsMod);
        this.wConnection.addModifyListener(lsMod);
        this.wTable.addModifyListener(lsMod);
        this.wDataFile.addModifyListener(lsMod);
        this.wSessions.addModifyListener(lsMod);
        this.wErrLimit.addModifyListener(lsMod);
        this.wbTruncateTable.addSelectionListener((SelectionListener)lsSel);
        this.wUseControlFile.addSelectionListener((SelectionListener)lsSel);
        this.wVariableSubstitution.addSelectionListener((SelectionListener)lsSel);
        this.wReturn.addModifyListener(lsMod);
    }

    public void disableInputs() {
        boolean useControlFile = this.wUseControlFile.getSelection();
        this.wbControlFile.setEnabled(useControlFile);
        this.wControlFile.setEnabled(useControlFile);
        this.wDataFile.setEnabled(!useControlFile);
        this.wbDataFile.setEnabled(!useControlFile);
        this.wSessions.setEnabled(!useControlFile);
        this.wErrLimit.setEnabled(!useControlFile);
        this.wReturn.setEnabled(!useControlFile);
        this.wGetLU.setEnabled(!useControlFile);
        this.wDoMapping.setEnabled(!useControlFile);
        this.wTable.setEnabled(!useControlFile);
        this.wbTruncateTable.setEnabled(!useControlFile);
        this.wConnection.setEnabled(!useControlFile);
        this.wbeConnection.setEnabled(!useControlFile);
        this.wbwConnection.setEnabled(!useControlFile);
        this.wbnConnection.setEnabled(!useControlFile);
        this.wVariableSubstitution.setEnabled(useControlFile);
    }

    public void setTableFieldCombo() {
        this.clearColInfo();
        new FieldLoader(this).start();
    }

    private void clearColInfo() {
        int n = this.tableFieldColumns.size();
        for (int i = 0; i < n; ++i) {
            ColumnInfo colInfo = this.tableFieldColumns.get(i);
            colInfo.setComboValues(new String[0]);
        }
    }

    public TeraFastMeta getMeta() {
        return this.meta;
    }

    private static final class FieldLoader
    extends Thread {
        private TeraFastDialog dialog;

        public FieldLoader(TeraFastDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void run() {
            try {
                RowMetaInterface rowMeta = this.dialog.meta.getRequiredFields((VariableSpace)this.dialog.transMeta);
                if (rowMeta == null) {
                    return;
                }
                final String[] fieldNames = rowMeta.getFieldNames();
                if (fieldNames == null) {
                    return;
                }
                for (int i = 0; i < this.dialog.tableFieldColumns.size(); ++i) {
                    final ColumnInfo colInfo = (ColumnInfo)this.dialog.tableFieldColumns.get(i);
                    if (this.dialog.shell.isDisposed()) {
                        return;
                    }
                    this.dialog.shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (dialog.shell.isDisposed()) {
                                return;
                            }
                            colInfo.setComboValues(fieldNames);
                        }
                    });
                }
            }
            catch (KettleException e) {
                this.dialog.logError(this.toString(), new Object[]{"Error while reading fields", e});
            }
        }
    }
}

