/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class ShowHelpDialog
extends Dialog {
    private static Class<?> PKG = Spoon.class;
    private static final String DOC_URL = Spoon.DOCUMENTATION_URL;
    private static final String PREFIX = "https://help";
    private static final String PRINT_PREFIX = "https://f1.help";
    private static final String PRINT_SCRIPT = "javascript:window.print();";
    private static final int TOOLBAR_HEIGHT = 25;
    private static final int TOOL_ITEM_WIDTH = 47;
    private static final int TOOL_ITEM_SPACING = 4;
    private static final int MARGIN = 5;
    private boolean fromPrint;
    private String dialogTitle;
    private String url;
    private String homeURL;
    private Browser wBrowser;
    private ToolBar toolBarBack;
    private ToolItem tltmBack;
    private ToolBar toolBarForward;
    private ToolItem tltmForward;
    private ToolItem tltmRefresh;
    private ToolItem tltmHome;
    private ToolItem tltmPrint;
    private Image imageBackEnabled;
    private Image imageBackDisabled;
    private Image imageForwardEnabled;
    private Image imageForwardDisabled;
    private Image imageRefreshEnabled;
    private Image imageRefreshDisabled;
    private Image imageHomeEnabled;
    private Image imageHomeDisabled;
    private Image imagePrintEnabled;
    private Image imagePrintDisabled;
    private Text textURL;
    private Cursor cursorEnabled;
    private Cursor cursorDisabled;
    private Shell shell;
    private Display display;
    private PropsUI props = PropsUI.getInstance();

    public ShowHelpDialog(Shell parent, String dialogTitle, String url, String header) {
        super(parent, 0);
        this.dialogTitle = BaseMessages.getString(PKG, (String)"Spoon.Documentation.Pentaho.Title", (String[])new String[0]);
        this.url = url;
        try {
            this.homeURL = new URL(DOC_URL).toString();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public ShowHelpDialog(Shell parent, String dialogTitle, String url) {
        this(parent, dialogTitle, url, "");
    }

    protected Shell createShell(Shell parent) {
        return new Shell(parent, 3312);
    }

    public void open() {
        Shell parent = this.getParent();
        this.display = parent.getDisplay();
        this.shell = this.createShell(parent);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        this.props.setLook((Control)this.shell);
        FormLayout formLayout = new FormLayout();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.dialogTitle);
        this.setImages();
        this.wBrowser = new Browser((Composite)this.shell, 0);
        this.props.setLook((Control)this.wBrowser);
        FormData fdBrowser = new FormData();
        fdBrowser.top = new FormAttachment(0, 30);
        fdBrowser.right = new FormAttachment(100, 0);
        fdBrowser.bottom = new FormAttachment(100, 0);
        fdBrowser.left = new FormAttachment(0, 0);
        this.wBrowser.setLayoutData((Object)fdBrowser);
        this.toolBarBack = new ToolBar((Composite)this.shell, 0x800000);
        FormData fdtoolBarBack = new FormData();
        fdtoolBarBack.top = new FormAttachment(0, 5);
        fdtoolBarBack.right = new FormAttachment(0, 27);
        fdtoolBarBack.bottom = new FormAttachment(0, 25);
        fdtoolBarBack.left = new FormAttachment(0, 6);
        this.toolBarBack.setLayoutData((Object)fdtoolBarBack);
        this.toolBarBack.setCursor(this.cursorDisabled);
        this.toolBarBack.setBackground(this.toolBarBack.getParent().getBackground());
        this.tltmBack = new ToolItem(this.toolBarBack, 0);
        this.tltmBack.setImage(this.imageBackEnabled);
        this.tltmBack.setDisabledImage(this.imageBackDisabled);
        this.tltmBack.setToolTipText(BaseMessages.getString(PKG, (String)"Spoon.Documentation.Tooltip.Back", (String[])new String[0]));
        this.tltmBack.setEnabled(false);
        this.toolBarForward = new ToolBar((Composite)this.shell, 0x800000);
        FormData fdtoolBarForward = new FormData();
        fdtoolBarForward.top = new FormAttachment(0, 5);
        fdtoolBarForward.right = new FormAttachment((Control)this.toolBarBack, 47);
        fdtoolBarForward.bottom = new FormAttachment(0, 25);
        fdtoolBarForward.left = new FormAttachment((Control)this.toolBarBack, 4);
        this.toolBarForward.setLayoutData((Object)fdtoolBarForward);
        this.toolBarForward.setCursor(this.cursorDisabled);
        this.toolBarForward.setBackground(this.toolBarForward.getParent().getBackground());
        this.tltmForward = new ToolItem(this.toolBarForward, 0);
        this.tltmForward.setImage(this.imageForwardEnabled);
        this.tltmForward.setDisabledImage(this.imageForwardDisabled);
        this.tltmForward.setToolTipText(BaseMessages.getString(PKG, (String)"Spoon.Documentation.Tooltip.Forward", (String[])new String[0]));
        this.tltmForward.setEnabled(false);
        ToolBar toolBarRefresh = new ToolBar((Composite)this.shell, 0x800000);
        FormData fdtoolBarRefresh = new FormData();
        fdtoolBarRefresh.top = new FormAttachment(0, 5);
        fdtoolBarRefresh.right = new FormAttachment((Control)this.toolBarForward, 47);
        fdtoolBarRefresh.bottom = new FormAttachment(0, 25);
        fdtoolBarRefresh.left = new FormAttachment((Control)this.toolBarForward, 3);
        toolBarRefresh.setLayoutData((Object)fdtoolBarRefresh);
        toolBarRefresh.setCursor(this.cursorEnabled);
        toolBarRefresh.setBackground(toolBarRefresh.getParent().getBackground());
        this.tltmRefresh = new ToolItem(toolBarRefresh, 0);
        this.tltmRefresh.setImage(this.imageRefreshEnabled);
        this.tltmRefresh.setDisabledImage(this.imageRefreshDisabled);
        this.tltmRefresh.setToolTipText(BaseMessages.getString(PKG, (String)"Spoon.Documentation.Tooltip.Refresh", (String[])new String[0]));
        this.tltmRefresh.setEnabled(true);
        ToolBar toolBarHome = new ToolBar((Composite)this.shell, 0x800000);
        FormData fdtoolBarHome = new FormData();
        fdtoolBarHome.top = new FormAttachment(0, 5);
        fdtoolBarHome.right = new FormAttachment((Control)toolBarRefresh, 47);
        fdtoolBarHome.bottom = new FormAttachment(0, 25);
        fdtoolBarHome.left = new FormAttachment((Control)toolBarRefresh, 4);
        toolBarHome.setLayoutData((Object)fdtoolBarHome);
        toolBarHome.setCursor(this.cursorEnabled);
        toolBarHome.setBackground(toolBarHome.getParent().getBackground());
        this.tltmHome = new ToolItem(toolBarHome, 0);
        this.tltmHome.setImage(this.imageHomeEnabled);
        this.tltmHome.setDisabledImage(this.imageHomeDisabled);
        this.tltmHome.setToolTipText(BaseMessages.getString(PKG, (String)"Spoon.Documentation.Tooltip.Home", (String[])new String[0]));
        this.tltmHome.setEnabled(true);
        ToolBar toolBarPrint = new ToolBar((Composite)this.shell, 0x800000);
        FormData fdtoolBarPrint = new FormData();
        fdtoolBarPrint.top = new FormAttachment(0, 5);
        fdtoolBarPrint.right = new FormAttachment(100, -7);
        fdtoolBarPrint.bottom = new FormAttachment(0, 25);
        toolBarPrint.setLayoutData((Object)fdtoolBarPrint);
        toolBarPrint.setCursor(this.cursorEnabled);
        toolBarPrint.setBackground(toolBarPrint.getParent().getBackground());
        this.tltmPrint = new ToolItem(toolBarPrint, 0);
        this.tltmPrint.setImage(this.imagePrintEnabled);
        this.tltmPrint.setDisabledImage(this.imagePrintDisabled);
        this.tltmPrint.setToolTipText(BaseMessages.getString(PKG, (String)"Spoon.Documentation.Tooltip.Print", (String[])new String[0]));
        this.tltmPrint.setEnabled(true);
        this.textURL = new Text((Composite)this.shell, 2048);
        FormData fdtext = new FormData();
        fdtext.top = new FormAttachment(0, 5);
        fdtext.right = new FormAttachment((Control)toolBarPrint, -7);
        fdtext.bottom = new FormAttachment(0, 25);
        fdtext.left = new FormAttachment((Control)toolBarHome, 4);
        this.textURL.setLayoutData((Object)fdtext);
        this.textURL.setForeground(new Color((Device)this.display, 101, 101, 101));
        this.wBrowser.setUrl(this.url);
        this.setUpListeners();
        BaseStepDialog.setSize(this.shell, 755, 538, true);
        this.shell.setMinimumSize(515, 408);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    private void setImages() {
        this.imageBackEnabled = GUIResource.getInstance().getImageBackEnabled();
        this.imageBackDisabled = GUIResource.getInstance().getImageBackDisabled();
        this.imageForwardEnabled = GUIResource.getInstance().getImageForwardEnabled();
        this.imageForwardDisabled = GUIResource.getInstance().getImageForwardDisabled();
        this.imageRefreshEnabled = GUIResource.getInstance().getImageRefreshEnabled();
        this.imageRefreshDisabled = GUIResource.getInstance().getImageRefreshDisabled();
        this.imageHomeEnabled = GUIResource.getInstance().getImageHomeEnabled();
        this.imageHomeDisabled = GUIResource.getInstance().getImageHomeDisabled();
        this.imagePrintEnabled = GUIResource.getInstance().getImagePrintEnabled();
        this.imagePrintDisabled = GUIResource.getInstance().getImagePrintDisabled();
        this.cursorEnabled = new Cursor((Device)this.display, 21);
        this.cursorDisabled = new Cursor((Device)this.display, 0);
    }

    private void setUpListeners() {
        this.setUpSelectionListeners();
        this.addProgressAndLocationListener();
        this.addShellListener();
    }

    private void setUpSelectionListeners() {
        SelectionListener selectionListenerBack = new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ShowHelpDialog.this.back();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        };
        SelectionListener selectionListenerForward = new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ShowHelpDialog.this.forward();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        };
        SelectionListener selectionListenerRefresh = new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ShowHelpDialog.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        };
        SelectionListener selectionListenerHome = new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ShowHelpDialog.this.home();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        };
        SelectionListener selectionListenerPrint = new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ShowHelpDialog.this.print();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        };
        this.tltmBack.addSelectionListener(selectionListenerBack);
        this.tltmForward.addSelectionListener(selectionListenerForward);
        this.tltmRefresh.addSelectionListener(selectionListenerRefresh);
        this.tltmHome.addSelectionListener(selectionListenerHome);
        this.tltmPrint.addSelectionListener(selectionListenerPrint);
    }

    private void addProgressAndLocationListener() {
        ProgressListener progressListener = new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                if (ShowHelpDialog.this.fromPrint) {
                    ShowHelpDialog.this.wBrowser.execute(ShowHelpDialog.PRINT_SCRIPT);
                    ShowHelpDialog.this.fromPrint = false;
                }
                ShowHelpDialog.this.setForwardBackEnable();
            }
        };
        LocationListener listener = new LocationListener(){

            public void changing(LocationEvent event) {
                if (event.location.endsWith(".pdf")) {
                    Program.launch((String)event.location);
                    event.doit = false;
                }
            }

            public void changed(LocationEvent event) {
                ShowHelpDialog.this.textURL.setText(event.location);
            }
        };
        this.wBrowser.addProgressListener(progressListener);
        this.wBrowser.addLocationListener(listener);
    }

    private void addShellListener() {
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ShowHelpDialog.this.ok();
            }
        });
    }

    private void back() {
        this.wBrowser.back();
    }

    private void forward() {
        this.wBrowser.forward();
    }

    private void refresh() {
        this.wBrowser.refresh();
    }

    private void home() {
        this.wBrowser.setUrl(this.homeURL != null ? this.homeURL : this.url);
    }

    private void print() {
        String printURL = this.wBrowser.getUrl();
        if (printURL.startsWith(PREFIX)) {
            printURL = printURL.replace(PREFIX, PRINT_PREFIX);
            this.fromPrint = true;
            this.wBrowser.setUrl(printURL);
        } else {
            this.wBrowser.execute(PRINT_SCRIPT);
        }
    }

    private void setForwardBackEnable() {
        this.setBackEnable(this.wBrowser.isBackEnabled());
        this.setForwardEnable(this.wBrowser.isForwardEnabled());
    }

    private void setBackEnable(boolean enable) {
        this.tltmBack.setEnabled(enable);
        this.toolBarBack.setCursor(enable ? this.cursorEnabled : this.cursorDisabled);
    }

    private void setForwardEnable(boolean enable) {
        this.tltmForward.setEnabled(enable);
        this.toolBarForward.setCursor(enable ? this.cursorEnabled : this.cursorDisabled);
    }

    public void dispose() {
        this.shell.dispose();
    }

    private void ok() {
        this.dispose();
    }
}

