/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.connection.datasource.dbcp;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.AbandonedObjectPool;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.pentaho.database.DatabaseDialectException;
import org.pentaho.database.IDatabaseDialect;
import org.pentaho.database.IDriverLocator;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.service.IDatabaseDialectService;
import org.pentaho.platform.api.data.DBDatasourceServiceException;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.DriverNotInitializedException;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.platform.util.logging.Logger;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.transaction.annotation.Isolation;

public class PooledDatasourceHelper {
    public static PoolingDataSource setupPooledDataSource(IDatabaseConnection databaseConnection) throws DBDatasourceServiceException {
        PoolingDataSource poolingDataSource = null;
        String driverClass = null;
        String url = null;
        try {
            Isolation isolationLevel;
            if (databaseConnection.getAccessType().equals((Object)DatabaseAccessType.JNDI)) {
                throw new DBDatasourceServiceException(Messages.getInstance().getErrorString("PooledDatasourceHelper.ERROR_0008_UNABLE_TO_POOL_DATASOURCE_IT_IS_JNDI", databaseConnection.getName()));
            }
            ICacheManager cacheManager = PentahoSystem.getCacheManager(null);
            IDatabaseDialectService databaseDialectService = PentahoSystem.get(IDatabaseDialectService.class);
            if (databaseDialectService == null) {
                throw new DBDatasourceServiceException(Messages.getInstance().getErrorString("PooledDatasourceHelper.ERROR_0005_UNABLE_TO_POOL_DATASOURCE_NO_DIALECT_SERVICE", databaseConnection.getName()));
            }
            IDatabaseDialect dialect = databaseDialectService.getDialect(databaseConnection);
            if (dialect == null || dialect.getDatabaseType() == null) {
                throw new DBDatasourceServiceException(Messages.getInstance().getErrorString("PooledDatasourceHelper.ERROR_0004_UNABLE_TO_POOL_DATASOURCE_NO_DIALECT", databaseConnection.getName()));
            }
            if (databaseConnection.getDatabaseType().getShortName().equals("GENERIC")) {
                driverClass = (String)databaseConnection.getAttributes().get("CUSTOM_DRIVER_CLASS");
                if (StringUtils.isEmpty((String)driverClass)) {
                    throw new DBDatasourceServiceException(Messages.getInstance().getErrorString("PooledDatasourceHelper.ERROR_0006_UNABLE_TO_POOL_DATASOURCE_NO_CLASSNAME", databaseConnection.getName()));
                }
            } else {
                driverClass = dialect.getNativeDriver();
                if (StringUtils.isEmpty((String)driverClass)) {
                    throw new DBDatasourceServiceException(Messages.getInstance().getErrorString("PooledDatasourceHelper.ERROR_0007_UNABLE_TO_POOL_DATASOURCE_NO_DRIVER", databaseConnection.getName()));
                }
            }
            try {
                url = dialect.getURLWithExtraOptions(databaseConnection);
            }
            catch (DatabaseDialectException e) {
                url = null;
            }
            String maxdleConn = PentahoSystem.getSystemSetting("dbcp-defaults/max-idle-conn", null);
            String minIdleConn = PentahoSystem.getSystemSetting("dbcp-defaults/min-idle-conn", null);
            String maxActConn = PentahoSystem.getSystemSetting("dbcp-defaults/max-act-conn", null);
            String validQuery = null;
            String whenExhaustedAction = PentahoSystem.getSystemSetting("dbcp-defaults/when-exhausted-action", null);
            String wait = PentahoSystem.getSystemSetting("dbcp-defaults/wait", null);
            String testWhileIdleValue = PentahoSystem.getSystemSetting("dbcp-defaults/test-while-idle", null);
            String testOnBorrowValue = PentahoSystem.getSystemSetting("dbcp-defaults/test-on-borrow", null);
            String testOnReturnValue = PentahoSystem.getSystemSetting("dbcp-defaults/test-on-return", null);
            boolean testWhileIdle = !StringUtil.isEmpty(testWhileIdleValue) ? Boolean.parseBoolean(testWhileIdleValue) : false;
            boolean testOnBorrow = !StringUtil.isEmpty(testOnBorrowValue) ? Boolean.parseBoolean(testOnBorrowValue) : false;
            boolean testOnReturn = !StringUtil.isEmpty(testOnReturnValue) ? Boolean.parseBoolean(testOnReturnValue) : false;
            int maxActiveConnection = !StringUtil.isEmpty(maxActConn) ? Integer.parseInt(maxActConn) : -1;
            long waitTime = !StringUtil.isEmpty(wait) ? (long)Integer.parseInt(wait) : -1L;
            byte whenExhaustedActionType = !StringUtil.isEmpty(whenExhaustedAction) ? Byte.parseByte(whenExhaustedAction) : (byte)1;
            int minIdleConnection = !StringUtil.isEmpty(minIdleConn) ? Integer.parseInt(minIdleConn) : -1;
            int maxIdleConnection = !StringUtil.isEmpty(maxdleConn) ? Integer.parseInt(maxdleConn) : -1;
            Map attributes = databaseConnection.getConnectionPoolingProperties();
            if (attributes.containsKey("maxActive") && NumberUtils.isNumber((String)((String)attributes.get("maxActive")))) {
                maxActiveConnection = Integer.parseInt((String)attributes.get("maxActive"));
            }
            if (attributes.containsKey("maxWait") && NumberUtils.isNumber((String)((String)attributes.get("maxWait")))) {
                waitTime = Integer.parseInt((String)attributes.get("maxWait"));
            }
            if (attributes.containsKey("minIdle") && NumberUtils.isNumber((String)((String)attributes.get("minIdle")))) {
                minIdleConnection = Integer.parseInt((String)attributes.get("minIdle"));
            }
            if (attributes.containsKey("maxIdle") && NumberUtils.isNumber((String)((String)attributes.get("maxIdle")))) {
                maxIdleConnection = Integer.parseInt((String)attributes.get("maxIdle"));
            }
            if (attributes.containsKey("validationQuery")) {
                validQuery = (String)attributes.get("validationQuery");
            }
            if (attributes.containsKey("testOnBorrow")) {
                testOnBorrow = Boolean.parseBoolean((String)attributes.get("testOnBorrow"));
            }
            if (attributes.containsKey("testOnReturn")) {
                testOnReturn = Boolean.parseBoolean((String)attributes.get("testOnReturn"));
            }
            if (attributes.containsKey("testWhileIdle")) {
                testWhileIdle = Boolean.parseBoolean((String)attributes.get("testWhileIdle"));
            }
            poolingDataSource = new PoolingDataSource();
            if (dialect instanceof IDriverLocator) {
                if (!((IDriverLocator)dialect).initialize(driverClass)) {
                    throw new DriverNotInitializedException(Messages.getInstance().getErrorString("PooledDatasourceHelper.ERROR_0009_UNABLE_TO_POOL_DATASOURCE_CANT_INITIALIZE", databaseConnection.getName(), driverClass));
                }
            } else {
                Class.forName(driverClass);
            }
            GenericObjectPool pool = new GenericObjectPool(null);
            if (attributes.containsKey("removeAbandoned") && Boolean.parseBoolean((String)attributes.get("removeAbandoned"))) {
                AbandonedConfig config = new AbandonedConfig();
                config.setRemoveAbandoned(Boolean.parseBoolean((String)attributes.get("removeAbandoned")));
                if (attributes.containsKey("logAbandoned")) {
                    config.setLogAbandoned(Boolean.parseBoolean((String)attributes.get("logAbandoned")));
                }
                if (attributes.containsKey("removeAbandonedTimeout") && NumberUtils.isNumber((String)((String)attributes.get("removeAbandonedTimeout")))) {
                    config.setRemoveAbandonedTimeout(Integer.parseInt((String)attributes.get("removeAbandonedTimeout")));
                }
                pool = new AbandonedObjectPool(null, config);
            }
            pool.setWhenExhaustedAction(whenExhaustedActionType);
            pool.setMaxActive(maxActiveConnection);
            pool.setMaxIdle(maxIdleConnection);
            pool.setMaxWait(waitTime);
            pool.setMinIdle(minIdleConnection);
            pool.setTestWhileIdle(testWhileIdle);
            pool.setTestOnReturn(testOnReturn);
            pool.setTestOnBorrow(testOnBorrow);
            pool.setTestWhileIdle(testWhileIdle);
            if (attributes.containsKey("timeBetweenEvictionRunsMillis") && NumberUtils.isNumber((String)((String)attributes.get("timeBetweenEvictionRunsMillis")))) {
                pool.setTimeBetweenEvictionRunsMillis(Long.parseLong((String)attributes.get("timeBetweenEvictionRunsMillis")));
            }
            ConnectionFactory factory = PooledDatasourceHelper.getConnectionFactory(databaseConnection, url);
            boolean defaultReadOnly = attributes.containsKey("defaultReadOnly") ? Boolean.parseBoolean((String)attributes.get("testWhileIdle")) : false;
            boolean defaultAutoCommit = attributes.containsKey("defaultAutoCommit") ? Boolean.parseBoolean((String)attributes.get("defaultAutoCommit")) : true;
            GenericKeyedObjectPoolFactory kopf = null;
            if (attributes.containsKey("poolPreparedStatements") && Boolean.parseBoolean((String)attributes.get("poolPreparedStatements"))) {
                int maxOpenPreparedStatements = -1;
                if (attributes.containsKey("maxOpenPreparedStatements") && NumberUtils.isNumber((String)((String)attributes.get("maxOpenPreparedStatements")))) {
                    maxOpenPreparedStatements = Integer.parseInt((String)attributes.get("maxOpenPreparedStatements"));
                }
                kopf = new GenericKeyedObjectPoolFactory(null, pool.getMaxActive(), pool.getWhenExhaustedAction(), pool.getMaxWait(), pool.getMaxIdle(), maxOpenPreparedStatements);
            }
            PoolableConnectionFactory pcf = new PoolableConnectionFactory(factory, (ObjectPool)pool, kopf, validQuery, defaultReadOnly, defaultAutoCommit);
            if (attributes.containsKey("defaultTransactionIsolation") && !"NONE".equalsIgnoreCase((String)attributes.get("defaultTransactionIsolation")) && (isolationLevel = Isolation.valueOf((String)((String)attributes.get("defaultTransactionIsolation")))) != null) {
                pcf.setDefaultTransactionIsolation(isolationLevel.value());
            }
            if (attributes.containsKey("defaultCatalog")) {
                pcf.setDefaultCatalog((String)attributes.get("defaultCatalog"));
            }
            Logger.debug(PooledDatasourceHelper.class, "Pool defaults to " + maxActiveConnection + " max active/" + maxIdleConnection + "max idlewith " + waitTime + "wait time idle connections.");
            String prePopulatePoolStr = PentahoSystem.getSystemSetting("dbcp-defaults/pre-populate-pool", null);
            if (Boolean.parseBoolean(prePopulatePoolStr)) {
                for (int i = 0; i < maxIdleConnection; ++i) {
                    pool.addObject();
                }
                if (Logger.getLogLevel() <= 2) {
                    Logger.debug(PooledDatasourceHelper.class, "Pool has been pre-populated with " + maxIdleConnection + " connections");
                }
            }
            Logger.debug(PooledDatasourceHelper.class, "Pool now has " + pool.getNumActive() + " active/" + pool.getNumIdle() + " idle connections.");
            poolingDataSource.setPool((ObjectPool)pool);
            if (attributes.containsKey("accessToUnderlyingConnectionAllowed")) {
                poolingDataSource.setAccessToUnderlyingConnectionAllowed(Boolean.parseBoolean((String)attributes.get("accessToUnderlyingConnectionAllowed")));
            }
            cacheManager.putInRegionCache("JDBC_POOL", (Object)databaseConnection.getName(), (Object)pool);
            return poolingDataSource;
        }
        catch (Exception e) {
            throw new DBDatasourceServiceException((Throwable)e);
        }
    }

    protected static ConnectionFactory getConnectionFactory(IDatabaseConnection databaseConnection, String url) {
        Properties props = new Properties();
        props.put("user", StringEscapeUtils.unescapeHtml((String)databaseConnection.getUsername()));
        props.put("password", StringEscapeUtils.unescapeHtml((String)databaseConnection.getPassword()));
        if (url.startsWith("jdbc:mysql:") || url.startsWith("jdbc:mariadb:")) {
            props.put("connectTimeout", "5000");
        }
        return new DriverManagerConnectionFactory(url, props);
    }

    public static DataSource convert(IDatabaseConnection databaseConnection) throws DBDatasourceServiceException {
        return PooledDatasourceHelper.convert(databaseConnection, () -> PentahoSystem.get(IDatabaseDialectService.class, PentahoSessionHolder.getSession()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    static DataSource convert(IDatabaseConnection databaseConnection, Supplier<IDatabaseDialectService> dialectSupplier) throws DBDatasourceServiceException {
        DriverManagerDataSource basicDatasource = new DriverManagerDataSource();
        IDatabaseDialect dialect = Optional.ofNullable(dialectSupplier.get()).orElseThrow(() -> new DBDatasourceServiceException(Messages.getInstance().getErrorString("PooledDatasourceHelper.ERROR_0001_DATASOURCE_CANNOT_LOAD_DIALECT_SVC"))).getDialect(databaseConnection);
        if (databaseConnection.getDatabaseType() == null && dialect == null) {
            throw new DBDatasourceServiceException(Messages.getInstance().getErrorString("PooledDatasourceHelper.ERROR_0001_DATASOURCE_CREATE_ERROR_NO_DIALECT", databaseConnection.getName()));
        }
        if (databaseConnection.getDatabaseType().getShortName().equals("GENERIC")) {
            String driverClassName = (String)databaseConnection.getAttributes().get("CUSTOM_DRIVER_CLASS");
            if (StringUtils.isEmpty((String)driverClassName)) throw new DBDatasourceServiceException(Messages.getInstance().getErrorString("PooledDatasourceHelper.ERROR_0002_DATASOURCE_CREATE_ERROR_NO_CLASSNAME", databaseConnection.getName()));
            PooledDatasourceHelper.initDriverClass(basicDatasource, dialect, driverClassName, databaseConnection.getName());
        } else {
            if (StringUtils.isEmpty((String)dialect.getNativeDriver())) throw new DBDatasourceServiceException(Messages.getInstance().getErrorString("PooledDatasourceHelper.ERROR_0003_DATASOURCE_CREATE_ERROR_NO_DRIVER", databaseConnection.getName()));
            PooledDatasourceHelper.initDriverClass(basicDatasource, dialect, dialect.getNativeDriver(), databaseConnection.getName());
        }
        try {
            basicDatasource.setUrl(dialect.getURLWithExtraOptions(databaseConnection));
        }
        catch (DatabaseDialectException e) {
            basicDatasource.setUrl(null);
        }
        basicDatasource.setUsername(databaseConnection.getUsername());
        basicDatasource.setPassword(databaseConnection.getPassword());
        return basicDatasource;
    }

    private static void initDriverClass(DriverManagerDataSource driverManagerDataSource, IDatabaseDialect dialect, String driverClassName, String databaseConnectionName) throws DBDatasourceServiceException {
        if (dialect instanceof IDriverLocator) {
            if (!((IDriverLocator)dialect).initialize(driverClassName)) {
                throw new DriverNotInitializedException(Messages.getInstance().getErrorString("PooledDatasourceHelper.ERROR_0009_UNABLE_TO_POOL_DATASOURCE_CANT_INITIALIZE", databaseConnectionName, driverClassName));
            }
            return;
        }
        try {
            driverManagerDataSource.setDriverClassName(driverClassName);
        }
        catch (Throwable th) {
            throw new DBDatasourceServiceException(Messages.getInstance().getErrorString("PooledDatasourceHelper.ERROR_0002_DATASOURCE_CREATE_ERROR_NO_CLASSNAME", databaseConnectionName), th);
        }
    }

    public static DataSource getJndiDataSource(String dsName) throws DBDatasourceServiceException {
        try {
            InitialContext ctx = new InitialContext();
            Object lkup = null;
            DataSource rtn = null;
            NamingException firstNe = null;
            try {
                lkup = ctx.lookup(dsName);
                if (lkup != null) {
                    rtn = (DataSource)lkup;
                    return rtn;
                }
            }
            catch (NamingException ignored) {
                firstNe = ignored;
            }
            try {
                lkup = ctx.lookup("java:" + dsName);
                if (lkup != null) {
                    rtn = (DataSource)lkup;
                    return rtn;
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            try {
                lkup = ctx.lookup("java:comp/env/jdbc/" + dsName);
                if (lkup != null) {
                    rtn = (DataSource)lkup;
                    return rtn;
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            try {
                lkup = ctx.lookup("jdbc/" + dsName);
                if (lkup != null) {
                    rtn = (DataSource)lkup;
                    return rtn;
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            if (firstNe != null) {
                throw new DBDatasourceServiceException((Throwable)firstNe);
            }
            throw new DBDatasourceServiceException(dsName);
        }
        catch (NamingException ne) {
            throw new DBDatasourceServiceException((Throwable)ne);
        }
    }
}

