/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system;

import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.GlobalPentahoSessionHolderStrategy;
import org.pentaho.platform.engine.core.system.IPentahoSessionHolderStrategy;
import org.pentaho.platform.engine.core.system.InheritableThreadLocalPentahoSessionHolderStrategy;

public class PentahoSessionHolder {
    private static final Log logger = LogFactory.getLog(PentahoSessionHolder.class);
    public static final String MODE_INHERITABLETHREADLOCAL = "MODE_INHERITABLETHREADLOCAL";
    public static final String MODE_GLOBAL = "MODE_GLOBAL";
    public static final String SYSTEM_PROPERTY = "pentaho.sessionHolder.strategy";
    private static String strategyName = System.getProperty("pentaho.sessionHolder.strategy");
    private static IPentahoSessionHolderStrategy strategy;

    public static void setSession(IPentahoSession session) {
        strategy.setSession(session);
    }

    public static IPentahoSession getSession() {
        return strategy.getSession();
    }

    public static void removeSession() {
        strategy.removeSession();
    }

    private static void initialize() {
        if (strategyName == null || "".equals(strategyName)) {
            strategyName = MODE_INHERITABLETHREADLOCAL;
        }
        if (strategyName.equals(MODE_INHERITABLETHREADLOCAL)) {
            strategy = new InheritableThreadLocalPentahoSessionHolderStrategy();
        } else if (strategyName.equals(MODE_GLOBAL)) {
            strategy = new GlobalPentahoSessionHolderStrategy();
        } else {
            try {
                Class<?> clazz = Class.forName(strategyName);
                Constructor<?> customStrategy = clazz.getConstructor(new Class[0]);
                strategy = (IPentahoSessionHolderStrategy)customStrategy.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        logger.debug((Object)("PentahoSessionHolder initialized: strategy=" + strategyName));
    }

    public static void setStrategyName(String strategyName) {
        PentahoSessionHolder.strategyName = strategyName;
        PentahoSessionHolder.initialize();
    }

    static {
        PentahoSessionHolder.initialize();
    }
}

