/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt.tags.treeutil;

import java.util.Vector;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.ui.xul.components.XulTreeCell;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.containers.XulTreeItem;

public class XulTableColumnModifier
implements ICellModifier {
    XulTree tree;

    public XulTableColumnModifier(XulTree tree) {
        this.tree = tree;
    }

    public boolean canModify(Object arg0, String property) {
        return this.tree.getColumns().getColumn(Integer.parseInt(property)).isEditable();
    }

    public Object getValue(Object arg0, String property) {
        int colIdx = Integer.parseInt(property);
        XulTreeCell cell = ((XulTreeItem)arg0).getRow().getCell(colIdx);
        if (cell == null) {
            return "";
        }
        switch (this.tree.getColumns().getColumn(colIdx).getColumnType()) {
            case CHECKBOX: {
                return cell.getValue();
            }
            case COMBOBOX: 
            case EDITABLECOMBOBOX: {
                Vector vals = (Vector)cell.getValue();
                String[] items = new String[vals.size()];
                for (int i = 0; i < vals.size(); ++i) {
                    items[i] = "" + vals.get(i);
                }
                ((ComboBoxCellEditor)((TableViewer)this.tree.getManagedObject()).getCellEditors()[colIdx]).setItems(items);
                return cell.getSelectedIndex();
            }
            case TEXT: 
            case PASSWORD: {
                ((TextCellEditor)((TableViewer)this.tree.getManagedObject()).getCellEditors()[colIdx]).getControl().setEnabled(!cell.isDisabled());
                return cell.getLabel() != null ? cell.getLabel() : "";
            }
        }
        return cell.getValue();
    }

    public void modify(Object element, String property, Object value) {
        int colIdx = Integer.parseInt(property);
        XulTreeCell cell = ((XulTreeItem)((TableItem)element).getData()).getRow().getCell(colIdx);
        if (cell == null) {
            return;
        }
        switch (this.tree.getColumns().getColumn(colIdx).getColumnType()) {
            case CHECKBOX: {
                cell.setValue((Object)((Boolean)value));
                break;
            }
            case COMBOBOX: 
            case EDITABLECOMBOBOX: {
                if (value instanceof String) {
                    cell.setLabel((String)value);
                    break;
                }
                if ((Integer)value <= -1) break;
                cell.setSelectedIndex(((Integer)value).intValue());
                break;
            }
            default: {
                cell.setLabel((String)value);
            }
        }
        ((TableViewer)this.tree.getManagedObject()).refresh();
    }
}

