/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.s3n.vfs;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import java.util.Collection;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.pentaho.s3n.vfs.S3NFileObject;
import org.pentaho.s3n.vfs.S3NFileProvider;

public class S3NFileSystem
extends AbstractFileSystem
implements FileSystem {
    private AmazonS3 client;

    protected S3NFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(S3NFileProvider.capabilities);
    }

    protected FileObject createFile(AbstractFileName name) throws Exception {
        return new S3NFileObject(name, this);
    }

    public AmazonS3 getS3Client() {
        if (this.client == null) {
            try {
                this.client = (AmazonS3)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().enableForceGlobalBucketAccess()).build();
            }
            catch (Throwable t) {
                System.out.println("Could not get an S3Client");
                t.printStackTrace();
            }
        }
        return this.client;
    }
}

