/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.marketplace.domain.model.entities;

import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.pentaho.marketplace.domain.model.entities.interfaces.ICategory;

public class Category
implements ICategory {
    private final String name;
    private ICategory parent;
    private Map<String, ICategory> children;

    public Category(String name, ICategory parent) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name can not be null.");
        }
        this.name = name;
        this.parent = parent;
    }

    public Category(String name) {
        this(name, null);
    }

    @Override
    public ICategory getParent() {
        return this.parent;
    }

    @Override
    public ICategory setParent(ICategory parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public Map<String, ICategory> getChildren() {
        if (this.children == null) {
            this.children = new Hashtable<String, ICategory>();
        }
        return this.children;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        String parentString = this.parent != null ? this.parent.getName() : "null";
        return "(Category - Name: " + this.getName() + "Parent: " + parentString + ")";
    }

    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        if (otherObj == this) {
            return true;
        }
        if (!(otherObj instanceof ICategory)) {
            return false;
        }
        ICategory otherCategory = (ICategory)otherObj;
        return this.getName().equals(otherCategory.getName()) && this.getParent() == null ? otherCategory.getParent() == null : this.getParent().equals(otherCategory.getParent());
    }

    public int hashCode() {
        return new HashCodeBuilder(23, 41).append((Object)this.getName()).append((Object)this.getParent()).toHashCode();
    }
}

