/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.filechooser;

import java.io.File;
import java.util.prefs.Preferences;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.CommonFileChooser;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.SwingFileChooserService;

public class FileChooserService {
    private static final String LOCATION_POLICY = "org/pentaho/reporting/libraries/designtime/swing/CommonFileChooser/locationpolicy";
    private static final String LOCATION_PREFS = "org/pentaho/reporting/libraries/designtime/swing/CommonFileChooser/locations";
    private static final String STATIC_PREFS = "org/pentaho/reporting/libraries/designtime/swing/CommonFileChooser/staticprefs";
    public static final String DEFAULT_KEY = "__default__";
    private static FileChooserService instance;
    private Preferences locationPolicy = Preferences.userRoot().node("org/pentaho/reporting/libraries/designtime/swing/CommonFileChooser/locationpolicy");
    private Preferences staticLocationMappings;
    private Preferences resourceLocationMappings = Preferences.userRoot().node("org/pentaho/reporting/libraries/designtime/swing/CommonFileChooser/locations");

    public static synchronized FileChooserService getInstance() {
        if (instance == null) {
            instance = new FileChooserService();
        }
        return instance;
    }

    public FileChooserService() {
        this.staticLocationMappings = Preferences.userRoot().node(STATIC_PREFS);
    }

    public CommonFileChooser getFileChooser(String fileType) {
        return new SwingFileChooserService(fileType);
    }

    public boolean isStoreLocations(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.locationPolicy.getBoolean(key, this.locationPolicy.getBoolean(DEFAULT_KEY, true));
    }

    public void setStoreLocations(String key, boolean storeLocations) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.locationPolicy.putBoolean(key, storeLocations);
    }

    public File getStaticLocation(String aKey) {
        String staticLocationValue = this.staticLocationMappings.get(aKey, null);
        if (staticLocationValue != null) {
            return new File(staticLocationValue);
        }
        return null;
    }

    public void setStaticLocation(String aKey, File file) {
        if (file == null) {
            this.staticLocationMappings.remove(aKey);
        } else {
            this.staticLocationMappings.put(aKey, file.getAbsolutePath());
        }
    }

    public void setLastLocation(String aKey, File file) {
        if (file == null) {
            this.resourceLocationMappings.remove(aKey);
        } else {
            this.resourceLocationMappings.put(aKey, file.getAbsolutePath());
        }
    }

    public File getLastLocation(String aKey) {
        String staticLocationValue = this.resourceLocationMappings.get(aKey, null);
        if (staticLocationValue != null) {
            return new File(staticLocationValue);
        }
        return null;
    }
}

