/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.annotation;

import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationGroup;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationManager;
import org.pentaho.di.core.refinery.publish.util.ObjectUtils;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.trans.steps.annotation.BaseAnnotationStepDialog;
import org.pentaho.di.ui.trans.steps.common.ModelAnnotationsTableComposite;
import org.pentaho.di.ui.trans.steps.common.SharedDimensionComposite;
import org.pentaho.di.ui.util.SwtSvgImageUtil;

public class SharedDimensionDialog
extends BaseAnnotationStepDialog {
    private SharedDimensionComposite sharedDimensionComposite;
    private ModelAnnotationsTableComposite tableComposite;

    public SharedDimensionDialog(Shell parent, Object baseStepMeta, TransMeta transMeta, String stepname) {
        super(parent, baseStepMeta, transMeta, stepname);
        this.input.setSharedDimension(true);
    }

    @Override
    protected String getDialogTitle() {
        return BaseMessages.getString((Class)PKG, (String)"SharedDimension.Dialog.Title", (String[])new String[0]);
    }

    @Override
    protected String getStepName() {
        return BaseMessages.getString((Class)PKG, (String)"SharedDimension.StepName", (String[])new String[0]);
    }

    @Override
    protected Image getImageIcon() {
        return SwtSvgImageUtil.getUniversalImage((Display)this.shell.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"SharedDimensions.svg").getAsBitmapForSize((Device)this.shell.getDisplay(), 48, 48);
    }

    @Override
    protected void createContent(Control topWidget) {
        Control top = topWidget;
        top = this.createSharedDimensionComposite(top);
        top = this.createDescription(top);
        this.createFieldsTable(top);
        this.resizeSummaryColumn(this.tableComposite);
        this.sharedDimensionComposite.getOutputStepsWidget().addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent sel) {
                if (!StringUtils.equals((String)SharedDimensionDialog.this.input.getTargetOutputStep(), (String)SharedDimensionDialog.this.sharedDimensionComposite.getOutputStepName())) {
                    SharedDimensionDialog.this.onModelAnnotationDirty();
                }
            }
        });
        this.sharedDimensionComposite.getOutputStepsWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (!StringUtils.equals((String)SharedDimensionDialog.this.input.getTargetOutputStep(), (String)SharedDimensionDialog.this.sharedDimensionComposite.getOutputStepName())) {
                    SharedDimensionDialog.this.onModelAnnotationDirty();
                }
            }
        });
    }

    @Override
    protected ModelAnnotationManager getModelAnnotationManger() {
        return new ModelAnnotationManager(true);
    }

    @Override
    protected ModelAnnotationsTableComposite getTableComposite() {
        return this.tableComposite;
    }

    @Override
    protected String getSelectedModelAnnotationGroupName() {
        return this.sharedDimensionComposite.getGroupName();
    }

    @Override
    protected void initializeListeners() {
        super.initializeListeners();
    }

    @Override
    protected void afterOpen() {
        this.populateOutputSteps();
        this.populateCategories(this.envSub(this.input.getModelAnnotationCategory()), true);
        if (StringUtils.isBlank((String)this.envSub(this.input.getModelAnnotationCategory()))) {
            this.input.getModelAnnotations().setSharedDimension(true);
            this.populateTable(this.input.getModelAnnotations());
            this.sharedDimensionComposite.setEnableAddCopyButtons(false);
        } else {
            this.populateTableFromMetastore();
            if (StringUtil.isVariable((String)this.input.getModelAnnotationCategory())) {
                this.setAnnotationsEditEnabled(false);
                this.sharedDimensionComposite.setEnableAddCopyButtons(false);
            } else {
                this.sharedDimensionComposite.setEnableAddCopyButtons(true);
            }
        }
        this.wApply.setEnabled(false);
        this.getWGroups().setEditable(true);
    }

    @Override
    protected void populateTable(ModelAnnotationGroup modelAnnotations) {
        super.populateTable(modelAnnotations);
    }

    private void populateOutputSteps() {
        this.sharedDimensionComposite.populateOutputSteps(this.input, this.transMeta, this.getRepository(), this.getMetaStore());
    }

    private Control createSharedDimensionComposite(Control topWidget) {
        this.sharedDimensionComposite = new SharedDimensionComposite((Composite)this.shell, 0);
        this.sharedDimensionComposite.setVariables((VariableSpace)this.transMeta);
        this.sharedDimensionComposite.setLocalizationPkg(PKG);
        this.sharedDimensionComposite.setLog(this.log);
        this.sharedDimensionComposite.createWidgets();
        this.sharedDimensionComposite.setAddGroupListener(this.lsAddGroup);
        this.sharedDimensionComposite.setCopyGroupListener(this.lsCopyGroup);
        this.getWGroups().getCComboWidget().addListener(13, this.lsGroups);
        this.getWGroups().getCComboWidget().addListener(16, this.lsCheckForVariables);
        this.getWGroups().getCComboWidget().addListener(2, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 13) {
                    SharedDimensionDialog.this.sharedDimensionComposite.setFocus();
                }
            }
        });
        this.getWGroups().getCComboWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (StringUtils.equals((String)SharedDimensionDialog.this.getWGroups().getText(), (String)SharedDimensionDialog.this.getTableComposite().getData().getName())) {
                    SharedDimensionDialog.this.sharedDimensionComposite.setEnableAddCopyButtons(true);
                } else {
                    SharedDimensionDialog.this.sharedDimensionComposite.setEnableAddCopyButtons(false);
                }
            }
        });
        this.positionControl(this.sharedDimensionComposite, topWidget);
        return this.sharedDimensionComposite;
    }

    private void positionControl(Composite composite, Control topWidget) {
        FormData fData = new FormData();
        fData.top = new FormAttachment(topWidget, 15, 128);
        fData.left = new FormAttachment(0, 12);
        fData.right = new FormAttachment(topWidget, 0, 131072);
        composite.setLayoutData((Object)fData);
        this.props.setLook((Control)composite);
    }

    private void createFieldsTable(Control topWidget) {
        this.tableComposite = new ModelAnnotationsTableComposite((Composite)this.shell, topWidget, (Control)this.wBottomHorizontalSeparator){

            @Override
            protected void onDelete() {
                SharedDimensionDialog.this.deleteAnnotation();
            }

            @Override
            protected void onEdit() {
                SharedDimensionDialog.this.editAnnotation();
            }

            @Override
            protected void onGetFields() {
                SharedDimensionDialog.this.getFields();
            }

            @Override
            protected void onItemSelect() {
                this.toggleDeleteEditButtons();
            }

            @Override
            protected void onItemDoubleClick() {
                SharedDimensionDialog.this.editAnnotation();
            }

            @Override
            protected boolean supportsCalculatedMeasure() {
                return Boolean.FALSE;
            }

            @Override
            protected void onCreateCalculatedMeasure() {
                throw new UnsupportedOperationException();
            }
        };
        this.tableComposite.setLocalizationPkg(PKG);
        this.tableComposite.setLog(this.log);
        this.tableComposite.createWidgets();
    }

    @Override
    protected void onModelAnnotationDirty() {
        super.onModelAnnotationDirty();
        this.sharedDimensionComposite.setEnableAddCopyButtons(false);
        if (StringUtils.equals((String)this.getWGroups().getText(), (String)this.input.getModelAnnotationCategory())) {
            this.getWGroups().setEditable(false);
        }
    }

    @Override
    protected boolean applyChanges() {
        try {
            this.input.checkValidName(this.sharedDimensionComposite.getGroupName());
        }
        catch (Exception e) {
            this.showError(BaseMessages.getString((Class)PKG, (String)"ModelAnnotation.MetaStoreSaveError.Title", (String[])new String[0]), e.getLocalizedMessage());
            return false;
        }
        if (!this.sharedDimensionComposite.validateAnnotationGroup(this.tableComposite.getData())) {
            return false;
        }
        boolean prevChanged = this.input.hasChanged();
        String prevStepName = this.wStepname.getText();
        ModelAnnotationGroup prevAnnotations = ObjectUtils.deepClone(this.input.getModelAnnotations());
        String prevOutStep = this.input.getTargetOutputStep();
        String prevCategory = this.input.getModelAnnotationCategory();
        this.input.setChanged(prevChanged || !this.stepname.equals(this.wStepname.getText()) || !this.input.getModelAnnotations().equals((Object)this.tableComposite.getData()) || !StringUtils.equals((String)this.input.getModelAnnotations().getDescription(), (String)this.wDescription.getText()) || !StringUtils.equals((String)prevOutStep, (String)this.sharedDimensionComposite.getOutputStepName()));
        this.stepname = this.wStepname.getText();
        this.input.setModelAnnotations(this.tableComposite.getData());
        this.input.getModelAnnotations().setName(this.sharedDimensionComposite.getGroupName());
        this.input.getModelAnnotations().setDescription(this.wDescription.getText());
        this.input.getModelAnnotations().setSharedDimension(true);
        this.input.setSharedDimension(true);
        this.input.setTargetOutputStep(this.sharedDimensionComposite.getOutputStepName());
        this.input.setModelAnnotationCategory(this.getWGroups().getText());
        if (!StringUtil.isVariable((String)this.getWGroups().getText())) {
            try {
                this.input.saveToMetaStore(this.getMetaStore());
            }
            catch (Exception e) {
                this.showError(BaseMessages.getString((Class)PKG, (String)"ModelAnnotation.MetaStoreSaveError.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"ModelAnnotation.MetaStoreSaveError.Message", (String[])new String[]{e.getLocalizedMessage()}));
                this.input.setChanged(prevChanged);
                this.stepname = prevStepName;
                this.input.setModelAnnotations(prevAnnotations);
                this.input.setTargetOutputStep(prevOutStep);
                this.input.setModelAnnotationCategory(prevCategory);
                return false;
            }
            this.deleteStaleGroups(true);
            this.sharedDimensionComposite.setEnableAddCopyButtons(true);
            this.getWGroups().setEditable(true);
        }
        return true;
    }

    @Override
    protected ComboVar getWGroups() {
        return this.sharedDimensionComposite.getGroupComboWidget();
    }

    @Override
    protected ModelAnnotationGroup createNewAnnotationGroup() {
        ModelAnnotationGroup newGroup = new ModelAnnotationGroup();
        newGroup.setSharedDimension(true);
        return newGroup;
    }

    @Override
    protected String missingMessageKey() {
        return "ModelAnnotation.MissingSharedDimension.Message";
    }

    @Override
    protected String missingTitleKey() {
        return "ModelAnnotation.MissingSharedDimension.Title";
    }
}

