/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.refinery.publish.util;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class JAXBUtils {
    private static ObjectMapper mapper = new ObjectMapper();
    private static JaxbAnnotationModule module = new JaxbAnnotationModule();

    public static String marshallToXml(Object source) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{source.getClass()});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter writer = new StringWriter();
        marshaller.marshal(source, (Writer)writer);
        return writer.toString();
    }

    public static <T> T unmarshalFromXml(String xml, Class<T> destinationClass) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{destinationClass});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        StringReader reader = new StringReader(xml);
        return (T)unmarshaller.unmarshal((Reader)reader);
    }

    public static String marshallToJson(Object source) throws Exception {
        return mapper.writeValueAsString(source);
    }

    public static <T> T unmarshalFromJson(String json, Class<T> destinationClass) throws Exception {
        return (T)mapper.readValue(json, destinationClass);
    }

    static {
        mapper.configure(MapperFeature.USE_STD_BEAN_NAMING, true);
        mapper.registerModule((Module)module);
    }
}

