/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.util.Collection;
import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractSupportingTokenPolicyValidator;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.policy.model.AbstractToken;
import org.apache.wss4j.policy.model.IssuedToken;
import org.apache.wss4j.policy.model.KerberosToken;
import org.apache.wss4j.policy.model.KeyValueToken;
import org.apache.wss4j.policy.model.SamlToken;
import org.apache.wss4j.policy.model.SecurityContextToken;
import org.apache.wss4j.policy.model.SpnegoContextToken;
import org.apache.wss4j.policy.model.SupportingTokens;
import org.apache.wss4j.policy.model.UsernameToken;
import org.apache.wss4j.policy.model.X509Token;

public class EncryptedTokenPolicyValidator
extends AbstractSupportingTokenPolicyValidator {
    public EncryptedTokenPolicyValidator() {
        this.setEncrypted(true);
    }

    @Override
    public boolean validatePolicy(AssertionInfoMap aim, Message message, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults, List<WSSecurityEngineResult> encryptedResults) {
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "EncryptedSupportingTokens");
        if (!ais.isEmpty()) {
            this.setMessage(message);
            this.setResults(results);
            this.setSignedResults(signedResults);
            this.setEncryptedResults(encryptedResults);
            this.parsePolicies(aim, ais, message);
        }
        return true;
    }

    private void parsePolicies(AssertionInfoMap aim, Collection<AssertionInfo> ais, Message message) {
        if (this.isTLSInUse()) {
            AssertionInfo transportAi = EncryptedTokenPolicyValidator.getFirstAssertionByLocalname(aim, "TransportBinding");
            super.setEnforceEncryptedTokens(transportAi == null);
        }
        for (AssertionInfo ai : ais) {
            SupportingTokens binding = (SupportingTokens)ai.getAssertion();
            ai.setAsserted(true);
            this.setSignedParts(binding.getSignedParts());
            this.setEncryptedParts(binding.getEncryptedParts());
            this.setSignedElements(binding.getSignedElements());
            this.setEncryptedElements(binding.getEncryptedElements());
            List tokens = binding.getTokens();
            for (AbstractToken token : tokens) {
                if (!this.isTokenRequired(token, message)) continue;
                boolean processingFailed = false;
                if (token instanceof UsernameToken) {
                    if (!this.processUsernameTokens()) {
                        processingFailed = true;
                    }
                } else if (token instanceof KerberosToken) {
                    if (!this.processKerberosTokens()) {
                        processingFailed = true;
                    }
                } else if (token instanceof X509Token) {
                    if (!this.processX509Tokens()) {
                        processingFailed = true;
                    }
                } else if (token instanceof KeyValueToken) {
                    if (!this.processKeyValueTokens()) {
                        processingFailed = true;
                    }
                } else if (token instanceof SecurityContextToken || token instanceof SpnegoContextToken) {
                    if (!this.processSCTokens()) {
                        processingFailed = true;
                    }
                } else if (token instanceof SamlToken) {
                    if (!this.processSAMLTokens()) {
                        processingFailed = true;
                    }
                } else if (!(token instanceof IssuedToken)) {
                    processingFailed = true;
                }
                if (!processingFailed) continue;
                ai.setNotAsserted("The received token does not match the encrypted supporting token requirement");
            }
        }
    }
}

