/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapper;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.metrics2.MetricsExecutor;

@InterfaceAudience.Private
public class MetricsRegionWrapperImpl
implements MetricsRegionWrapper,
Closeable {
    private static final Log LOG = LogFactory.getLog(MetricsRegionWrapperImpl.class);
    public static final int PERIOD = 45;
    public static final String UNKNOWN = "unknown";
    private final HRegion region;
    private ScheduledExecutorService executor;
    private Runnable runnable;
    private long numStoreFiles;
    private long memstoreSize;
    private long storeFileSize;
    private long maxStoreFileAge;
    private long minStoreFileAge;
    private long avgStoreFileAge;
    private long numReferenceFiles;
    private ScheduledFuture<?> regionMetricsUpdateTask;

    public MetricsRegionWrapperImpl(HRegion region) {
        this.region = region;
        this.executor = ((MetricsExecutor)CompatibilitySingletonFactory.getInstance(MetricsExecutor.class)).getExecutor();
        this.runnable = new HRegionMetricsWrapperRunnable();
        this.regionMetricsUpdateTask = this.executor.scheduleWithFixedDelay(this.runnable, 45L, 45L, TimeUnit.SECONDS);
    }

    public String getTableName() {
        HTableDescriptor tableDesc = this.region.getTableDesc();
        if (tableDesc == null) {
            return UNKNOWN;
        }
        return tableDesc.getTableName().getQualifierAsString();
    }

    public String getNamespace() {
        HTableDescriptor tableDesc = this.region.getTableDesc();
        if (tableDesc == null) {
            return UNKNOWN;
        }
        return tableDesc.getTableName().getNamespaceAsString();
    }

    public String getRegionName() {
        HRegionInfo regionInfo = this.region.getRegionInfo();
        if (regionInfo == null) {
            return UNKNOWN;
        }
        return regionInfo.getEncodedName();
    }

    public long getNumStores() {
        Map<byte[], Store> stores = this.region.stores;
        if (stores == null) {
            return 0L;
        }
        return stores.size();
    }

    public long getNumStoreFiles() {
        return this.numStoreFiles;
    }

    public long getMemstoreSize() {
        return this.memstoreSize;
    }

    public long getStoreFileSize() {
        return this.storeFileSize;
    }

    public long getReadRequestCount() {
        return this.region.getReadRequestsCount();
    }

    public long getWriteRequestCount() {
        return this.region.getWriteRequestsCount();
    }

    public long getNumFilesCompacted() {
        return this.region.compactionNumFilesCompacted.get();
    }

    public long getNumBytesCompacted() {
        return this.region.compactionNumBytesCompacted.get();
    }

    public long getNumCompactionsCompleted() {
        return this.region.compactionsFinished.get();
    }

    public long getLastMajorCompactionAge() {
        long lastMajorCompactionTs = 0L;
        try {
            lastMajorCompactionTs = this.region.getOldestHfileTs(true);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Could not load HFile info ", (Throwable)ioe);
        }
        long now = EnvironmentEdgeManager.currentTime();
        return now - lastMajorCompactionTs;
    }

    public long getNumCompactionsFailed() {
        return this.region.compactionsFailed.get();
    }

    public long getMaxStoreFileAge() {
        return this.maxStoreFileAge;
    }

    public long getMinStoreFileAge() {
        return this.minStoreFileAge;
    }

    public long getAvgStoreFileAge() {
        return this.avgStoreFileAge;
    }

    public long getNumReferenceFiles() {
        return this.numReferenceFiles;
    }

    public int getRegionHashCode() {
        return this.region.hashCode();
    }

    @Override
    public void close() throws IOException {
        this.regionMetricsUpdateTask.cancel(true);
    }

    public int getReplicaId() {
        return this.region.getRegionInfo().getReplicaId();
    }

    public class HRegionMetricsWrapperRunnable
    implements Runnable {
        @Override
        public void run() {
            long tempNumStoreFiles = 0L;
            long tempMemstoreSize = 0L;
            long tempStoreFileSize = 0L;
            long tempMaxStoreFileAge = 0L;
            long tempMinStoreFileAge = Long.MAX_VALUE;
            long tempNumReferenceFiles = 0L;
            long avgAgeNumerator = 0L;
            long numHFiles = 0L;
            if (((MetricsRegionWrapperImpl)MetricsRegionWrapperImpl.this).region.stores != null) {
                for (Store store : ((MetricsRegionWrapperImpl)MetricsRegionWrapperImpl.this).region.stores.values()) {
                    tempNumStoreFiles += (long)store.getStorefilesCount();
                    tempMemstoreSize += store.getMemStoreSize();
                    tempStoreFileSize += store.getStorefilesSize();
                    long storeMaxStoreFileAge = store.getMaxStoreFileAge();
                    tempMaxStoreFileAge = storeMaxStoreFileAge > tempMaxStoreFileAge ? storeMaxStoreFileAge : tempMaxStoreFileAge;
                    long storeMinStoreFileAge = store.getMinStoreFileAge();
                    tempMinStoreFileAge = storeMinStoreFileAge < tempMinStoreFileAge ? storeMinStoreFileAge : tempMinStoreFileAge;
                    long storeHFiles = store.getNumHFiles();
                    avgAgeNumerator += store.getAvgStoreFileAge() * storeHFiles;
                    numHFiles += storeHFiles;
                    tempNumReferenceFiles += store.getNumReferenceFiles();
                }
            }
            MetricsRegionWrapperImpl.this.numStoreFiles = tempNumStoreFiles;
            MetricsRegionWrapperImpl.this.memstoreSize = tempMemstoreSize;
            MetricsRegionWrapperImpl.this.storeFileSize = tempStoreFileSize;
            MetricsRegionWrapperImpl.this.maxStoreFileAge = tempMaxStoreFileAge;
            if (tempMinStoreFileAge != Long.MAX_VALUE) {
                MetricsRegionWrapperImpl.this.minStoreFileAge = tempMinStoreFileAge;
            }
            if (numHFiles != 0L) {
                MetricsRegionWrapperImpl.this.avgStoreFileAge = avgAgeNumerator / numHFiles;
            }
            MetricsRegionWrapperImpl.this.numReferenceFiles = tempNumReferenceFiles;
        }
    }
}

