/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.DataSource;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapUtil;
import mondrian.server.Execution;
import mondrian.server.Locus;
import mondrian.server.monitor.SqlStatementEndEvent;
import mondrian.server.monitor.SqlStatementEvent;
import mondrian.server.monitor.SqlStatementExecuteEvent;
import mondrian.server.monitor.SqlStatementStartEvent;
import mondrian.spi.Dialect;
import mondrian.spi.DialectManager;
import mondrian.util.Counters;
import mondrian.util.DelegatingInvocationHandler;

public class SqlStatement {
    private static final String TIMING_NAME = "SqlStatement-";
    private static final AtomicLong ID_GENERATOR = new AtomicLong();
    private static final Semaphore querySemaphore = new Semaphore(MondrianProperties.instance().QueryLimit.get(), true);
    private final DataSource dataSource;
    private Connection jdbcConnection;
    private ResultSet resultSet;
    private final String sql;
    private final List<Type> types;
    private final int maxRows;
    private final int firstRowOrdinal;
    private final Locus locus;
    private final int resultSetType;
    private final int resultSetConcurrency;
    private boolean haveSemaphore;
    public int rowCount;
    private long startTimeNanos;
    private long startTimeMillis;
    private final List<Accessor> accessors = new ArrayList<Accessor>();
    private State state = State.FRESH;
    private final long id;
    private Util.Functor1<Void, Statement> callback;

    public SqlStatement(DataSource dataSource, String sql, List<Type> types, int maxRows, int firstRowOrdinal, Locus locus, int resultSetType, int resultSetConcurrency, Util.Functor1<Void, Statement> callback) {
        this.callback = callback;
        this.id = ID_GENERATOR.getAndIncrement();
        this.dataSource = dataSource;
        this.sql = sql;
        this.types = types;
        this.maxRows = maxRows;
        this.firstRowOrdinal = firstRowOrdinal;
        this.locus = locus;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
    }

    public void execute() {
        assert (this.state == State.FRESH) : "cannot re-execute";
        this.state = State.ACTIVE;
        Counters.SQL_STATEMENT_EXECUTE_COUNT.incrementAndGet();
        Counters.SQL_STATEMENT_EXECUTING_IDS.add(this.id);
        String status = "failed";
        Statement statement = null;
        try {
            RolapUtil.ExecuteQueryHook hook;
            this.locus.execution.checkCancelOrTimeout();
            this.jdbcConnection = this.dataSource.getConnection();
            querySemaphore.acquire();
            this.haveSemaphore = true;
            if (RolapUtil.SQL_LOGGER.isDebugEnabled()) {
                StringBuilder sqllog = new StringBuilder();
                sqllog.append(this.id).append(": ").append(this.locus.component).append(": executing sql [");
                if (this.sql.indexOf(10) >= 0) {
                    sqllog.append("\n");
                }
                sqllog.append(this.sql);
                sqllog.append(']');
                RolapUtil.SQL_LOGGER.debug((Object)sqllog.toString());
            }
            if ((hook = RolapUtil.getHook()) != null) {
                hook.onExecuteQuery(this.sql);
            }
            this.locus.execution.checkCancelOrTimeout();
            this.startTimeNanos = System.nanoTime();
            this.startTimeMillis = System.currentTimeMillis();
            statement = this.resultSetType < 0 || this.resultSetConcurrency < 0 ? this.jdbcConnection.createStatement() : this.jdbcConnection.createStatement(this.resultSetType, this.resultSetConcurrency);
            if (this.maxRows > 0) {
                statement.setMaxRows(this.maxRows);
            }
            if (this.getPurpose() != SqlStatementEvent.Purpose.CELL_SEGMENT) {
                this.locus.execution.registerStatement(this.locus, statement);
            } else if (this.callback != null) {
                this.callback.apply(statement);
            }
            this.locus.getServer().getMonitor().sendEvent(new SqlStatementStartEvent(this.startTimeMillis, this.id, this.locus, this.sql, this.getPurpose(), this.getCellRequestCount()));
            this.resultSet = statement.executeQuery(this.sql);
            this.state = State.ACTIVE;
            if (this.firstRowOrdinal > 0) {
                if (this.resultSetType == 1003) {
                    for (int i = 0; i < this.firstRowOrdinal; ++i) {
                        if (this.resultSet.next()) continue;
                        this.state = State.DONE;
                        break;
                    }
                } else if (!this.resultSet.absolute(this.firstRowOrdinal)) {
                    this.state = State.DONE;
                }
            }
            long timeMillis = System.currentTimeMillis();
            long timeNanos = System.nanoTime();
            long executeNanos = timeNanos - this.startTimeNanos;
            long executeMillis = executeNanos / 1000000L;
            Util.addDatabaseTime(executeMillis);
            status = ", exec " + executeMillis + " ms";
            this.locus.getServer().getMonitor().sendEvent(new SqlStatementExecuteEvent(timeMillis, this.id, this.locus, this.sql, this.getPurpose(), executeNanos));
            this.accessors.clear();
            for (Type type : this.guessTypes()) {
                this.accessors.add(this.createAccessor(this.accessors.size(), type));
            }
        }
        catch (Throwable e) {
            status = ", failed (" + e + ")";
            Util.close(null, statement, null);
            throw this.handle(e);
        }
        finally {
            RolapUtil.SQL_LOGGER.debug((Object)(this.id + ": " + status));
            if (RolapUtil.LOGGER.isDebugEnabled()) {
                RolapUtil.LOGGER.debug((Object)(this.locus.component + ": executing sql [" + this.sql + "]" + status));
            }
        }
    }

    public void close() {
        if (this.state == State.CLOSED) {
            return;
        }
        this.state = State.CLOSED;
        if (this.haveSemaphore) {
            this.haveSemaphore = false;
            querySemaphore.release();
        }
        SQLException ex = Util.close(this.resultSet, null, this.jdbcConnection);
        this.resultSet = null;
        this.jdbcConnection = null;
        if (ex != null) {
            throw Util.newError(ex, this.locus.message + "; sql=[" + this.sql + "]");
        }
        long endTime = System.currentTimeMillis();
        long totalMs = this.startTimeMillis == 0L ? 0L : endTime - this.startTimeMillis;
        String status = this.formatTimingStatus(totalMs, this.rowCount);
        this.locus.execution.getQueryTiming().markFull(TIMING_NAME + this.locus.component, totalMs);
        RolapUtil.SQL_LOGGER.debug((Object)(this.id + ": " + status));
        Counters.SQL_STATEMENT_CLOSE_COUNT.incrementAndGet();
        boolean remove = Counters.SQL_STATEMENT_EXECUTING_IDS.remove(this.id);
        status = status + ", ex=" + Counters.SQL_STATEMENT_EXECUTE_COUNT.get() + ", close=" + Counters.SQL_STATEMENT_CLOSE_COUNT.get() + ", open=" + Counters.SQL_STATEMENT_EXECUTING_IDS;
        if (RolapUtil.LOGGER.isDebugEnabled()) {
            RolapUtil.LOGGER.debug((Object)(this.locus.component + ": done executing sql [" + this.sql + "]" + status));
        }
        if (!remove) {
            throw new AssertionError((Object)("SqlStatement closed that was never executed: " + this.id));
        }
        this.locus.getServer().getMonitor().sendEvent(new SqlStatementEndEvent(endTime, this.id, this.locus, this.sql, this.getPurpose(), this.rowCount, false, null));
    }

    String formatTimingStatus(long totalMs, int rowCount) {
        return ", exec+fetch " + totalMs + " ms, " + rowCount + " rows";
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public RuntimeException handle(Throwable e) {
        RuntimeException runtimeException = Util.newError(e, this.locus.message + "; sql=[" + this.sql + "]");
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return runtimeException;
    }

    private Accessor createAccessor(int column, Type type) {
        final int columnPlusOne = column + 1;
        switch (type) {
            case OBJECT: {
                return new Accessor(){

                    @Override
                    public Object get() throws SQLException {
                        return SqlStatement.this.resultSet.getObject(columnPlusOne);
                    }
                };
            }
            case STRING: {
                return new Accessor(){

                    @Override
                    public Object get() throws SQLException {
                        return SqlStatement.this.resultSet.getString(columnPlusOne);
                    }
                };
            }
            case INT: {
                return new Accessor(){

                    @Override
                    public Object get() throws SQLException {
                        int val = SqlStatement.this.resultSet.getInt(columnPlusOne);
                        if (val == 0 && SqlStatement.this.resultSet.wasNull()) {
                            return null;
                        }
                        return val;
                    }
                };
            }
            case LONG: {
                return new Accessor(){

                    @Override
                    public Object get() throws SQLException {
                        long val = SqlStatement.this.resultSet.getLong(columnPlusOne);
                        if (val == 0L && SqlStatement.this.resultSet.wasNull()) {
                            return null;
                        }
                        return val;
                    }
                };
            }
            case DOUBLE: {
                return new Accessor(){

                    @Override
                    public Object get() throws SQLException {
                        double val = SqlStatement.this.resultSet.getDouble(columnPlusOne);
                        if (val == 0.0 && SqlStatement.this.resultSet.wasNull()) {
                            return null;
                        }
                        return val;
                    }
                };
            }
        }
        throw Util.unexpected(type);
    }

    public List<Type> guessTypes() throws SQLException {
        ResultSetMetaData metaData = this.resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        assert (this.types == null || this.types.size() == columnCount);
        ArrayList<Type> types = new ArrayList<Type>();
        for (int i = 0; i < columnCount; ++i) {
            Type suggestedType = this.types == null ? null : this.types.get(i);
            RolapSchema schema = this.locus.execution.getMondrianStatement().getMondrianConnection().getSchema();
            Dialect dialect = this.getDialect(schema);
            if (suggestedType != null) {
                types.add(suggestedType);
                continue;
            }
            if (dialect != null) {
                types.add(dialect.getType(metaData, i));
                continue;
            }
            types.add(Type.OBJECT);
        }
        return types;
    }

    protected Dialect getDialect(RolapSchema schema) {
        Dialect dialect = null;
        dialect = schema != null && schema.getDialect() != null ? schema.getDialect() : this.createDialect();
        return dialect;
    }

    protected Dialect createDialect() {
        return DialectManager.createDialect(this.dataSource, this.jdbcConnection);
    }

    public List<Accessor> getAccessors() throws SQLException {
        return this.accessors;
    }

    public ResultSet getWrappedResultSet() {
        return (ResultSet)Proxy.newProxyInstance(null, new Class[]{ResultSet.class}, (InvocationHandler)new MyDelegatingInvocationHandler(this));
    }

    private SqlStatementEvent.Purpose getPurpose() {
        if (this.locus instanceof StatementLocus) {
            return ((StatementLocus)this.locus).purpose;
        }
        return SqlStatementEvent.Purpose.OTHER;
    }

    private int getCellRequestCount() {
        if (this.locus instanceof StatementLocus) {
            return ((StatementLocus)this.locus).cellRequestCount;
        }
        return 0;
    }

    public static class StatementLocus
    extends Locus {
        private final SqlStatementEvent.Purpose purpose;
        private final int cellRequestCount;

        public StatementLocus(Execution execution, String component, String message, SqlStatementEvent.Purpose purpose, int cellRequestCount) {
            super(execution, component, message);
            this.purpose = purpose;
            this.cellRequestCount = cellRequestCount;
        }
    }

    private static enum State {
        FRESH,
        ACTIVE,
        DONE,
        CLOSED;

    }

    public static class MyDelegatingInvocationHandler
    extends DelegatingInvocationHandler {
        private final SqlStatement sqlStatement;

        MyDelegatingInvocationHandler(SqlStatement sqlStatement) {
            this.sqlStatement = sqlStatement;
        }

        @Override
        protected Object getTarget() throws InvocationTargetException {
            ResultSet resultSet = this.sqlStatement.getResultSet();
            if (resultSet == null) {
                throw new InvocationTargetException(new SQLException("Invalid operation. Statement is closed."));
            }
            return resultSet;
        }

        public void close() throws SQLException {
            this.sqlStatement.close();
        }
    }

    public static interface Accessor {
        public Object get() throws SQLException;
    }

    public static enum Type {
        OBJECT,
        DOUBLE,
        INT,
        LONG,
        STRING;


        public Object get(ResultSet resultSet, int column) throws SQLException {
            switch (this) {
                case OBJECT: {
                    return resultSet.getObject(column + 1);
                }
                case STRING: {
                    return resultSet.getString(column + 1);
                }
                case INT: {
                    return resultSet.getInt(column + 1);
                }
                case LONG: {
                    return resultSet.getLong(column + 1);
                }
                case DOUBLE: {
                    return resultSet.getDouble(column + 1);
                }
            }
            throw Util.unexpected(this);
        }
    }
}

