/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap4j;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import mondrian.olap.Level;
import mondrian.olap.Property;
import mondrian.olap4j.IMondrianOlap4jProperty;
import org.olap4j.impl.Named;
import org.olap4j.metadata.Datatype;
import org.olap4j.metadata.Property;

class MondrianOlap4jProperty
implements IMondrianOlap4jProperty,
Named {
    static final Map<String, MondrianOlap4jProperty> MEMBER_EXTENSIONS = new LinkedHashMap<String, MondrianOlap4jProperty>();
    static final Map<String, MondrianOlap4jProperty> CELL_EXTENSIONS = new LinkedHashMap<String, MondrianOlap4jProperty>();
    final Property property;
    Level level;

    MondrianOlap4jProperty(Property property) {
        this.property = property;
    }

    MondrianOlap4jProperty(Property property, Level level) {
        this(property);
        this.level = level;
    }

    public Datatype getDatatype() {
        switch (this.property.getType()) {
            case TYPE_BOOLEAN: {
                return Datatype.BOOLEAN;
            }
            case TYPE_NUMERIC: {
                return Datatype.DOUBLE;
            }
            case TYPE_INTEGER: {
                return Datatype.INTEGER;
            }
            case TYPE_LONG: {
                return Datatype.LARGE_INTEGER;
            }
            case TYPE_STRING: {
                return Datatype.STRING;
            }
            case TYPE_OTHER: {
                return Datatype.VARIANT;
            }
        }
        throw new RuntimeException("unexpected: " + (Object)((Object)this.property.getType()));
    }

    public Set<Property.TypeFlag> getType() {
        return this.property.isCellProperty() ? Property.TypeFlag.CELL_TYPE_FLAG : Property.TypeFlag.MEMBER_TYPE_FLAG;
    }

    public String getName() {
        return this.property.name;
    }

    public String getUniqueName() {
        return this.property.name;
    }

    public String getCaption() {
        return this.property.getCaption();
    }

    public String getDescription() {
        return this.property.getDescription();
    }

    public boolean isVisible() {
        return !this.property.isInternal();
    }

    public Property.ContentType getContentType() {
        return Property.ContentType.REGULAR;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    static {
        HashSet<String> memberNames = new HashSet<String>();
        for (Property.StandardMemberProperty property : Property.StandardMemberProperty.values()) {
            memberNames.add(property.getName());
        }
        HashSet<String> cellNames = new HashSet<String>();
        for (Property.StandardCellProperty property : Property.StandardCellProperty.values()) {
            cellNames.add(property.getName());
        }
        for (Property o : Property.enumeration.getValuesSortedByName()) {
            if (o.isMemberProperty() && !memberNames.contains(o.getName())) {
                MEMBER_EXTENSIONS.put(o.getName(), new MondrianOlap4jProperty(o));
            }
            if (!o.isCellProperty() || cellNames.contains(o.getName())) continue;
            CELL_EXTENSIONS.put(o.getName(), new MondrianOlap4jProperty(o));
        }
    }
}

