/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.coord.CoordUtils;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.Pair;
import org.apache.oozie.util.ParamChecker;

public class CoordActionsCountForJobIdJPAExecutor
implements JPAExecutor<Integer> {
    private String coordJobId = null;
    private Map<Pair<String, CoordinatorEngine.FILTER_COMPARATORS>, List<Object>> filterMap;

    public CoordActionsCountForJobIdJPAExecutor(String coordJobId, Map<Pair<String, CoordinatorEngine.FILTER_COMPARATORS>, List<Object>> filterMap) {
        ParamChecker.notNull(coordJobId, "coordJobId");
        this.coordJobId = coordJobId;
        this.filterMap = filterMap;
    }

    @Override
    public String getName() {
        return "CoordActionsCountForJobIdJPAExecutor";
    }

    @Override
    public Integer execute(EntityManager em) throws JPAExecutorException {
        try {
            Query q = em.createNamedQuery("GET_COORD_ACTIONS_COUNT_BY_JOBID");
            q = this.setQueryParameters(q, em);
            Long count = (Long)q.getSingleResult();
            return count.intValue();
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
    }

    private Query setQueryParameters(Query q, EntityManager em) {
        Map<String, Object> params = null;
        if (this.filterMap != null) {
            String query = q.toString();
            StringBuilder sbTotal = new StringBuilder(query);
            StringBuilder statusClause = new StringBuilder();
            params = CoordUtils.getWhereClause(statusClause, this.filterMap);
            sbTotal.insert(sbTotal.length(), statusClause);
            q = em.createQuery(sbTotal.toString());
        }
        if (params != null) {
            for (String pname : params.keySet()) {
                q.setParameter(pname, params.get(pname));
            }
        }
        q.setParameter("jobId", (Object)this.coordJobId);
        return q;
    }
}

