/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.requirejs.impl.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class JsonMerger {
    public Map<String, Object> merge(Map<String, ?> object1, Map<String, ?> object2) {
        HashSet<String> keys = new HashSet<String>(object1.keySet().size());
        keys.addAll(object1.keySet());
        keys.addAll(object2.keySet());
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : keys) {
            Object value1 = object1.get(key);
            Object value2 = object2.get(key);
            result.put(key, this.merge(key, value1, value2));
        }
        return result;
    }

    public List<Object> merge(List<?> array1, List<?> array2) {
        LinkedHashSet<Object> hs = new LinkedHashSet<Object>();
        this.copyToCollection(array1, hs);
        this.copyToCollection(array2, hs);
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(hs);
        return result;
    }

    public Map<String, Object> clone(Map<String, ?> jsonObject) {
        return this.cloneMap(jsonObject);
    }

    public List<Object> clone(List<?> array) {
        return this.cloneList(array);
    }

    private Object cloneValue(Object o) {
        if (o instanceof Map) {
            return this.cloneMap((Map)o);
        }
        if (o instanceof List) {
            return this.cloneList((List)o);
        }
        return o;
    }

    private Map<String, Object> cloneMap(Map<String, ?> jsonObject) {
        HashMap<String, Object> clone = new HashMap<String, Object>();
        jsonObject.keySet();
        for (String key : jsonObject.keySet()) {
            Object val = jsonObject.get(key);
            if (val instanceof Map) {
                clone.put(key, this.clone((Map)val));
                continue;
            }
            if (val instanceof List) {
                clone.put(key, this.clone((List)val));
                continue;
            }
            clone.put(key, val);
        }
        return clone;
    }

    private List<Object> cloneList(List<?> array) {
        ArrayList<Object> clone = new ArrayList<Object>();
        this.copyToCollection(array, clone);
        return clone;
    }

    private Object merge(String key, Object value1, Object value2) {
        if (value1 == null) {
            return this.cloneValue(value2);
        }
        if (value2 == null) {
            return this.cloneValue(value1);
        }
        if (value1 instanceof Map) {
            if (value2 instanceof Map) {
                return this.merge((Map)value1, (Map)value2);
            }
            throw new RuntimeException("Cannot merge key " + key + " due to different types");
        }
        if (value2 instanceof Map) {
            throw new RuntimeException("Cannot merge key " + key + " due to different types");
        }
        if (value1 instanceof List) {
            if (value2 instanceof List) {
                return this.merge((List)value1, (List)value2);
            }
            throw new RuntimeException("Cannot merge key " + key + " due to different types");
        }
        if (value2 instanceof List) {
            throw new RuntimeException("Cannot merge key " + key + " due to different types");
        }
        return this.cloneValue(value2);
    }

    private void copyToCollection(List array, Collection<Object> collection) {
        array.forEach(val -> collection.add(this.cloneValue(val)));
    }
}

