/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.optimizer.ConstantPropagateProcFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.util.ReflectionUtils;

public class ExprNodeDescUtils {
    public static int indexOf(ExprNodeDesc origin, List<ExprNodeDesc> sources) {
        for (int i = 0; i < sources.size(); ++i) {
            if (!origin.isSame(sources.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static ExprNodeDesc replace(ExprNodeDesc origin, List<ExprNodeDesc> sources, List<ExprNodeDesc> targets) {
        int index = ExprNodeDescUtils.indexOf(origin, sources);
        if (index >= 0) {
            return targets.get(index);
        }
        if (origin instanceof ExprNodeColumnDesc || origin instanceof ExprNodeFieldDesc) {
            return null;
        }
        if (origin instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc func = (ExprNodeGenericFuncDesc)origin;
            if (!FunctionRegistry.isDeterministic(func.getGenericUDF()) || FunctionRegistry.isStateful(func.getGenericUDF())) {
                return null;
            }
            ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
            for (int i = 0; i < origin.getChildren().size(); ++i) {
                ExprNodeDesc child = ExprNodeDescUtils.replace(origin.getChildren().get(i), sources, targets);
                if (child == null) {
                    return null;
                }
                children.add(child);
            }
            ExprNodeGenericFuncDesc clone = (ExprNodeGenericFuncDesc)func.clone();
            clone.setChildren(children);
            return clone;
        }
        return origin;
    }

    public static boolean containsPredicate(ExprNodeDesc source, ExprNodeDesc predicate) {
        if (source.isSame(predicate)) {
            return true;
        }
        return FunctionRegistry.isOpAnd(source) && (ExprNodeDescUtils.containsPredicate(source.getChildren().get(0), predicate) || ExprNodeDescUtils.containsPredicate(source.getChildren().get(1), predicate));
    }

    public static ExprNodeGenericFuncDesc mergePredicates(ExprNodeDesc prev, ExprNodeDesc next) {
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>(2);
        if (FunctionRegistry.isOpAnd(prev)) {
            children.addAll(prev.getChildren());
        } else {
            children.add(prev);
        }
        if (FunctionRegistry.isOpAnd(next)) {
            children.addAll(next.getChildren());
        } else {
            children.add(next);
        }
        return new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getGenericUDFForAnd(), children);
    }

    public static ExprNodeDesc mergePredicates(List<ExprNodeDesc> exprs) {
        ExprNodeDesc prev = null;
        for (ExprNodeDesc expr : exprs) {
            if (prev == null) {
                prev = expr;
                continue;
            }
            prev = ExprNodeDescUtils.mergePredicates(prev, expr);
        }
        return prev;
    }

    public static List<ExprNodeDesc> split(ExprNodeDesc current) {
        return ExprNodeDescUtils.split(current, new ArrayList<ExprNodeDesc>());
    }

    public static List<ExprNodeDesc> split(ExprNodeDesc current, List<ExprNodeDesc> splitted) {
        if (FunctionRegistry.isOpAnd(current)) {
            for (ExprNodeDesc child : current.getChildren()) {
                ExprNodeDescUtils.split(child, splitted);
            }
            return splitted;
        }
        if (ExprNodeDescUtils.indexOf(current, splitted) < 0) {
            splitted.add(current);
        }
        return splitted;
    }

    public static String recommendInputName(ExprNodeDesc desc) {
        if (desc instanceof ExprNodeColumnDesc) {
            return ((ExprNodeColumnDesc)desc).getColumn();
        }
        List<ExprNodeDesc> children = desc.getChildren();
        if (FunctionRegistry.isOpPreserveInputName(desc) && !children.isEmpty() && children.get(0) instanceof ExprNodeColumnDesc) {
            return ((ExprNodeColumnDesc)children.get(0)).getColumn();
        }
        return null;
    }

    public static boolean isDeterministic(ExprNodeDesc desc) {
        if (desc instanceof ExprNodeGenericFuncDesc && !FunctionRegistry.isDeterministic(((ExprNodeGenericFuncDesc)desc).getGenericUDF())) {
            return false;
        }
        if (desc.getChildren() != null) {
            for (ExprNodeDesc child : desc.getChildren()) {
                if (ExprNodeDescUtils.isDeterministic(child)) continue;
                return false;
            }
        }
        return true;
    }

    public static ArrayList<ExprNodeDesc> clone(List<ExprNodeDesc> sources) {
        ArrayList<ExprNodeDesc> result = new ArrayList<ExprNodeDesc>();
        for (ExprNodeDesc expr : sources) {
            result.add(expr.clone());
        }
        return result;
    }

    public static ArrayList<ExprNodeDesc> backtrack(List<ExprNodeDesc> sources, Operator<?> current, Operator<?> terminal) throws SemanticException {
        return ExprNodeDescUtils.backtrack(sources, current, terminal, false);
    }

    public static ArrayList<ExprNodeDesc> backtrack(List<ExprNodeDesc> sources, Operator<?> current, Operator<?> terminal, boolean foldExpr) throws SemanticException {
        ArrayList<ExprNodeDesc> result = new ArrayList<ExprNodeDesc>();
        for (ExprNodeDesc expr : sources) {
            result.add(ExprNodeDescUtils.backtrack(expr, current, terminal, foldExpr));
        }
        return result;
    }

    public static ExprNodeDesc backtrack(ExprNodeDesc source, Operator<?> current, Operator<?> terminal) throws SemanticException {
        return ExprNodeDescUtils.backtrack(source, current, terminal, false);
    }

    public static ExprNodeDesc backtrack(ExprNodeDesc source, Operator<?> current, Operator<?> terminal, boolean foldExpr) throws SemanticException {
        Operator<?> parent = ExprNodeDescUtils.getSingleParent(current, terminal);
        if (parent == null) {
            return source;
        }
        if (!foldExpr && ExprNodeDescUtils.isConstant(source)) {
            return source;
        }
        if (source instanceof ExprNodeGenericFuncDesc) {
            ExprNodeDesc foldedFunction;
            ExprNodeGenericFuncDesc function = (ExprNodeGenericFuncDesc)source.clone();
            ArrayList<ExprNodeDesc> children = ExprNodeDescUtils.backtrack(function.getChildren(), current, terminal, foldExpr);
            for (ExprNodeDesc child : children) {
                if (child != null) continue;
                return null;
            }
            function.setChildren(children);
            if (foldExpr && (foldedFunction = ConstantPropagateProcFactory.foldExpr(function)) != null) {
                return foldedFunction;
            }
            return function;
        }
        if (source instanceof ExprNodeColumnDesc) {
            ExprNodeColumnDesc column = (ExprNodeColumnDesc)source;
            return ExprNodeDescUtils.backtrack(column, parent, terminal);
        }
        if (source instanceof ExprNodeFieldDesc) {
            ExprNodeFieldDesc field = (ExprNodeFieldDesc)source.clone();
            ExprNodeDesc fieldDesc = ExprNodeDescUtils.backtrack(field.getDesc(), current, terminal, foldExpr);
            if (fieldDesc == null) {
                return null;
            }
            field.setDesc(fieldDesc);
            return field;
        }
        return source;
    }

    private static ExprNodeDesc backtrack(ExprNodeColumnDesc column, Operator<?> current, Operator<?> terminal) throws SemanticException {
        Map<String, ExprNodeDesc> mapping = current.getColumnExprMap();
        if (mapping == null) {
            return ExprNodeDescUtils.backtrack((ExprNodeDesc)column, current, terminal);
        }
        ExprNodeDesc mapped = mapping.get(column.getColumn());
        return mapped == null ? null : ExprNodeDescUtils.backtrack(mapped, current, terminal);
    }

    public static Operator<?> getSingleParent(Operator<?> current, Operator<?> terminal) throws SemanticException {
        if (current == terminal) {
            return null;
        }
        List<Operator<OperatorDesc>> parents = current.getParentOperators();
        if (parents == null || parents.isEmpty()) {
            if (terminal != null) {
                throw new SemanticException("Failed to meet terminal operator");
            }
            return null;
        }
        if (parents.size() == 1) {
            return parents.get(0);
        }
        if (terminal != null && parents.contains(terminal)) {
            return terminal;
        }
        throw new SemanticException("Met multiple parent operators");
    }

    public static List<ExprNodeDesc> resolveJoinKeysAsRSColumns(List<ExprNodeDesc> sourceList, Operator<?> reduceSinkOp) {
        ArrayList<ExprNodeDesc> result = new ArrayList<ExprNodeDesc>(sourceList.size());
        for (ExprNodeDesc source : sourceList) {
            ExprNodeDesc newExpr = ExprNodeDescUtils.resolveJoinKeysAsRSColumns(source, reduceSinkOp);
            if (newExpr == null) {
                return null;
            }
            result.add(newExpr);
        }
        return result;
    }

    public static ExprNodeDesc resolveJoinKeysAsRSColumns(ExprNodeDesc source, Operator<?> reduceSinkOp) {
        if (source == null) {
            return null;
        }
        for (Map.Entry<String, ExprNodeDesc> mapEntry : reduceSinkOp.getColumnExprMap().entrySet()) {
            if (!mapEntry.getValue().isSame(source)) continue;
            String columnInternalName = mapEntry.getKey();
            if (source instanceof ExprNodeColumnDesc) {
                ColumnInfo columnInfo = reduceSinkOp.getSchema().getColumnInfo(columnInternalName);
                return new ExprNodeColumnDesc(columnInfo);
            }
            return new ExprNodeColumnDesc(source.getTypeInfo(), columnInternalName, "", false);
        }
        return null;
    }

    public static ExprNodeDesc[] extractComparePair(ExprNodeDesc expr1, ExprNodeDesc expr2) {
        expr1 = ExprNodeDescUtils.extractConstant(expr1);
        expr2 = ExprNodeDescUtils.extractConstant(expr2);
        if (expr1 instanceof ExprNodeColumnDesc && expr2 instanceof ExprNodeConstantDesc) {
            return new ExprNodeDesc[]{expr1, expr2};
        }
        if (expr1 instanceof ExprNodeConstantDesc && expr2 instanceof ExprNodeColumnDesc) {
            return new ExprNodeDesc[]{expr1, expr2};
        }
        if (expr1 instanceof ExprNodeFieldDesc && expr2 instanceof ExprNodeConstantDesc) {
            ExprNodeDesc[] exprNodeDescArray;
            ExprNodeColumnDesc columnDesc = ExprNodeDescUtils.extractColumn(expr1);
            if (columnDesc != null) {
                ExprNodeDesc[] exprNodeDescArray2 = new ExprNodeDesc[3];
                exprNodeDescArray2[0] = columnDesc;
                exprNodeDescArray2[1] = expr2;
                exprNodeDescArray = exprNodeDescArray2;
                exprNodeDescArray2[2] = expr1;
            } else {
                exprNodeDescArray = null;
            }
            return exprNodeDescArray;
        }
        if (expr1 instanceof ExprNodeConstantDesc && expr2 instanceof ExprNodeFieldDesc) {
            ExprNodeDesc[] exprNodeDescArray;
            ExprNodeColumnDesc columnDesc = ExprNodeDescUtils.extractColumn(expr2);
            if (columnDesc != null) {
                ExprNodeDesc[] exprNodeDescArray3 = new ExprNodeDesc[3];
                exprNodeDescArray3[0] = expr1;
                exprNodeDescArray3[1] = columnDesc;
                exprNodeDescArray = exprNodeDescArray3;
                exprNodeDescArray3[2] = expr2;
            } else {
                exprNodeDescArray = null;
            }
            return exprNodeDescArray;
        }
        return null;
    }

    public static String[] extractFields(ExprNodeFieldDesc expr) {
        return ExprNodeDescUtils.extractFields(expr, new ArrayList<String>()).toArray(new String[0]);
    }

    private static List<String> extractFields(ExprNodeDesc expr, List<String> fields) {
        if (expr instanceof ExprNodeFieldDesc) {
            ExprNodeFieldDesc field = (ExprNodeFieldDesc)expr;
            fields.add(field.getFieldName());
            return ExprNodeDescUtils.extractFields(field.getDesc(), fields);
        }
        if (expr instanceof ExprNodeColumnDesc) {
            return fields;
        }
        throw new IllegalStateException("Unexpected exception while extracting fields from ExprNodeDesc");
    }

    private static ExprNodeColumnDesc extractColumn(ExprNodeDesc expr) {
        if (expr instanceof ExprNodeColumnDesc) {
            return (ExprNodeColumnDesc)expr;
        }
        if (expr instanceof ExprNodeFieldDesc) {
            return ExprNodeDescUtils.extractColumn(((ExprNodeFieldDesc)expr).getDesc());
        }
        return null;
    }

    private static ExprNodeDesc extractConstant(ExprNodeDesc expr) {
        if (!(expr instanceof ExprNodeGenericFuncDesc)) {
            return expr;
        }
        ExprNodeConstantDesc folded = ExprNodeDescUtils.foldConstant((ExprNodeGenericFuncDesc)expr);
        return folded == null ? expr : folded;
    }

    private static ExprNodeConstantDesc foldConstant(ExprNodeGenericFuncDesc func) {
        GenericUDF udf = func.getGenericUDF();
        if (!FunctionRegistry.isDeterministic(udf) || FunctionRegistry.isStateful(udf)) {
            return null;
        }
        try {
            Object internal;
            if (udf instanceof GenericUDFBridge ? ((UDF)(internal = (UDF)ReflectionUtils.newInstance(((GenericUDFBridge)udf).getUdfClass(), null))).getRequiredFiles() != null || ((UDF)internal).getRequiredJars() != null : udf.getRequiredFiles() != null || udf.getRequiredJars() != null) {
                return null;
            }
            if (func.getChildren() != null) {
                for (ExprNodeDesc child : func.getChildren()) {
                    if (child instanceof ExprNodeConstantDesc || child instanceof ExprNodeGenericFuncDesc && ExprNodeDescUtils.foldConstant((ExprNodeGenericFuncDesc)child) != null) continue;
                    return null;
                }
            }
            ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get(func);
            ObjectInspector output = evaluator.initialize(null);
            Object constant = evaluator.evaluate(null);
            Object java = ObjectInspectorUtils.copyToStandardJavaObject((Object)constant, (ObjectInspector)output);
            return new ExprNodeConstantDesc(java);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void getExprNodeColumnDesc(List<ExprNodeDesc> exprDescList, Map<Integer, ExprNodeDesc> hashCodeTocolumnDescMap) {
        for (ExprNodeDesc exprNodeDesc : exprDescList) {
            ExprNodeDescUtils.getExprNodeColumnDesc(exprNodeDesc, hashCodeTocolumnDescMap);
        }
    }

    public static void getExprNodeColumnDesc(ExprNodeDesc exprDesc, Map<Integer, ExprNodeDesc> hashCodeToColumnDescMap) {
        if (exprDesc instanceof ExprNodeColumnDesc) {
            hashCodeToColumnDescMap.put(exprDesc.hashCode(), exprDesc);
        } else if (exprDesc instanceof ExprNodeColumnListDesc) {
            for (ExprNodeDesc child : exprDesc.getChildren()) {
                ExprNodeDescUtils.getExprNodeColumnDesc(child, hashCodeToColumnDescMap);
            }
        } else if (exprDesc instanceof ExprNodeGenericFuncDesc) {
            for (ExprNodeDesc child : exprDesc.getChildren()) {
                ExprNodeDescUtils.getExprNodeColumnDesc(child, hashCodeToColumnDescMap);
            }
        } else if (exprDesc instanceof ExprNodeFieldDesc) {
            ExprNodeDescUtils.getExprNodeColumnDesc(((ExprNodeFieldDesc)exprDesc).getDesc(), hashCodeToColumnDescMap);
        }
    }

    public static boolean isConstant(ExprNodeDesc value) {
        if (value instanceof ExprNodeConstantDesc) {
            return true;
        }
        if (value instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc func = (ExprNodeGenericFuncDesc)value;
            if (!FunctionRegistry.isDeterministic(func.getGenericUDF())) {
                return false;
            }
            for (ExprNodeDesc child : func.getChildren()) {
                if (ExprNodeDescUtils.isConstant(child)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isAllConstants(List<ExprNodeDesc> value) {
        for (ExprNodeDesc expr : value) {
            if (expr instanceof ExprNodeConstantDesc) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullConstant(ExprNodeDesc value) {
        return value instanceof ExprNodeConstantDesc && ((ExprNodeConstantDesc)value).getValue() == null;
    }

    public static PrimitiveTypeInfo deriveMinArgumentCast(ExprNodeDesc childExpr, TypeInfo targetType) {
        assert (targetType instanceof PrimitiveTypeInfo) : "Not a primitive type" + targetType;
        PrimitiveTypeInfo pti = (PrimitiveTypeInfo)targetType;
        if (pti.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.DECIMAL || !(childExpr.getTypeInfo() instanceof PrimitiveTypeInfo)) {
            return pti;
        }
        PrimitiveTypeInfo childTi = (PrimitiveTypeInfo)childExpr.getTypeInfo();
        return HiveDecimalUtils.getDecimalTypeForPrimitiveCategory((PrimitiveTypeInfo)childTi);
    }

    public static ArrayList<ExprNodeDesc> genExprNodeDesc(Operator inputOp, int startPos, int endPos, boolean addEmptyTabAlias, boolean setColToNonVirtual) {
        ArrayList<ExprNodeDesc> exprColLst = new ArrayList<ExprNodeDesc>();
        ArrayList<ColumnInfo> colInfoLst = inputOp.getSchema().getSignature();
        for (int i = startPos; i <= endPos; ++i) {
            ColumnInfo ci = (ColumnInfo)colInfoLst.get(i);
            String tabAlias = ci.getTabAlias();
            if (addEmptyTabAlias) {
                tabAlias = "";
            }
            boolean vc = ci.getIsVirtualCol();
            if (setColToNonVirtual) {
                vc = false;
            }
            exprColLst.add(new ExprNodeColumnDesc(ci.getType(), ci.getInternalName(), tabAlias, vc));
        }
        return exprColLst;
    }

    public static List<ExprNodeDesc> flattenExprList(List<ExprNodeDesc> sourceList) {
        ArrayList<ExprNodeDesc> result = new ArrayList<ExprNodeDesc>(sourceList.size());
        for (ExprNodeDesc source : sourceList) {
            result.add(ExprNodeDescUtils.flattenExpr(source));
        }
        return result;
    }

    public static ExprNodeDesc flattenExpr(ExprNodeDesc source) {
        if (source instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc function = (ExprNodeGenericFuncDesc)source.clone();
            List<ExprNodeDesc> newChildren = ExprNodeDescUtils.flattenExprList(function.getChildren());
            for (ExprNodeDesc newChild : newChildren) {
                if (newChild != null) continue;
                return null;
            }
            function.setChildren(newChildren);
            return function;
        }
        if (source instanceof ExprNodeColumnDesc) {
            ExprNodeColumnDesc column = (ExprNodeColumnDesc)source;
            String newColumn = column.getColumn().replace('.', '_');
            return new ExprNodeColumnDesc(source.getTypeInfo(), newColumn, column.getTabAlias(), false);
        }
        if (source instanceof ExprNodeFieldDesc) {
            ExprNodeFieldDesc field = (ExprNodeFieldDesc)source.clone();
            ExprNodeDesc fieldDesc = ExprNodeDescUtils.flattenExpr(field.getDesc());
            if (fieldDesc == null) {
                return null;
            }
            field.setDesc(fieldDesc);
            return field;
        }
        return source;
    }

    public static String extractColName(ExprNodeDesc root) {
        if (root instanceof ExprNodeColumnDesc) {
            return ((ExprNodeColumnDesc)root).getColumn();
        }
        if (root.getChildren() == null) {
            return null;
        }
        String column = null;
        for (ExprNodeDesc d : root.getChildren()) {
            String candidate = ExprNodeDescUtils.extractColName(d);
            if (column != null && candidate != null) {
                return null;
            }
            if (candidate == null) continue;
            column = candidate;
        }
        return column;
    }

    public static ExprNodeColumnDesc getColumnExpr(ExprNodeDesc expr) {
        while (FunctionRegistry.isOpCast(expr)) {
            expr = expr.getChildren().get(0);
        }
        return expr instanceof ExprNodeColumnDesc ? (ExprNodeColumnDesc)expr : null;
    }

    public static ExprNodeDesc findConstantExprOrigin(String dpCol, Operator<? extends OperatorDesc> op) {
        ExprNodeDesc foldedExpr;
        ExprNodeDesc expr = op.getColumnExprMap().get(dpCol);
        if (expr instanceof ExprNodeGenericFuncDesc) {
            foldedExpr = ConstantPropagateProcFactory.foldExpr((ExprNodeGenericFuncDesc)expr);
            if (foldedExpr == null) {
                foldedExpr = expr;
            }
        } else {
            foldedExpr = expr;
        }
        if (foldedExpr instanceof ExprNodeColumnDesc) {
            Operator<OperatorDesc> originOp = null;
            for (Operator<OperatorDesc> parentOp : op.getParentOperators()) {
                if (parentOp.getColumnExprMap() == null) continue;
                originOp = parentOp;
                break;
            }
            if (originOp != null) {
                return ExprNodeDescUtils.findConstantExprOrigin(((ExprNodeColumnDesc)foldedExpr).getColumn(), originOp);
            }
        }
        return foldedExpr;
    }
}

