/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.orc.impl.OrcTail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalCache
implements OrcInputFormat.FooterCache {
    private static final Logger LOG = LoggerFactory.getLogger(LocalCache.class);
    private static final int DEFAULT_CACHE_INITIAL_CAPACITY = 1024;
    private final Cache<Path, OrcTail> cache;

    LocalCache(int numThreads, int cacheStripeDetailsSize, boolean useSoftRef) {
        CacheBuilder builder = CacheBuilder.newBuilder().initialCapacity(1024).concurrencyLevel(numThreads).maximumSize((long)cacheStripeDetailsSize);
        if (useSoftRef) {
            builder = builder.softValues();
        }
        this.cache = builder.build();
    }

    public void clear() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    public void put(Path path, OrcTail tail) {
        this.cache.put((Object)path, (Object)tail);
    }

    public OrcTail get(Path path) {
        return (OrcTail)this.cache.getIfPresent((Object)path);
    }

    @Override
    public void getAndValidate(List<HadoopShims.HdfsFileStatusWithId> files, boolean isOriginal, OrcTail[] result, ByteBuffer[] ppdResult) throws IOException, HiveException {
        assert (result.length == files.size());
        int i = -1;
        for (HadoopShims.HdfsFileStatusWithId fileWithId : files) {
            ++i;
            FileStatus file = fileWithId.getFileStatus();
            Path path = file.getPath();
            OrcTail tail = (OrcTail)this.cache.getIfPresent((Object)path);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Serialized tail " + (tail == null ? "not " : "") + "cached for path: " + path);
            }
            if (tail == null) continue;
            if (tail != null && file.getLen() == tail.getFileTail().getFileLength() && file.getModificationTime() == tail.getFileModificationTime()) {
                result[i] = tail;
                continue;
            }
            this.cache.invalidate((Object)path);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Meta-Info for : " + path + " changed. CachedModificationTime: " + tail.getFileModificationTime() + ", CurrentModificationTime: " + file.getModificationTime() + ", CachedLength: " + tail.getFileTail().getFileLength() + ", CurrentLength: " + file.getLen());
        }
    }

    @Override
    public boolean hasPpd() {
        return false;
    }

    @Override
    public boolean isBlocking() {
        return false;
    }

    @Override
    public void put(OrcInputFormat.FooterCacheKey cacheKey, OrcTail orcTail) throws IOException {
        this.put(cacheKey.getPath(), orcTail);
    }
}

