/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.DecimalUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class DecimalScalarModuloDecimalColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private HiveDecimal value;
    private int outputColumn;

    public DecimalScalarModuloDecimalColumn(HiveDecimal value, int colNum, int outputColumn) {
        this.colNum = colNum;
        this.value = value;
        this.outputColumn = outputColumn;
        this.outputType = "decimal";
    }

    public DecimalScalarModuloDecimalColumn() {
        this.outputType = "decimal";
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        DecimalColumnVector inputColVector = (DecimalColumnVector)batch.cols[this.colNum];
        DecimalColumnVector outputColVector = (DecimalColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.noNulls = inputColVector.noNulls;
        outputColVector.isRepeating = inputColVector.isRepeating;
        int n = batch.size;
        HiveDecimalWritable[] vector = inputColVector.vector;
        HiveDecimalWritable[] outputVector = outputColVector.vector;
        if (n == 0) {
            return;
        }
        if (inputColVector.noNulls) {
            NullUtil.initOutputNullsToFalse((ColumnVector)outputColVector, inputColVector.isRepeating, batch.selectedInUse, sel, n);
        }
        if (inputColVector.isRepeating) {
            DecimalUtil.moduloChecked(0, this.value, vector[0], outputColVector);
            outputIsNull[0] = inputIsNull[0];
        } else if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    DecimalUtil.moduloChecked(i, this.value, vector[i], outputColVector);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    DecimalUtil.moduloChecked(i, this.value, vector[i], outputColVector);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outputIsNull[i] = inputIsNull[i];
                DecimalUtil.moduloChecked(i, this.value, vector[i], outputColVector);
            }
        } else {
            System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
            for (int i = 0; i != n; ++i) {
                DecimalUtil.moduloChecked(i, this.value, vector[i], outputColVector);
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("decimal"), VectorExpressionDescriptor.ArgumentType.getType("decimal")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

