/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Date;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.io.Text;
import org.apache.hive.common.util.DateParser;

public class VectorUDFDateAddColCol
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum1;
    private int colNum2;
    private int outputColumn;
    protected boolean isPositive = true;
    private final transient Text text = new Text();
    private final transient Date date = new Date(0L);
    private final transient DateParser dateParser = new DateParser();

    public VectorUDFDateAddColCol(int colNum1, int colNum2, int outputColumn) {
        this();
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
        this.outputColumn = outputColumn;
    }

    public VectorUDFDateAddColCol() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        ColumnVector inputColVector1 = batch.cols[this.colNum1];
        LongColumnVector inputColVector2 = (LongColumnVector)batch.cols[this.colNum2];
        int[] sel = batch.selected;
        int n = batch.size;
        long[] vector2 = inputColVector2.vector;
        LongColumnVector outV = (LongColumnVector)batch.cols[this.outputColumn];
        long[] outputVector = outV.vector;
        if (n <= 0) {
            return;
        }
        NullUtil.propagateNullsColCol(inputColVector1, (ColumnVector)inputColVector2, (ColumnVector)outV, batch.selected, batch.size, batch.selectedInUse);
        switch (this.inputTypes[0]) {
            case DATE: {
                if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                    outV.isRepeating = true;
                    outputVector[0] = this.evaluateDate(inputColVector1, 0, vector2[0]);
                    break;
                }
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = this.evaluateDate(inputColVector1, i, vector2[i]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputVector[i] = this.evaluateDate(inputColVector1, i, vector2[i]);
                    }
                }
                break;
            }
            case TIMESTAMP: {
                if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                    outV.isRepeating = true;
                    outputVector[0] = this.evaluateTimestamp(inputColVector1, 0, vector2[0]);
                    break;
                }
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = this.evaluateTimestamp(inputColVector1, i, vector2[i]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputVector[i] = this.evaluateTimestamp(inputColVector1, i, vector2[i]);
                    }
                }
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                    outV.isRepeating = true;
                    this.evaluateString((BytesColumnVector)inputColVector1, outV, 0, vector2[0]);
                    break;
                }
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.evaluateString((BytesColumnVector)inputColVector1, outV, i, vector2[i]);
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        this.evaluateString((BytesColumnVector)inputColVector1, outV, i, vector2[i]);
                    }
                }
                break;
            }
            default: {
                throw new Error("Unsupported input type " + this.inputTypes[0].name());
            }
        }
    }

    protected long evaluateDate(ColumnVector columnVector, int index, long numDays) {
        LongColumnVector lcv = (LongColumnVector)columnVector;
        long days = lcv.vector[index];
        days = this.isPositive ? (days += numDays) : (days -= numDays);
        return days;
    }

    protected long evaluateTimestamp(ColumnVector columnVector, int index, long numDays) {
        TimestampColumnVector tcv = (TimestampColumnVector)columnVector;
        long days = DateWritable.millisToDays((long)tcv.getTime(index));
        days = this.isPositive ? (days += numDays) : (days -= numDays);
        return days;
    }

    protected void evaluateString(BytesColumnVector inputColumnVector1, LongColumnVector outputVector, int index, long numDays) {
        if (inputColumnVector1.isNull[index]) {
            outputVector.noNulls = false;
            outputVector.isNull[index] = true;
        } else {
            this.text.set(inputColumnVector1.vector[index], inputColumnVector1.start[index], inputColumnVector1.length[index]);
            boolean parsed = this.dateParser.parseDate(this.text.toString(), this.date);
            if (!parsed) {
                outputVector.noNulls = false;
                outputVector.isNull[index] = true;
                return;
            }
            long days = DateWritable.millisToDays((long)this.date.getTime());
            days = this.isPositive ? (days += numDays) : (days -= numDays);
            outputVector.vector[index] = days;
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "date";
    }

    public int getColNum1() {
        return this.colNum1;
    }

    public void setColNum1(int colNum1) {
        this.colNum1 = colNum1;
    }

    public int getColNum2() {
        return this.colNum2;
    }

    public void setColNum2(int colNum2) {
        this.colNum2 = colNum2;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_DATETIME_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

