/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.fast.SerializeWrite;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public final class VectorSerializeRow<T extends SerializeWrite> {
    private T serializeWrite;
    private Writer<T>[] writers;
    private boolean hasAnyNulls;
    private boolean isAllNulls;

    public VectorSerializeRow(T serializeWrite) {
        this();
        this.serializeWrite = serializeWrite;
    }

    private VectorSerializeRow() {
    }

    private Writer<T> createWriter(TypeInfo typeInfo, int columnIndex) throws HiveException {
        Writer writer;
        ObjectInspector.Category category = typeInfo.getCategory();
        block0 : switch (category) {
            case PRIMITIVE: {
                PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = primitiveTypeInfo.getPrimitiveCategory();
                switch (primitiveCategory) {
                    case BOOLEAN: {
                        writer = new BooleanWriter(columnIndex);
                        break block0;
                    }
                    case BYTE: {
                        writer = new ByteWriter(columnIndex);
                        break block0;
                    }
                    case SHORT: {
                        writer = new ShortWriter(columnIndex);
                        break block0;
                    }
                    case INT: {
                        writer = new IntWriter(columnIndex);
                        break block0;
                    }
                    case LONG: {
                        writer = new LongWriter(columnIndex);
                        break block0;
                    }
                    case DATE: {
                        writer = new DateWriter(columnIndex);
                        break block0;
                    }
                    case TIMESTAMP: {
                        writer = new TimestampWriter(columnIndex);
                        break block0;
                    }
                    case FLOAT: {
                        writer = new FloatWriter(columnIndex);
                        break block0;
                    }
                    case DOUBLE: {
                        writer = new DoubleWriter(columnIndex);
                        break block0;
                    }
                    case STRING: 
                    case CHAR: 
                    case VARCHAR: {
                        writer = new StringWriter(columnIndex);
                        break block0;
                    }
                    case BINARY: {
                        writer = new BinaryWriter(columnIndex);
                        break block0;
                    }
                    case DECIMAL: {
                        writer = new HiveDecimalWriter(columnIndex);
                        break block0;
                    }
                    case INTERVAL_YEAR_MONTH: {
                        writer = new IntervalYearMonthWriter(columnIndex);
                        break block0;
                    }
                    case INTERVAL_DAY_TIME: {
                        writer = new IntervalDayTimeWriter(columnIndex);
                        break block0;
                    }
                }
                throw new HiveException("Unexpected primitive type category " + primitiveCategory);
            }
            default: {
                throw new HiveException("Unexpected type category " + category);
            }
        }
        return writer;
    }

    public void init(List<String> typeNames, int[] columnMap) throws HiveException {
        this.writers = new Writer[typeNames.size()];
        for (int i = 0; i < typeNames.size(); ++i) {
            String typeName = typeNames.get(i);
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)typeName);
            int columnIndex = columnMap[i];
            Writer<T> writer = this.createWriter(typeInfo, columnIndex);
            this.writers[i] = writer;
        }
    }

    public void init(List<String> typeNames) throws HiveException {
        this.writers = new Writer[typeNames.size()];
        for (int i = 0; i < typeNames.size(); ++i) {
            String typeName = typeNames.get(i);
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)typeName);
            Writer<T> writer = this.createWriter(typeInfo, i);
            this.writers[i] = writer;
        }
    }

    public void init(TypeInfo[] typeInfos, int[] columnMap) throws HiveException {
        this.writers = new Writer[typeInfos.length];
        for (int i = 0; i < typeInfos.length; ++i) {
            int columnIndex = columnMap[i];
            Writer<T> writer = this.createWriter(typeInfos[i], columnIndex);
            this.writers[i] = writer;
        }
    }

    public int getCount() {
        return this.writers.length;
    }

    public void setOutput(ByteStream.Output output) {
        this.serializeWrite.set(output);
    }

    public void setOutputAppend(ByteStream.Output output) {
        this.serializeWrite.setAppend(output);
    }

    public void serializeWrite(VectorizedRowBatch batch, int batchIndex) throws IOException {
        this.hasAnyNulls = false;
        this.isAllNulls = true;
        for (Writer<T> writer : this.writers) {
            if (!writer.apply(batch, batchIndex)) {
                this.hasAnyNulls = true;
                continue;
            }
            this.isAllNulls = false;
        }
    }

    public boolean getHasAnyNulls() {
        return this.hasAnyNulls;
    }

    public boolean getIsAllNulls() {
        return this.isAllNulls;
    }

    private class HiveDecimalWriter
    extends Writer<T> {
        protected HiveDecimalWritable[] vector;

        HiveDecimalWriter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        boolean apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            DecimalColumnVector colVector = (DecimalColumnVector)batch.cols[this.columnIndex];
            if (colVector.isRepeating) {
                if (colVector.noNulls || !colVector.isNull[0]) {
                    VectorSerializeRow.this.serializeWrite.writeHiveDecimal(colVector.vector[0].getHiveDecimal(), (int)colVector.scale);
                    return true;
                }
                VectorSerializeRow.this.serializeWrite.writeNull();
                return false;
            }
            if (colVector.noNulls || !colVector.isNull[batchIndex]) {
                VectorSerializeRow.this.serializeWrite.writeHiveDecimal(colVector.vector[batchIndex].getHiveDecimal(), (int)colVector.scale);
                return true;
            }
            VectorSerializeRow.this.serializeWrite.writeNull();
            return false;
        }
    }

    private class BinaryWriter
    extends Writer<T> {
        BinaryWriter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        boolean apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            BytesColumnVector colVector = (BytesColumnVector)batch.cols[this.columnIndex];
            if (colVector.isRepeating) {
                if (colVector.noNulls || !colVector.isNull[0]) {
                    VectorSerializeRow.this.serializeWrite.writeBinary(colVector.vector[0], colVector.start[0], colVector.length[0]);
                    return true;
                }
                VectorSerializeRow.this.serializeWrite.writeNull();
                return false;
            }
            if (colVector.noNulls || !colVector.isNull[batchIndex]) {
                VectorSerializeRow.this.serializeWrite.writeBinary(colVector.vector[batchIndex], colVector.start[batchIndex], colVector.length[batchIndex]);
                return true;
            }
            VectorSerializeRow.this.serializeWrite.writeNull();
            return false;
        }
    }

    private class StringWriter
    extends Writer<T> {
        StringWriter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        boolean apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            BytesColumnVector colVector = (BytesColumnVector)batch.cols[this.columnIndex];
            if (colVector.isRepeating) {
                if (colVector.noNulls || !colVector.isNull[0]) {
                    VectorSerializeRow.this.serializeWrite.writeString(colVector.vector[0], colVector.start[0], colVector.length[0]);
                    return true;
                }
                VectorSerializeRow.this.serializeWrite.writeNull();
                return false;
            }
            if (colVector.noNulls || !colVector.isNull[batchIndex]) {
                VectorSerializeRow.this.serializeWrite.writeString(colVector.vector[batchIndex], colVector.start[batchIndex], colVector.length[batchIndex]);
                return true;
            }
            VectorSerializeRow.this.serializeWrite.writeNull();
            return false;
        }
    }

    private class DoubleWriter
    extends AbstractDoubleWriter {
        DoubleWriter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        boolean apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            DoubleColumnVector colVector = (DoubleColumnVector)batch.cols[this.columnIndex];
            if (colVector.isRepeating) {
                if (colVector.noNulls || !colVector.isNull[0]) {
                    VectorSerializeRow.this.serializeWrite.writeDouble(colVector.vector[0]);
                    return true;
                }
                VectorSerializeRow.this.serializeWrite.writeNull();
                return false;
            }
            if (colVector.noNulls || !colVector.isNull[batchIndex]) {
                VectorSerializeRow.this.serializeWrite.writeDouble(colVector.vector[batchIndex]);
                return true;
            }
            VectorSerializeRow.this.serializeWrite.writeNull();
            return false;
        }
    }

    private class FloatWriter
    extends AbstractDoubleWriter {
        FloatWriter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        boolean apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            DoubleColumnVector colVector = (DoubleColumnVector)batch.cols[this.columnIndex];
            if (colVector.isRepeating) {
                if (colVector.noNulls || !colVector.isNull[0]) {
                    VectorSerializeRow.this.serializeWrite.writeFloat((float)colVector.vector[0]);
                    return true;
                }
                VectorSerializeRow.this.serializeWrite.writeNull();
                return false;
            }
            if (colVector.noNulls || !colVector.isNull[batchIndex]) {
                VectorSerializeRow.this.serializeWrite.writeFloat((float)colVector.vector[batchIndex]);
                return true;
            }
            VectorSerializeRow.this.serializeWrite.writeNull();
            return false;
        }
    }

    private abstract class AbstractDoubleWriter
    extends Writer<T> {
        AbstractDoubleWriter(int columnIndex) {
            super(columnIndex);
        }
    }

    private class IntervalDayTimeWriter
    extends Writer {
        private HiveIntervalDayTime hiveIntervalDayTime;

        IntervalDayTimeWriter(int columnIndex) {
            super(columnIndex);
            this.hiveIntervalDayTime = new HiveIntervalDayTime();
        }

        @Override
        boolean apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            IntervalDayTimeColumnVector colVector = (IntervalDayTimeColumnVector)batch.cols[this.columnIndex];
            if (colVector.isRepeating) {
                if (colVector.noNulls || !colVector.isNull[0]) {
                    this.hiveIntervalDayTime.set(colVector.asScratchIntervalDayTime(0));
                    VectorSerializeRow.this.serializeWrite.writeHiveIntervalDayTime(this.hiveIntervalDayTime);
                    return true;
                }
                VectorSerializeRow.this.serializeWrite.writeNull();
                return false;
            }
            if (colVector.noNulls || !colVector.isNull[batchIndex]) {
                this.hiveIntervalDayTime.set(colVector.asScratchIntervalDayTime(batchIndex));
                VectorSerializeRow.this.serializeWrite.writeHiveIntervalDayTime(this.hiveIntervalDayTime);
                return true;
            }
            VectorSerializeRow.this.serializeWrite.writeNull();
            return false;
        }
    }

    private class IntervalYearMonthWriter
    extends AbstractLongWriter {
        IntervalYearMonthWriter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        boolean apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            LongColumnVector colVector = (LongColumnVector)batch.cols[this.columnIndex];
            if (colVector.isRepeating) {
                if (colVector.noNulls || !colVector.isNull[0]) {
                    VectorSerializeRow.this.serializeWrite.writeHiveIntervalYearMonth((int)colVector.vector[0]);
                    return true;
                }
                VectorSerializeRow.this.serializeWrite.writeNull();
                return false;
            }
            if (colVector.noNulls || !colVector.isNull[batchIndex]) {
                VectorSerializeRow.this.serializeWrite.writeHiveIntervalYearMonth((int)colVector.vector[batchIndex]);
                return true;
            }
            VectorSerializeRow.this.serializeWrite.writeNull();
            return false;
        }
    }

    private class TimestampWriter
    extends Writer {
        Timestamp scratchTimestamp;

        TimestampWriter(int columnIndex) {
            super(columnIndex);
            this.scratchTimestamp = new Timestamp(0L);
        }

        @Override
        boolean apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            TimestampColumnVector colVector = (TimestampColumnVector)batch.cols[this.columnIndex];
            if (colVector.isRepeating) {
                if (colVector.noNulls || !colVector.isNull[0]) {
                    colVector.timestampUpdate(this.scratchTimestamp, 0);
                    VectorSerializeRow.this.serializeWrite.writeTimestamp(this.scratchTimestamp);
                    return true;
                }
                VectorSerializeRow.this.serializeWrite.writeNull();
                return false;
            }
            if (colVector.noNulls || !colVector.isNull[batchIndex]) {
                colVector.timestampUpdate(this.scratchTimestamp, batchIndex);
                VectorSerializeRow.this.serializeWrite.writeTimestamp(this.scratchTimestamp);
                return true;
            }
            VectorSerializeRow.this.serializeWrite.writeNull();
            return false;
        }
    }

    private class DateWriter
    extends AbstractLongWriter {
        DateWriter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        boolean apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            LongColumnVector colVector = (LongColumnVector)batch.cols[this.columnIndex];
            if (colVector.isRepeating) {
                if (colVector.noNulls || !colVector.isNull[0]) {
                    VectorSerializeRow.this.serializeWrite.writeDate((int)colVector.vector[0]);
                    return true;
                }
                VectorSerializeRow.this.serializeWrite.writeNull();
                return false;
            }
            if (colVector.noNulls || !colVector.isNull[batchIndex]) {
                VectorSerializeRow.this.serializeWrite.writeDate((int)colVector.vector[batchIndex]);
                return true;
            }
            VectorSerializeRow.this.serializeWrite.writeNull();
            return false;
        }
    }

    private class LongWriter
    extends AbstractLongWriter {
        LongWriter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        boolean apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            LongColumnVector colVector = (LongColumnVector)batch.cols[this.columnIndex];
            if (colVector.isRepeating) {
                if (colVector.noNulls || !colVector.isNull[0]) {
                    VectorSerializeRow.this.serializeWrite.writeLong(colVector.vector[0]);
                    return true;
                }
                VectorSerializeRow.this.serializeWrite.writeNull();
                return false;
            }
            if (colVector.noNulls || !colVector.isNull[batchIndex]) {
                VectorSerializeRow.this.serializeWrite.writeLong(colVector.vector[batchIndex]);
                return true;
            }
            VectorSerializeRow.this.serializeWrite.writeNull();
            return false;
        }
    }

    private class IntWriter
    extends AbstractLongWriter {
        IntWriter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        boolean apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            LongColumnVector colVector = (LongColumnVector)batch.cols[this.columnIndex];
            if (colVector.isRepeating) {
                if (colVector.noNulls || !colVector.isNull[0]) {
                    VectorSerializeRow.this.serializeWrite.writeInt((int)colVector.vector[0]);
                    return true;
                }
                VectorSerializeRow.this.serializeWrite.writeNull();
                return false;
            }
            if (colVector.noNulls || !colVector.isNull[batchIndex]) {
                VectorSerializeRow.this.serializeWrite.writeInt((int)colVector.vector[batchIndex]);
                return true;
            }
            VectorSerializeRow.this.serializeWrite.writeNull();
            return false;
        }
    }

    private class ShortWriter
    extends AbstractLongWriter {
        ShortWriter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        boolean apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            LongColumnVector colVector = (LongColumnVector)batch.cols[this.columnIndex];
            if (colVector.isRepeating) {
                if (colVector.noNulls || !colVector.isNull[0]) {
                    VectorSerializeRow.this.serializeWrite.writeShort((short)colVector.vector[0]);
                    return true;
                }
                VectorSerializeRow.this.serializeWrite.writeNull();
                return false;
            }
            if (colVector.noNulls || !colVector.isNull[batchIndex]) {
                VectorSerializeRow.this.serializeWrite.writeShort((short)colVector.vector[batchIndex]);
                return true;
            }
            VectorSerializeRow.this.serializeWrite.writeNull();
            return false;
        }
    }

    private class ByteWriter
    extends AbstractLongWriter {
        ByteWriter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        boolean apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            LongColumnVector colVector = (LongColumnVector)batch.cols[this.columnIndex];
            if (colVector.isRepeating) {
                if (colVector.noNulls || !colVector.isNull[0]) {
                    VectorSerializeRow.this.serializeWrite.writeByte((byte)colVector.vector[0]);
                    return true;
                }
                VectorSerializeRow.this.serializeWrite.writeNull();
                return false;
            }
            if (colVector.noNulls || !colVector.isNull[batchIndex]) {
                VectorSerializeRow.this.serializeWrite.writeByte((byte)colVector.vector[batchIndex]);
                return true;
            }
            VectorSerializeRow.this.serializeWrite.writeNull();
            return false;
        }
    }

    private class BooleanWriter
    extends AbstractLongWriter {
        BooleanWriter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        boolean apply(VectorizedRowBatch batch, int batchIndex) throws IOException {
            LongColumnVector colVector = (LongColumnVector)batch.cols[this.columnIndex];
            if (colVector.isRepeating) {
                if (colVector.noNulls || !colVector.isNull[0]) {
                    VectorSerializeRow.this.serializeWrite.writeBoolean(colVector.vector[0] != 0L);
                    return true;
                }
                VectorSerializeRow.this.serializeWrite.writeNull();
                return false;
            }
            if (colVector.noNulls || !colVector.isNull[batchIndex]) {
                VectorSerializeRow.this.serializeWrite.writeBoolean(colVector.vector[batchIndex] != 0L);
                return true;
            }
            VectorSerializeRow.this.serializeWrite.writeNull();
            return false;
        }
    }

    private abstract class AbstractLongWriter
    extends Writer<T> {
        AbstractLongWriter(int columnIndex) {
            super(columnIndex);
        }
    }

    private abstract class Writer<W extends SerializeWrite> {
        protected int columnIndex;

        Writer(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        abstract boolean apply(VectorizedRowBatch var1, int var2) throws IOException;
    }
}

