/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.events;

import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.PreEventContext;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class PreDropPartitionEvent
extends PreEventContext {
    private final Partition partition;
    private final Table table;
    private final boolean deleteData;

    public PreDropPartitionEvent(Partition partition, boolean deleteData, HiveMetaStore.HMSHandler handler) {
        super(PreEventContext.PreEventType.DROP_PARTITION, handler);
        this.partition = partition;
        this.table = null;
        this.deleteData = false;
    }

    public PreDropPartitionEvent(Table table, Partition partition, boolean deleteData, HiveMetaStore.HMSHandler handler) {
        super(PreEventContext.PreEventType.DROP_PARTITION, handler);
        this.partition = partition;
        this.table = table;
        this.deleteData = false;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public Table getTable() {
        return this.table;
    }

    public boolean getDeleteData() {
        return this.deleteData;
    }
}

