/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaTimestamp;
import org.pentaho.di.trans.dataservice.optimization.PushDownOptimizationException;

public class ValueMetaResolver {
    private final Map<String, ValueMetaInterface> fieldNameValueMetaMap;
    private static final String ANSI_DATE_LITERAL = "yyyy-MM-dd";
    private static final String ANSI_TIMESTAMP_LITERAL = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String NUMERIC_LITERAL = "###0.###";
    private static final Function<ValueMetaInterface, ValueMetaInterface> setDefaultConversionMask = new Function<ValueMetaInterface, ValueMetaInterface>(){

        public ValueMetaInterface apply(ValueMetaInterface valueMetaInterface) {
            valueMetaInterface = valueMetaInterface.clone();
            String mask = valueMetaInterface.getConversionMask();
            boolean isStorageBinaryString = valueMetaInterface.isStorageBinaryString();
            if (mask == null || mask.isEmpty() || isStorageBinaryString) {
                switch (valueMetaInterface.getType()) {
                    case 3: {
                        valueMetaInterface.setConversionMask(ValueMetaResolver.ANSI_DATE_LITERAL);
                        break;
                    }
                    case 9: {
                        valueMetaInterface.setConversionMask(ValueMetaResolver.ANSI_TIMESTAMP_LITERAL);
                        break;
                    }
                    case 1: 
                    case 5: 
                    case 6: {
                        valueMetaInterface.setConversionMask(ValueMetaResolver.NUMERIC_LITERAL);
                    }
                }
            }
            return valueMetaInterface;
        }
    };

    public ValueMetaResolver(RowMetaInterface rowMeta) {
        this.fieldNameValueMetaMap = FluentIterable.from((Iterable)rowMeta.getValueMetaList()).transform(setDefaultConversionMask).uniqueIndex((Function)new Function<ValueMetaInterface, String>(){

            public String apply(ValueMetaInterface valueMetaInterface) {
                return valueMetaInterface.getName();
            }
        });
    }

    public RowMetaInterface getRowMeta() {
        RowMeta rowMeta = new RowMeta();
        for (ValueMetaInterface valueMetaInterface : this.fieldNameValueMetaMap.values()) {
            rowMeta.addValueMeta(valueMetaInterface);
        }
        return rowMeta;
    }

    public ValueMetaInterface getValueMeta(String fieldName) throws PushDownOptimizationException {
        ValueMetaInterface valueMeta = this.fieldNameValueMetaMap.get(fieldName);
        if (valueMeta == null) {
            throw new PushDownOptimizationException(String.format("Field '%s' not found", fieldName));
        }
        return valueMeta;
    }

    public Object getTypedValue(String fieldName, int originalType, Object value) throws PushDownOptimizationException {
        ValueMetaInterface valueMeta = this.getValueMeta(fieldName);
        if (valueMeta.getType() == originalType) {
            return value;
        }
        return this.convertToType(valueMeta, originalType, value);
    }

    public Object[] inListToTypedObjectArray(String fieldName, String value) throws PushDownOptimizationException {
        Object[] inList = Const.splitString((String)value, (char)';', (boolean)true);
        this.unescapeList((String[])inList);
        ValueMetaInterface valueMeta = this.getValueMeta(fieldName);
        if (valueMeta.isString()) {
            return inList;
        }
        return this.convertArrayToType((String[])inList, valueMeta);
    }

    private void unescapeList(String[] inList) {
        for (int i = 0; i < inList.length; ++i) {
            inList[i] = inList[i] == null ? null : inList[i].replace("\\;", ";");
        }
    }

    private Object[] convertArrayToType(String[] inList, ValueMetaInterface valueMeta) throws PushDownOptimizationException {
        int type = valueMeta.getType();
        Object[] objects = this.getTypedArray(type, inList.length);
        for (int i = 0; i < inList.length; ++i) {
            objects[i] = this.convertToType(valueMeta, 2, inList[i]);
        }
        return objects;
    }

    private Object[] getTypedArray(int type, int length) throws PushDownOptimizationException {
        switch (type) {
            case 1: {
                return new Double[length];
            }
            case 3: {
                return new Date[length];
            }
            case 9: {
                return new Timestamp[length];
            }
            case 4: {
                return new Boolean[length];
            }
            case 5: {
                return new Long[length];
            }
            case 6: {
                return new BigDecimal[length];
            }
        }
        throw new PushDownOptimizationException("Cannot create an array of type code " + type);
    }

    private Object convertToType(ValueMetaInterface valueMeta, int originalType, Object value) throws PushDownOptimizationException {
        try {
            ValueMeta meta = new ValueMeta(null, originalType);
            meta.setConversionMask(valueMeta.getConversionMask());
            return valueMeta.convertData((ValueMetaInterface)meta, value);
        }
        catch (KettleValueException valueException) {
            Object val = this.tryAnsiFormatConversion(valueMeta, originalType, value);
            if (val == null) {
                throw new PushDownOptimizationException("Failed to convert type", valueException);
            }
            return val;
        }
    }

    private Object tryAnsiFormatConversion(ValueMetaInterface valueMeta, int originalType, Object value) throws PushDownOptimizationException {
        if (valueMeta.getType() == 3) {
            return this.tryConversionWithMask(valueMeta, originalType, value, ANSI_DATE_LITERAL);
        }
        if (valueMeta.getType() == 9) {
            return this.tryConversionWithMask((ValueMetaInterface)new ValueMetaTimestamp(), originalType, value, ANSI_TIMESTAMP_LITERAL);
        }
        return null;
    }

    private Object tryConversionWithMask(ValueMetaInterface valueMeta, int originalType, Object value, String mask) throws PushDownOptimizationException {
        ValueMeta originalTypeMeta = new ValueMeta(null, originalType);
        originalTypeMeta.setConversionMask(mask);
        try {
            return valueMeta.convertData((ValueMetaInterface)originalTypeMeta, value);
        }
        catch (KettleValueException e) {
            throw new PushDownOptimizationException("Failed to convert type", e);
        }
    }
}

