/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cassandrainput;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.cassandra.ConnectionFactory;
import org.pentaho.cassandra.spi.CQLRowHandler;
import org.pentaho.cassandra.spi.Connection;
import org.pentaho.cassandra.spi.ITableMetaData;
import org.pentaho.cassandra.spi.Keyspace;
import org.pentaho.cassandra.util.CassandraUtils;
import org.pentaho.cassandra.util.Compression;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.cassandrainput.CassandraInputData;
import org.pentaho.di.trans.steps.cassandrainput.CassandraInputMeta;

public class CassandraInput
extends BaseStep
implements StepInterface {
    protected CassandraInputMeta m_meta;
    protected CassandraInputData m_data;
    protected Connection m_connection;
    protected Keyspace m_keyspace;
    protected ITableMetaData m_cassandraMeta;
    protected CQLRowHandler m_cqlHandler;
    protected Map<String, Integer> m_outputFormatMap = new HashMap<String, Integer>();
    protected Object[] m_currentInputRowDrivingQuery = null;
    protected String m_tableName;

    public CassandraInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (!this.isStopped()) {
            if (this.m_meta.getExecuteForEachIncomingRow() && this.m_currentInputRowDrivingQuery == null) {
                this.m_currentInputRowDrivingQuery = this.getRow();
                if (this.m_currentInputRowDrivingQuery == null) {
                    this.setOutputDone();
                    return false;
                }
                if (!this.first) {
                    this.initQuery();
                }
            }
            if (this.first) {
                this.first = false;
                String hostS = this.environmentSubstitute(this.m_meta.getCassandraHost());
                String portS = this.environmentSubstitute(this.m_meta.getCassandraPort());
                String timeoutS = this.environmentSubstitute(this.m_meta.getSocketTimeout());
                String maxLength = this.environmentSubstitute(this.m_meta.getMaxLength());
                String userS = this.m_meta.getUsername();
                String passS = this.m_meta.getPassword();
                if (!Utils.isEmpty((CharSequence)userS) && !Utils.isEmpty((CharSequence)passS)) {
                    userS = this.environmentSubstitute(userS);
                    passS = this.environmentSubstitute(passS);
                }
                String keyspaceS = this.environmentSubstitute(this.m_meta.getCassandraKeyspace());
                if (Utils.isEmpty((CharSequence)hostS) || Utils.isEmpty((CharSequence)portS) || Utils.isEmpty((CharSequence)keyspaceS)) {
                    throw new KettleException("Some connection details are missing!!");
                }
                this.logBasic(BaseMessages.getString(CassandraInputMeta.PKG, (String)"CassandraInput.Info.Connecting", (String[])new String[]{hostS, portS, keyspaceS}));
                HashMap<String, String> opts = new HashMap<String, String>();
                if (!Utils.isEmpty((CharSequence)timeoutS)) {
                    opts.put("socketTimeout", timeoutS);
                }
                if (!Utils.isEmpty((CharSequence)maxLength)) {
                    opts.put("maxLength", maxLength);
                }
                opts.put("driverVersion", "3.4.0");
                if (this.m_meta.getUseCompression()) {
                    opts.put("compression", Boolean.TRUE.toString());
                }
                if (opts.size() > 0) {
                    this.logBasic(BaseMessages.getString(CassandraInputMeta.PKG, (String)"CassandraInput.Info.UsingConnectionOptions", (String[])new String[]{CassandraUtils.optionsToString(opts)}));
                }
                try {
                    this.m_connection = CassandraUtils.getCassandraConnection(hostS, Integer.parseInt(portS), userS, passS, ConnectionFactory.Driver.BINARY_CQL3_PROTOCOL, opts);
                    this.m_keyspace = this.m_connection.getKeyspace(keyspaceS);
                }
                catch (Exception ex) {
                    this.closeConnection();
                    throw new KettleException(ex.getMessage(), (Throwable)ex);
                }
                this.m_tableName = CassandraUtils.getTableNameFromCQLSelectQuery(this.environmentSubstitute(this.m_meta.getCQLSelectQuery()));
                if (Utils.isEmpty((CharSequence)this.m_tableName)) {
                    throw new KettleException(BaseMessages.getString(CassandraInputMeta.PKG, (String)"CassandraInput.Error.NonExistentTable", (String[])new String[0]));
                }
                try {
                    if (!this.m_keyspace.tableExists(this.m_tableName)) {
                        throw new KettleException(BaseMessages.getString(CassandraInputMeta.PKG, (String)"CassandraInput.Error.NonExistentTable", (String[])new String[]{CassandraUtils.removeQuotes(this.m_tableName), keyspaceS}));
                    }
                }
                catch (Exception ex) {
                    this.closeConnection();
                    throw new KettleException(ex.getMessage(), (Throwable)ex);
                }
                this.m_data.setOutputRowMeta((RowMetaInterface)new RowMeta());
                this.m_meta.getFields(this.m_data.getOutputRowMeta(), this.getStepname(), null, null, (VariableSpace)this);
                if (this.m_data.getOutputRowMeta().size() == 0) {
                    throw new KettleException(BaseMessages.getString(CassandraInputMeta.PKG, (String)"CassandraInput.Error.QueryWontProduceOutputFields", (String[])new String[0]));
                }
                for (int i = 0; i < this.m_data.getOutputRowMeta().size(); ++i) {
                    String fieldName = this.m_data.getOutputRowMeta().getValueMeta(i).getName();
                    this.m_outputFormatMap.put(fieldName, i);
                }
                try {
                    this.logBasic(BaseMessages.getString(CassandraInputMeta.PKG, (String)"CassandraInput.Info.GettingMetaData", (String[])new String[]{this.m_tableName}));
                    this.m_cassandraMeta = this.m_keyspace.getTableMetaData(this.m_tableName);
                }
                catch (Exception e) {
                    this.closeConnection();
                    throw new KettleException(e.getMessage(), (Throwable)e);
                }
                this.initQuery();
            }
            Object[][] outRowData = new Object[1][];
            try {
                outRowData = this.m_cqlHandler.getNextOutputRow(this.m_data.getOutputRowMeta(), this.m_outputFormatMap);
            }
            catch (Exception e) {
                throw new KettleException(e.getMessage(), (Throwable)e);
            }
            if (outRowData != null) {
                for (Object[] r : outRowData) {
                    this.putRow(this.m_data.getOutputRowMeta(), r);
                }
                if (this.log.isRowLevel()) {
                    this.log.logRowlevel(this.toString(), new Object[]{"Outputted row #" + this.getProcessed() + " : " + outRowData});
                }
                if (this.checkFeedback(this.getProcessed())) {
                    this.logBasic("Read " + this.getProcessed() + " rows from Cassandra");
                }
            }
            if (outRowData == null) {
                if (!this.m_meta.getExecuteForEachIncomingRow()) {
                    this.closeConnection();
                    this.setOutputDone();
                    return false;
                }
                this.m_currentInputRowDrivingQuery = null;
            }
        } else {
            this.closeConnection();
            return false;
        }
        return true;
    }

    public boolean init(StepMetaInterface stepMeta, StepDataInterface stepData) {
        if (super.init(stepMeta, stepData)) {
            this.m_data = (CassandraInputData)stepData;
            this.m_meta = (CassandraInputMeta)stepMeta;
        }
        return true;
    }

    protected void initQuery() throws KettleException {
        String queryS = this.environmentSubstitute(this.m_meta.getCQLSelectQuery());
        if (this.m_meta.getExecuteForEachIncomingRow()) {
            queryS = this.fieldSubstitute(queryS, this.getInputRowMeta(), this.m_currentInputRowDrivingQuery);
        }
        Compression compression = this.m_meta.getUseCompression() ? Compression.GZIP : Compression.NONE;
        try {
            this.logBasic(BaseMessages.getString(CassandraInputMeta.PKG, (String)"CassandraInput.Info.ExecutingQuery", (String[])new String[]{queryS, this.m_meta.getUseCompression() ? BaseMessages.getString(CassandraInputMeta.PKG, (String)"CassandraInput.Info.UsingGZIPCompression", (String[])new String[0]) : ""}));
            if (this.m_cqlHandler == null) {
                this.m_cqlHandler = this.m_keyspace.getCQLRowHandler();
            }
            this.m_cqlHandler.newRowQuery(this, this.m_tableName, queryS, compression.name(), "", this.log);
        }
        catch (Exception e) {
            this.closeConnection();
            throw new KettleException(e.getMessage(), (Throwable)e);
        }
    }

    public void setStopped(boolean stopped) {
        if (this.isStopped() && stopped) {
            return;
        }
        super.setStopped(stopped);
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        try {
            this.closeConnection();
        }
        catch (KettleException e) {
            e.printStackTrace();
        }
    }

    protected void closeConnection() throws KettleException {
        if (this.m_connection != null) {
            this.logBasic(BaseMessages.getString(CassandraInputMeta.PKG, (String)"CassandraInput.Info.ClosingConnection", (String[])new String[0]));
            try {
                this.m_connection.closeConnection();
                this.m_connection = null;
            }
            catch (Exception e) {
                throw new KettleException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

