/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.plugins.PluginFolderInterface;
import org.scannotation.AnnotationDB;

public class JarFileCache {
    private static JarFileCache cache;
    private final Map<PluginFolderInterface, FileObject[]> folderMap;
    private final Map<FileObject, AnnotationDB> annotationMap = new HashMap<FileObject, AnnotationDB>();

    private JarFileCache() {
        this.folderMap = new HashMap<PluginFolderInterface, FileObject[]>();
    }

    public static JarFileCache getInstance() {
        if (cache == null) {
            cache = new JarFileCache();
        }
        return cache;
    }

    public AnnotationDB getAnnotationDB(FileObject fileObject) throws IOException {
        AnnotationDB result = this.annotationMap.get(fileObject);
        if (result == null) {
            result = new AnnotationDB();
            result.scanArchives(new URL[]{fileObject.getURL()});
            this.annotationMap.put(fileObject, result);
        }
        return result;
    }

    public FileObject[] getFileObjects(PluginFolderInterface pluginFolderInterface) throws KettleFileException {
        FileObject[] result = this.folderMap.get(pluginFolderInterface);
        if (result == null) {
            result = pluginFolderInterface.findJarFiles();
            this.folderMap.put(pluginFolderInterface, result);
        }
        return result;
    }

    public void clear() {
        this.annotationMap.clear();
        this.folderMap.clear();
    }
}

