/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.mqtt;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepOption;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;

public class MqttDialogOptionsLayout {
    private static Class<?> PKG = MqttDialogOptionsLayout.class;
    private final PropsUI props;
    private final CTabFolder wTabFolder;
    private final ModifyListener lsMod;
    private final TransMeta transMeta;
    private final List<StepOption> options;
    private TableView optionsTable;

    MqttDialogOptionsLayout(PropsUI props, CTabFolder wTabFolder, ModifyListener lsMod, TransMeta transMeta, List<StepOption> options) {
        Preconditions.checkNotNull((Object)props);
        Preconditions.checkNotNull((Object)wTabFolder);
        Preconditions.checkNotNull((Object)lsMod);
        Preconditions.checkNotNull((Object)transMeta);
        this.props = props;
        this.wTabFolder = wTabFolder;
        this.lsMod = lsMod;
        this.transMeta = transMeta;
        options = Optional.ofNullable(options).orElse(Collections.emptyList());
        this.options = options;
    }

    void buildTab() {
        CTabItem wOptionsTab = new CTabItem(this.wTabFolder, 0);
        wOptionsTab.setText(BaseMessages.getString(PKG, (String)"MQTTDialog.Options.Tab", (String[])new String[0]));
        Composite wOptionsComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wOptionsComp);
        FormLayout optionsLayout = new FormLayout();
        optionsLayout.marginHeight = 15;
        optionsLayout.marginWidth = 15;
        wOptionsComp.setLayout((Layout)optionsLayout);
        FormData fdOptionsComp = new FormData();
        fdOptionsComp.left = new FormAttachment(0, 0);
        fdOptionsComp.top = new FormAttachment(0, 0);
        fdOptionsComp.right = new FormAttachment(100, 0);
        wOptionsComp.setLayoutData((Object)fdOptionsComp);
        ColumnInfo[] columns = this.getColumns();
        int fieldCount = 1;
        this.optionsTable = new TableView((VariableSpace)this.transMeta, wOptionsComp, 67586, columns, fieldCount, false, this.lsMod, this.props, false);
        this.optionsTable.setSortable(false);
        this.optionsTable.getTable().addListener(11, event -> {
            Table table = (Table)event.widget;
            table.getColumn(1).setWidth(215);
            table.getColumn(2).setWidth(215);
        });
        this.populateTable();
        FormData fdData = new FormData();
        fdData.left = new FormAttachment(0, 0);
        fdData.top = new FormAttachment(0, 0);
        fdData.right = new FormAttachment(100, -10);
        fdData.width = 360;
        Arrays.stream(this.optionsTable.getTable().getColumns()).forEach(column -> {
            if (column.getWidth() > 0) {
                column.setWidth(120);
            }
        });
        this.optionsTable.setReadonly(true);
        this.optionsTable.setLayoutData((Object)fdData);
        wOptionsComp.layout();
        wOptionsTab.setControl((Control)wOptionsComp);
    }

    private ColumnInfo[] getColumns() {
        ColumnInfo optionName = new ColumnInfo(BaseMessages.getString(PKG, (String)"MQTTDialog.Options.Column.Name", (String[])new String[0]), 1, false, true);
        ColumnInfo optionValue = new ColumnInfo(BaseMessages.getString(PKG, (String)"MQTTDialog.Options.Column.Value", (String[])new String[0]), 1, false, false);
        optionValue.setUsingVariables(true);
        return new ColumnInfo[]{optionName, optionValue};
    }

    private void populateTable() {
        this.optionsTable.clearAll();
        this.options.stream().forEach(option -> this.optionsTable.add(new String[]{option.getText(), option.getValue()}));
        this.optionsTable.remove(0);
    }

    List<StepOption> retrieveOptions() {
        IntStream.range(0, this.optionsTable.getItemCount()).mapToObj(i -> this.optionsTable.getItem(i)).forEach(item -> this.options.stream().forEach(option -> {
            if (option.getText().equals(item[0])) {
                option.setValue(item[1]);
            }
        }));
        return this.options;
    }
}

