/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.mqtt;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.GenericStepData;
import org.pentaho.di.core.util.serialization.BaseSerializingMeta;
import org.pentaho.di.core.util.serialization.ConfigHelper;
import org.pentaho.di.core.util.serialization.Sensitive;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.StepOption;
import org.pentaho.di.trans.step.mqtt.MQTTClientBuilder;
import org.pentaho.di.trans.step.mqtt.MQTTProducer;
import org.pentaho.metastore.api.IMetaStore;

@Step(id="MQTTProducer", image="MQTTProducer.svg", i18nPackageName="org.pentaho.di.trans.step.mqtt", name="MQTTProducer.TypeLongDesc", description="MQTTProducer.TypeTooltipDesc", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Streaming", documentationUrl="Products/Data_Integration/Transformation_Step_Reference/MQTT_Producer")
@InjectionSupported(localizationPrefix="MQTTProducerMeta.Injection.", groups={"SSL"})
public class MQTTProducerMeta
extends BaseSerializingMeta
implements StepMetaInterface {
    private static Class<?> PKG = MQTTProducerMeta.class;
    @Injection(name="MQTT_SERVER")
    String mqttServer;
    @Injection(name="CLIENT_ID")
    String clientId;
    @Injection(name="TOPIC")
    String topic;
    @Injection(name="FIELD_TOPIC")
    String fieldTopic;
    @Injection(name="TOPIC_IN_FIELD")
    Boolean topicInField = false;
    @Injection(name="QOS")
    String qos;
    @Injection(name="MESSAGE_FIELD")
    String messageField;
    @Injection(name="USERNAME")
    String username;
    @Sensitive
    @Injection(name="PASSWORD")
    String password;
    @Injection(name="USE_SSL", group="SSL")
    Boolean useSsl = false;
    @Injection(name="SSL_KEYS", group="SSL")
    private List<String> sslKeys = new ArrayList<String>();
    @Sensitive
    @Injection(name="SSL_VALUES", group="SSL")
    private List<String> sslValues = new ArrayList<String>();
    @Injection(name="KEEP_ALIVE_INTERVAL")
    String keepAliveInterval;
    @Injection(name="MAX_INFLIGHT")
    String maxInflight;
    @Injection(name="CONNECTION_TIMEOUT")
    String connectionTimeout;
    @Injection(name="CLEAN_SESSION")
    String cleanSession;
    @Injection(name="STORAGE_LEVEL")
    String storageLevel;
    @Injection(name="SERVER_URIS")
    String serverUris;
    @Injection(name="MQTT_VERSION")
    String mqttVersion;
    @Injection(name="AUTOMATIC_RECONNECT")
    String automaticReconnect;

    public void setDefault() {
        this.mqttServer = "";
        this.topic = "";
        this.fieldTopic = "";
        this.qos = "0";
        this.username = "";
        this.password = "";
        this.sslKeys = MQTTClientBuilder.DEFAULT_SSL_OPTS.keySet().stream().sorted().collect(Collectors.toList());
        this.sslValues = this.sslKeys.stream().map(MQTTClientBuilder.DEFAULT_SSL_OPTS::get).collect(Collectors.toList());
        this.keepAliveInterval = "";
        this.maxInflight = "";
        this.connectionTimeout = "";
        this.cleanSession = "";
        this.storageLevel = "";
        this.serverUris = "";
        this.mqttVersion = "";
        this.automaticReconnect = "";
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        return new MQTTProducer(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new GenericStepData();
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        super.check(remarks, transMeta, stepMeta, prev, input, output, info, space, repository, metaStore);
        StepOption.checkInteger(remarks, (StepMeta)stepMeta, (VariableSpace)space, (String)BaseMessages.getString(PKG, (String)"MQTTDialog.Options.KEEP_ALIVE_INTERVAL", (String[])new String[0]), (String)this.keepAliveInterval);
        StepOption.checkInteger(remarks, (StepMeta)stepMeta, (VariableSpace)space, (String)BaseMessages.getString(PKG, (String)"MQTTDialog.Options.MAX_INFLIGHT", (String[])new String[0]), (String)this.maxInflight);
        StepOption.checkInteger(remarks, (StepMeta)stepMeta, (VariableSpace)space, (String)BaseMessages.getString(PKG, (String)"MQTTDialog.Options.CONNECTION_TIMEOUT", (String[])new String[0]), (String)this.connectionTimeout);
        StepOption.checkBoolean(remarks, (StepMeta)stepMeta, (VariableSpace)space, (String)BaseMessages.getString(PKG, (String)"MQTTDialog.Options.CLEAN_SESSION", (String[])new String[0]), (String)this.cleanSession);
        MQTTClientBuilder.checkVersion(remarks, stepMeta, space, this.mqttVersion);
        StepOption.checkBoolean(remarks, (StepMeta)stepMeta, (VariableSpace)space, (String)BaseMessages.getString(PKG, (String)"MQTTDialog.Options.AUTOMATIC_RECONNECT", (String[])new String[0]), (String)this.automaticReconnect);
    }

    List<StepOption> retrieveOptions() {
        return Arrays.asList(new StepOption("KEEP_ALIVE_INTERVAL", BaseMessages.getString(PKG, (String)"MQTTDialog.Options.KEEP_ALIVE_INTERVAL", (String[])new String[0]), this.keepAliveInterval), new StepOption("MAX_INFLIGHT", BaseMessages.getString(PKG, (String)"MQTTDialog.Options.MAX_INFLIGHT", (String[])new String[0]), this.maxInflight), new StepOption("CONNECTION_TIMEOUT", BaseMessages.getString(PKG, (String)"MQTTDialog.Options.CONNECTION_TIMEOUT", (String[])new String[0]), this.connectionTimeout), new StepOption("CLEAN_SESSION", BaseMessages.getString(PKG, (String)"MQTTDialog.Options.CLEAN_SESSION", (String[])new String[0]), this.cleanSession), new StepOption("STORAGE_LEVEL", BaseMessages.getString(PKG, (String)"MQTTDialog.Options.STORAGE_LEVEL", (String[])new String[0]), this.storageLevel), new StepOption("SERVER_URIS", BaseMessages.getString(PKG, (String)"MQTTDialog.Options.SERVER_URIS", (String[])new String[0]), this.serverUris), new StepOption("MQTT_VERSION", BaseMessages.getString(PKG, (String)"MQTTDialog.Options.MQTT_VERSION", (String[])new String[0]), this.mqttVersion), new StepOption("AUTOMATIC_RECONNECT", BaseMessages.getString(PKG, (String)"MQTTDialog.Options.AUTOMATIC_RECONNECT", (String[])new String[0]), this.automaticReconnect));
    }

    public String getDialogClassName() {
        return "org.pentaho.di.trans.step.mqtt.MQTTProducerDialog";
    }

    Map<String, String> getSslConfig() {
        return ConfigHelper.conf(this.sslKeys, this.sslValues).asMap();
    }

    void setSslConfig(Map<String, String> sslConfig) {
        this.sslKeys = ConfigHelper.conf(sslConfig).keys();
        this.sslValues = ConfigHelper.conf(sslConfig).vals();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MQTTProducerMeta that = (MQTTProducerMeta)((Object)o);
        return Objects.equal((Object)this.mqttServer, (Object)that.mqttServer) && Objects.equal((Object)this.clientId, (Object)that.clientId) && Objects.equal((Object)this.topic, (Object)that.topic) && Objects.equal((Object)this.fieldTopic, (Object)that.fieldTopic) && Objects.equal((Object)this.qos, (Object)that.qos) && Objects.equal((Object)this.messageField, (Object)that.messageField) && Objects.equal((Object)this.username, (Object)that.username) && Objects.equal((Object)this.password, (Object)that.password) && Objects.equal((Object)this.useSsl, (Object)that.useSsl) && Objects.equal(this.sslKeys, that.sslKeys) && Objects.equal(this.sslValues, that.sslValues) && Objects.equal((Object)this.keepAliveInterval, (Object)that.keepAliveInterval) && Objects.equal((Object)this.maxInflight, (Object)that.maxInflight) && Objects.equal((Object)this.connectionTimeout, (Object)that.connectionTimeout) && Objects.equal((Object)this.cleanSession, (Object)that.cleanSession) && Objects.equal((Object)this.storageLevel, (Object)that.storageLevel) && Objects.equal((Object)this.serverUris, (Object)that.serverUris) && Objects.equal((Object)this.mqttVersion, (Object)that.mqttVersion) && Objects.equal((Object)this.automaticReconnect, (Object)that.automaticReconnect);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mqttServer, this.clientId, this.topic, this.fieldTopic, this.qos, this.messageField, this.username, this.password, this.useSsl, this.sslKeys, this.sslValues, this.keepAliveInterval, this.maxInflight, this.connectionTimeout, this.cleanSession, this.storageLevel, this.serverUris, this.mqttVersion, this.automaticReconnect});
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("mqttServer", (Object)this.mqttServer).add("clientId", (Object)this.clientId).add("topic", (Object)this.topic).add("fieldTopic", (Object)this.fieldTopic).add("qos", (Object)this.qos).add("messageField", (Object)this.messageField).add("username", (Object)this.username).add("password", (Object)this.password).add("useSsl", (Object)this.useSsl).add("sslKeys", this.sslKeys).add("sslValues", this.sslValues).add("keepAliveInterval", (Object)this.keepAliveInterval).add("maxInflight", (Object)this.maxInflight).add("connectionTimeout", (Object)this.connectionTimeout).add("cleanSession", (Object)this.cleanSession).add("storageLevel", (Object)this.storageLevel).add("serverUris", (Object)this.serverUris).add("mqttVersion", (Object)this.mqttVersion).add("automaticReconnect", (Object)this.automaticReconnect).toString();
    }

    public MQTTProducerMeta copyObject() {
        MQTTProducerMeta newClone = (MQTTProducerMeta)((Object)this.clone());
        newClone.sslKeys = new ArrayList<String>(this.sslKeys);
        newClone.sslValues = new ArrayList<String>(this.sslValues);
        return newClone;
    }
}

