/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.html;

import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderCorner;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderEdge;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinitionFactory;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlContentItems;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlImageBounds;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlStyleCache;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlTextExtractor;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.FastGridLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.SheetPropertyCollector;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellBackground;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlRowBackgroundStruct;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.URLRewriteException;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.AbstractHtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.ContentUrlReWriteService;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.DefaultStyleBuilderFactory;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.StyleBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.WriterService;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.engine.classic.core.util.LongList;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class FastHtmlPrinter
extends AbstractHtmlPrinter
implements ContentUrlReWriteService {
    private static final Log logger = LogFactory.getLog(FastHtmlPrinter.class);
    private final SheetLayout sharedSheetLayout;
    private final FastHtmlContentItems contentItems;
    private final BoxDefinitionFactory boxDefinitionFactory;
    private ContentItem documentContentItem;
    private OutputProcessorMetaData metaData;
    private WriterService writer;
    private ReportAttributeMap reportAttributes;
    private String sheetName;
    private FastHtmlTextExtractor textExtractor;
    private int rowOffset;

    public FastHtmlPrinter(SheetLayout sharedSheetLayout, ResourceManager resourceManager, FastHtmlContentItems contentItems) {
        super(resourceManager);
        this.sharedSheetLayout = sharedSheetLayout;
        this.contentItems = contentItems;
        this.boxDefinitionFactory = new BoxDefinitionFactory();
    }

    @Override
    public String rewriteContentDataItem(ContentItem item) throws URLRewriteException {
        return this.contentItems.getUrlRewriter().rewrite((ContentEntity)this.documentContentItem, (ContentEntity)item);
    }

    @Override
    protected ContentUrlReWriteService getContentReWriteService() {
        return this;
    }

    public void close() throws IOException, ContentIOException {
        if (this.writer != null) {
            this.performCloseFile(this.sheetName, this.reportAttributes, this.writer);
            try {
                this.writer.close();
            }
            catch (IOException e) {
                logger.error((Object)"Failed to close writer instance", (Throwable)e);
            }
        }
        this.textExtractor = null;
        this.writer = null;
        this.documentContentItem = null;
    }

    public void init(OutputProcessorMetaData metaData, ReportDefinition report) {
        this.metaData = metaData;
        this.reportAttributes = report.getAttributes();
        this.initialize(metaData.getConfiguration());
    }

    public void print(ExpressionRuntime runtime, FastGridLayout gridLayout, HashMap<InstanceID, ReportElement> elements, HashMap<InstanceID, FastHtmlImageBounds> recordedBounds, FastHtmlStyleCache styleCache) {
        if (gridLayout.getRowCount() == 0) {
            return;
        }
        try {
            XmlWriter xmlWriter;
            if (this.documentContentItem == null) {
                ContentLocation contentLocation = this.contentItems.getContentLocation();
                NameGenerator contentNameGenerator = this.contentItems.getContentNameGenerator();
                this.documentContentItem = contentLocation.createItem(contentNameGenerator.generateName(null, "text/html"));
                this.writer = this.createWriterService(this.documentContentItem.getOutputStream());
                xmlWriter = this.writer.getXmlWriter();
                this.setDataWriter(this.contentItems.getDataLocation(), this.contentItems.getDataNameGenerator());
                this.openSheet(this.reportAttributes, this.sheetName, this.metaData, this.sharedSheetLayout, xmlWriter);
                this.textExtractor = new FastHtmlTextExtractor(this.metaData, xmlWriter, this.getContentGenerator(), this.getTagHelper());
            } else {
                xmlWriter = this.writer.getXmlWriter();
            }
            boolean emptyCellsUseCSS = this.getTagHelper().isEmptyCellsUseCSS();
            int rowCount = gridLayout.getRowCount();
            int colCount = gridLayout.getColumnCount();
            for (int row = 0; row < rowCount; ++row) {
                AttributeList rowAttributes = styleCache.getRowAttributes(row);
                if (rowAttributes == null) {
                    int rowHeight = (int)StrictGeomUtility.toExternalValue(gridLayout.getCellHeights().get(row));
                    HtmlRowBackgroundStruct struct = this.getCommonBackground(gridLayout, colCount, row);
                    rowAttributes = this.getTagHelper().createRowAttributes(rowHeight, struct);
                    styleCache.putRowAttributes(row, rowAttributes);
                }
                xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "tr", rowAttributes, false);
                for (int col = 0; col < colCount; ++col) {
                    Object rawFooterContent;
                    FastGridLayout.GridCell gridCell = gridLayout.get(row, col);
                    if (gridCell == null) continue;
                    if (gridCell.getInstanceId() == null) {
                        CellBackground background = gridCell.getLayoutInfo().getBackground();
                        this.writeBackgroundCell(background, xmlWriter);
                        continue;
                    }
                    ReportElement content = elements.get(gridCell.getInstanceId());
                    FastHtmlStyleCache.CellStyle cellStyle = this.computeCellAttributes(styleCache, row, col, gridCell, content);
                    if (content == null) {
                        xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "td", cellStyle.getCellAttributeList(), false);
                        if (!emptyCellsUseCSS) {
                            xmlWriter.writeText("&nbsp;");
                        }
                        xmlWriter.writeCloseTag();
                        continue;
                    }
                    xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "td", cellStyle.getCellAttributeList(), false);
                    Object rawContent = content.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "extra-raw-content");
                    if (rawContent != null) {
                        xmlWriter.writeText(String.valueOf(rawContent));
                    }
                    this.writeAnchors(xmlWriter, content);
                    if (!(Boolean.TRUE.equals(content.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "surpress-content")) || this.textExtractor.performOutput(content, cellStyle.getCellStyle(), recordedBounds, runtime) || emptyCellsUseCSS)) {
                        xmlWriter.writeText("&nbsp;");
                    }
                    if ((rawFooterContent = content.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "extra-raw-footer-content")) != null) {
                        xmlWriter.writeText(String.valueOf(rawFooterContent));
                    }
                    xmlWriter.writeCloseTag();
                }
                xmlWriter.writeCloseTag();
            }
        }
        catch (ContentIOException e) {
            throw new InvalidReportStateException(e);
        }
        catch (IOException e) {
            throw new InvalidReportStateException(e);
        }
        catch (URLRewriteException e) {
            throw new InvalidReportStateException(e);
        }
        catch (ContentProcessingException e) {
            throw new InvalidReportStateException(e);
        }
    }

    private FastHtmlStyleCache.CellStyle computeCellAttributes(FastHtmlStyleCache styleCache, int row, int col, FastGridLayout.GridCell gridCell, ReportElement content) {
        StyleBuilder styleBuilder = this.getStyleBuilder();
        DefaultStyleBuilderFactory styleBuilderFactory = this.getStyleBuilderFactory();
        FastHtmlStyleCache.CellStyle cellStyleCache = styleCache.getCellAttributes(row, col);
        if (cellStyleCache == null) {
            CellBackground realBackground = gridCell.getLayoutInfo().getBackground();
            int colSpan = gridCell.getLayoutInfo().getColumnSpan();
            int rowSpan = gridCell.getLayoutInfo().getRowSpan();
            if (content == null) {
                StyleBuilder cellStyle = styleBuilderFactory.createCellStyle(styleBuilder, realBackground, null, null);
                AttributeList cellAttributes = this.getTagHelper().createCellAttributes(colSpan, rowSpan, null, null, realBackground, cellStyle);
                cellStyleCache = new FastHtmlStyleCache.CellStyle(cellAttributes, cellStyle.toArray());
            } else {
                BoxDefinition boxDefinition = this.boxDefinitionFactory.getBoxDefinition(content.getComputedStyle());
                StyleBuilder cellStyle = styleBuilderFactory.createCellStyle(styleBuilder, content.getComputedStyle(), boxDefinition, realBackground, null, null);
                AttributeList cellAttributes = this.getTagHelper().createCellAttributes(colSpan, rowSpan, content.getAttributes(), content.getComputedStyle(), realBackground, cellStyle);
                cellStyleCache = new FastHtmlStyleCache.CellStyle(cellAttributes, cellStyle.toArray());
            }
            styleCache.putCellAttributes(row, col, cellStyleCache);
        }
        return cellStyleCache;
    }

    private void writeAnchors(XmlWriter xmlWriter, ReportElement realBackground) throws IOException {
        if (realBackground != null) {
            String[] anchors = new String[]{};
            for (int i = 0; i < anchors.length; ++i) {
                String anchor = anchors[i];
                xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "a", "name", anchor, true);
            }
        }
    }

    private HtmlRowBackgroundStruct getCommonBackground(FastGridLayout gridLayout, int columnCount, int row) {
        HtmlRowBackgroundStruct bg = new HtmlRowBackgroundStruct();
        BorderEdge topEdge = BorderEdge.EMPTY;
        BorderEdge bottomEdge = BorderEdge.EMPTY;
        Color color = null;
        for (int col = 0; col < columnCount; ++col) {
            FastGridLayout.GridCell gridCell = gridLayout.get(col, row);
            if (gridCell == null) continue;
            CellBackground backgroundAt = gridCell.getLayoutInfo().getBackground();
            if (backgroundAt == null) {
                bg.fail();
                return bg;
            }
            boolean fail = false;
            if (col == 0) {
                color = backgroundAt.getBackgroundColor();
                topEdge = backgroundAt.getTop();
                bottomEdge = backgroundAt.getBottom();
            } else {
                if (!ObjectUtilities.equal((Object)color, (Object)backgroundAt.getBackgroundColor())) {
                    fail = true;
                }
                if (!ObjectUtilities.equal((Object)topEdge, (Object)backgroundAt.getTop())) {
                    fail = true;
                }
                if (!ObjectUtilities.equal((Object)bottomEdge, (Object)backgroundAt.getBottom())) {
                    fail = true;
                }
            }
            if (!BorderCorner.EMPTY.equals(backgroundAt.getBottomLeft())) {
                fail = true;
            }
            if (!BorderCorner.EMPTY.equals(backgroundAt.getBottomRight())) {
                fail = true;
            }
            if (!BorderCorner.EMPTY.equals(backgroundAt.getTopLeft())) {
                fail = true;
            }
            if (!BorderCorner.EMPTY.equals(backgroundAt.getTopRight())) {
                fail = true;
            }
            if (!fail) continue;
            bg.fail();
            break;
        }
        bg.set(color, topEdge, bottomEdge);
        return bg;
    }

    public void startSection(Band band) {
        SheetPropertyCollector collector = new SheetPropertyCollector();
        this.sheetName = collector.compute(band);
    }

    public void endSection(Band band, FastGridLayout gridLayout) {
        LongList cellHeights = gridLayout.getCellHeights();
        this.rowOffset += cellHeights.size();
    }
}

