/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata;

import java.beans.PropertyEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.metadata.AbstractMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultAttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.MaturityLevel;
import org.pentaho.reporting.engine.classic.core.metadata.StyleMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.builder.StyleMetaDataBuilder;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class DefaultStyleKeyMetaData
extends AbstractMetaData
implements StyleMetaData {
    private static final Log logger = LogFactory.getLog(DefaultStyleKeyMetaData.class);
    private StyleKey key;
    private Class<? extends PropertyEditor> propertyEditorClass;

    public DefaultStyleKeyMetaData(StyleKey key, String propertyEditor, String bundleLocation, String keyPrefix, boolean expert, boolean preferred, boolean hidden, boolean deprecated, MaturityLevel maturityLevel, int compatibilityLevel) {
        super(key.getName(), bundleLocation, keyPrefix, expert, preferred, hidden, deprecated, maturityLevel, compatibilityLevel);
        this.key = key;
        this.propertyEditorClass = this.validatePropertyEditor(propertyEditor);
    }

    public DefaultStyleKeyMetaData(StyleMetaDataBuilder builder) {
        super(builder);
        this.key = builder.getKey();
        this.propertyEditorClass = builder.getPropertyEditor();
    }

    private Class<? extends PropertyEditor> validatePropertyEditor(String className) {
        return ObjectUtilities.loadAndValidate((String)className, DefaultAttributeMetaData.class, PropertyEditor.class);
    }

    @Override
    public PropertyEditor getEditor() {
        if (this.propertyEditorClass == null) {
            return null;
        }
        try {
            return this.propertyEditorClass.newInstance();
        }
        catch (Exception e) {
            logger.warn((Object)"Property editor threw error on instantiation", (Throwable)e);
            return null;
        }
    }

    @Override
    public Class getTargetType() {
        return this.key.getValueType();
    }

    @Override
    public StyleKey getStyleKey() {
        return this.key;
    }

    @Deprecated
    public String getPropertyEditor() {
        if (this.propertyEditorClass == null) {
            return null;
        }
        return this.propertyEditorClass.getSimpleName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultStyleKeyMetaData that = (DefaultStyleKeyMetaData)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

