/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.GroupDataBody;
import org.pentaho.reporting.engine.classic.core.GroupFooter;
import org.pentaho.reporting.engine.classic.core.GroupHeader;
import org.pentaho.reporting.engine.classic.core.SubGroupBody;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.RelationalGroupType;
import org.pentaho.reporting.engine.classic.core.sorting.SortConstraint;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class RelationalGroup
extends Group {
    private static final String[] EMPTY_FIELDS = new String[0];
    private GroupHeader header;
    private GroupFooter footer;

    public RelationalGroup() {
        this.setElementType(new RelationalGroupType());
        this.footer = new GroupFooter();
        this.header = new GroupHeader();
        this.registerAsChild(this.footer);
        this.registerAsChild(this.header);
    }

    public GroupHeader getHeader() {
        return this.header;
    }

    public void setHeader(GroupHeader header) {
        if (header == null) {
            throw new NullPointerException("Header must not be null");
        }
        this.validateLooping(header);
        if (this.unregisterParent(header)) {
            return;
        }
        GroupHeader element = this.header;
        this.header.setParent(null);
        this.header = header;
        this.header.setParent(this);
        this.notifyNodeChildRemoved(element);
        this.notifyNodeChildAdded(this.header);
    }

    public GroupFooter getFooter() {
        return this.footer;
    }

    public void setFooter(GroupFooter footer) {
        if (footer == null) {
            throw new NullPointerException("The footer must not be null");
        }
        this.validateLooping(footer);
        if (this.unregisterParent(footer)) {
            return;
        }
        GroupFooter element = this.footer;
        this.footer.setParent(null);
        this.footer = footer;
        this.footer.setParent(this);
        this.notifyNodeChildRemoved(element);
        this.notifyNodeChildAdded(this.footer);
    }

    public void setFields(List<String> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        String[] fields = c.toArray(new String[c.size()]);
        this.setFieldsArray(fields);
    }

    public void clearFields() {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "group-fields", EMPTY_FIELDS);
    }

    @Override
    protected GroupBody createDefaultBody() {
        return new GroupDataBody();
    }

    @Override
    public int getElementCount() {
        return 3;
    }

    public void addField(String name) {
        if (name == null) {
            throw new NullPointerException("Group.addField(...): name is null.");
        }
        ArrayList<String> fieldsList = new ArrayList<String>(this.getFields());
        fieldsList.add(name);
        Collections.sort(fieldsList);
        this.setFieldsArray(fieldsList.toArray(new String[fieldsList.size()]));
    }

    public List<String> getFields() {
        return Collections.unmodifiableList(Arrays.asList(this.getFieldsArray()));
    }

    public void setFieldsArray(String[] fields) {
        if (fields == null) {
            throw new NullPointerException();
        }
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "group-fields", fields.clone());
    }

    public String[] getFieldsArray() {
        Object o = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "group-fields");
        if (o instanceof String[]) {
            String[] fields = (String[])o;
            return (String[])fields.clone();
        }
        return EMPTY_FIELDS;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder(120);
        b.append("org.pentaho.reporting.engine.classic.core.RelationalGroup={Name='");
        b.append(this.getName());
        b.append("', GeneratedName=");
        b.append(this.getGeneratedName());
        b.append("', fields=");
        b.append(this.getFields());
        b.append("} ");
        return b.toString();
    }

    @Override
    public void setBody(GroupBody body) {
        if (!(body instanceof GroupDataBody) && !(body instanceof SubGroupBody)) {
            throw new IllegalArgumentException();
        }
        super.setBody(body);
    }

    public boolean equals(Object obj) {
        Object[] myFields;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RelationalGroup)) {
            return false;
        }
        RelationalGroup group = (RelationalGroup)obj;
        Object[] otherFields = group.getFieldsArray();
        return ObjectUtilities.equalArray((Object[])otherFields, (Object[])(myFields = this.getFieldsArray()));
    }

    public int hashCode() {
        String[] fields = this.getFieldsArray();
        int hashCode = 0;
        for (String field : fields) {
            hashCode = field == null ? 29 * hashCode : 29 * hashCode + field.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean isGroupChange(DataRow dataRow) {
        Object o = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "group-fields");
        if (o instanceof String[]) {
            String[] fields = (String[])o;
            for (int i = 0; i < fields.length; ++i) {
                String field = fields[i];
                if (field == null || !dataRow.isChanged(field)) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public GroupDataBody findGroupDataBody() {
        SubGroupBody groupBody;
        Group group;
        GroupBody body = this.getBody();
        if (body instanceof GroupDataBody) {
            return (GroupDataBody)body;
        }
        if (body instanceof SubGroupBody && (group = (groupBody = (SubGroupBody)body).getGroup()) instanceof RelationalGroup) {
            RelationalGroup rg = (RelationalGroup)group;
            return rg.findGroupDataBody();
        }
        return null;
    }

    @Override
    public RelationalGroup clone() {
        RelationalGroup g = (RelationalGroup)super.clone();
        g.footer = (GroupFooter)this.footer.clone();
        g.header = (GroupHeader)this.header.clone();
        g.registerAsChild(g.footer);
        g.registerAsChild(g.header);
        return g;
    }

    @Override
    public RelationalGroup derive(boolean preserveElementInstanceIds) {
        RelationalGroup g = (RelationalGroup)super.derive(preserveElementInstanceIds);
        g.footer = (GroupFooter)this.footer.derive(preserveElementInstanceIds);
        g.header = (GroupHeader)this.header.derive(preserveElementInstanceIds);
        g.registerAsChild(g.footer);
        g.registerAsChild(g.header);
        return g;
    }

    @Override
    protected void removeElement(Element element) {
        if (element == null) {
            throw new NullPointerException();
        }
        if (this.footer == element) {
            this.footer.setParent(null);
            this.footer = new GroupFooter();
            this.footer.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.footer);
        } else if (this.header == element) {
            this.header.setParent(null);
            this.header = new GroupHeader();
            this.header.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.header);
        } else {
            super.removeElement(element);
        }
    }

    @Override
    public Element getElement(int index) {
        switch (index) {
            case 0: {
                return this.header;
            }
            case 1: {
                return this.getBody();
            }
            case 2: {
                return this.footer;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setElementAt(int index, Element element) {
        switch (index) {
            case 0: {
                this.setHeader((GroupHeader)element);
                break;
            }
            case 1: {
                this.setBody((GroupBody)element);
                break;
            }
            case 2: {
                this.setFooter((GroupFooter)element);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    @Override
    public List<SortConstraint> getSortingConstraint() {
        return this.mapFields(this.getFields());
    }
}

