/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.LockTimeoutException;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.mob.ExpiredMobFileCleaner;
import org.apache.hadoop.hbase.mob.MobUtils;

@InterfaceAudience.Private
public class ExpiredMobFileCleanerChore
extends ScheduledChore {
    private static final Log LOG = LogFactory.getLog(ExpiredMobFileCleanerChore.class);
    private final HMaster master;
    private TableLockManager tableLockManager;
    private ExpiredMobFileCleaner cleaner;

    public ExpiredMobFileCleanerChore(HMaster master) {
        super(master.getServerName() + "-ExpiredMobFileCleanerChore", (Stoppable)master, master.getConfiguration().getInt("hbase.master.mob.ttl.cleaner.period", 86400), (long)master.getConfiguration().getInt("hbase.master.mob.ttl.cleaner.period", 86400), TimeUnit.SECONDS);
        this.master = master;
        this.tableLockManager = master.getTableLockManager();
        this.cleaner = new ExpiredMobFileCleaner();
        this.cleaner.setConf(master.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void chore() {
        try {
            TableDescriptors htds = this.master.getTableDescriptors();
            Map<String, HTableDescriptor> map = htds.getAll();
            for (HTableDescriptor htd : map.values()) {
                for (HColumnDescriptor hcd : htd.getColumnFamilies()) {
                    if (!hcd.isMobEnabled() || hcd.getMinVersions() != 0) continue;
                    boolean tableLocked = false;
                    TableLockManager.TableLock lock = null;
                    try {
                        if (this.tableLockManager != null) {
                            lock = this.tableLockManager.readLock(MobUtils.getTableLockName(htd.getTableName()), "Run ExpiredMobFileCleanerChore");
                            lock.acquire();
                        }
                        tableLocked = true;
                        this.cleaner.cleanExpiredMobFiles(htd.getTableName().getNameAsString(), hcd);
                    }
                    catch (LockTimeoutException e) {
                        LOG.info((Object)"Fail to acquire the lock because of timeout, maybe a MobCompactor is running", (Throwable)e);
                    }
                    catch (ServiceException e) {
                        LOG.error((Object)("Fail to clean the expired mob files for the column " + hcd.getNameAsString() + " in the table " + htd.getNameAsString()), (Throwable)e);
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Fail to clean the expired mob files for the column " + hcd.getNameAsString() + " in the table " + htd.getNameAsString()), (Throwable)e);
                    }
                    finally {
                        if (lock != null && tableLocked) {
                            try {
                                lock.release();
                            }
                            catch (IOException e) {
                                LOG.error((Object)("Fail to release the read lock for the table " + htd.getNameAsString()), (Throwable)e);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Fail to clean the expired mob files", (Throwable)e);
        }
    }
}

