/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup;

import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.impl.BackupManifest;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class HBackupFileSystem {
    public static final Log LOG = LogFactory.getLog(HBackupFileSystem.class);

    private HBackupFileSystem() {
    }

    public static String getTableBackupDir(String backupRootDir, String backupId, TableName tableName) {
        return backupRootDir + "/" + backupId + "/" + tableName.getNamespaceAsString() + "/" + tableName.getQualifierAsString() + "/";
    }

    public static Path getTableBackupPath(TableName tableName, Path backupRootPath, String backupId) {
        return new Path(HBackupFileSystem.getTableBackupDir(backupRootPath.toString(), backupId, tableName));
    }

    public static String getLogBackupDir(String backupRootDir, String backupId) {
        return backupRootDir + "/" + backupId + "/" + "WALs";
    }

    public static Path getLogBackupPath(String backupRootDir, String backupId) {
        return new Path(HBackupFileSystem.getLogBackupDir(backupRootDir, backupId));
    }

    private static Path getManifestPath(TableName tableName, Configuration conf, Path backupRootPath, String backupId) throws IOException {
        Path manifestPath = new Path(HBackupFileSystem.getTableBackupPath(tableName, backupRootPath, backupId), ".backup.manifest");
        FileSystem fs = backupRootPath.getFileSystem(conf);
        if (!fs.exists(manifestPath) && !fs.exists(manifestPath = new Path(HBackupFileSystem.getLogBackupDir(backupRootPath.toString(), backupId) + "/" + ".backup.manifest"))) {
            String errorMsg = "Could not find backup manifest .backup.manifest for " + backupId + " in " + backupRootPath.toString() + ". Did " + backupId + " correspond to previously taken backup ?";
            throw new IOException(errorMsg);
        }
        return manifestPath;
    }

    public static BackupManifest getManifest(TableName tableName, Configuration conf, Path backupRootPath, String backupId) throws IOException {
        BackupManifest manifest = new BackupManifest(conf, HBackupFileSystem.getManifestPath(tableName, conf, backupRootPath, backupId));
        return manifest;
    }

    public static void checkImageManifestExist(HashMap<TableName, BackupManifest> backupManifestMap, TableName[] tableArray, Configuration conf, Path backupRootPath, String backupId) throws IOException {
        for (TableName tableName : tableArray) {
            BackupManifest manifest = HBackupFileSystem.getManifest(tableName, conf, backupRootPath, backupId);
            backupManifestMap.put(tableName, manifest);
        }
    }
}

