/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.tez.SessionExpirationTracker;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.registry.impl.TezAmInstance;
import org.apache.tez.dag.api.TezException;

@VisibleForTesting
class TezSessionPoolSession
extends TezSessionState {
    private static final int STATE_NONE = 0;
    private static final int STATE_IN_USE = 1;
    private static final int STATE_EXPIRED = 2;
    private final AtomicInteger sessionState = new AtomicInteger(0);
    private Long expirationNs;
    private final Manager parent;
    private final SessionExpirationTracker expirationTracker;

    public TezSessionPoolSession(String sessionId, Manager parent, SessionExpirationTracker tracker, HiveConf conf) {
        super(sessionId, conf);
        this.parent = parent;
        this.expirationTracker = tracker;
    }

    void setExpirationNs(long expirationNs) {
        this.expirationNs = expirationNs;
    }

    Long getExpirationNs() {
        return this.expirationNs;
    }

    @Override
    void close(boolean keepTmpDir) throws Exception {
        try {
            super.close(keepTmpDir);
        }
        finally {
            this.parent.unregisterOpenSession(this);
            if (this.expirationTracker != null) {
                this.expirationTracker.removeFromExpirationQueue(this);
            }
        }
    }

    @Override
    protected void openInternal(String[] additionalFiles, boolean isAsync, SessionState.LogHelper console, TezSessionState.HiveResources resources) throws IOException, LoginException, URISyntaxException, TezException {
        super.openInternal(additionalFiles, isAsync, console, resources);
        this.parent.registerOpenSession(this);
        if (this.expirationTracker != null) {
            boolean isNotExpired = this.expirationTracker.addToExpirationQueue(this, 0L);
            assert (isNotExpired);
        }
    }

    @Override
    public boolean reconnect(String applicationId, long amAgeMs) throws IOException, LoginException, URISyntaxException, TezException {
        if (this.expirationTracker != null && !this.expirationTracker.isOldAmUsable(amAgeMs)) {
            this.closeExpiredOnReconnect(applicationId);
            return false;
        }
        if (!super.reconnect(applicationId, amAgeMs)) {
            return false;
        }
        this.parent.registerOpenSession(this);
        if (this.expirationTracker != null && !this.expirationTracker.addToExpirationQueue(this, amAgeMs)) {
            this.closeExpiredOnReconnect(applicationId);
            return false;
        }
        return true;
    }

    private void closeExpiredOnReconnect(String applicationId) {
        LOG.warn("Not using an old AM due to expiration timeout: " + applicationId);
        try {
            this.close(false);
        }
        catch (Exception e) {
            LOG.info("Failed to close the old AM", (Throwable)e);
        }
    }

    @Override
    public String toString() {
        if (this.expirationNs == null) {
            return super.toString();
        }
        long expiresInMs = (this.expirationNs - System.nanoTime()) / 1000000L;
        return super.toString() + ", expires in " + expiresInMs + "ms";
    }

    public boolean tryUse(boolean ignoreExpiration) {
        int finalState;
        do {
            int oldValue;
            if ((oldValue = this.sessionState.get()) == 1) {
                throw new AssertionError((Object)(this + " is already in use"));
            }
            if (oldValue != 2) continue;
            return false;
        } while (!this.sessionState.compareAndSet(0, finalState = !ignoreExpiration && this.shouldExpire() ? 2 : 1));
        if (finalState == 1) {
            return true;
        }
        this.expirationTracker.closeAndRestartExpiredSessionAsync(this);
        return false;
    }

    boolean stopUsing() {
        int finalState;
        int n = finalState = this.shouldExpire() ? 2 : 0;
        if (!this.sessionState.compareAndSet(1, finalState)) {
            throw new AssertionError((Object)("Unexpected state change; currently " + this.sessionState.get()));
        }
        if (finalState == 0) {
            return true;
        }
        this.expirationTracker.closeAndRestartExpiredSessionAsync(this);
        return false;
    }

    public boolean tryExpire(boolean isAsync) throws Exception {
        if (this.expirationNs == null) {
            return true;
        }
        if (!this.shouldExpire()) {
            return false;
        }
        do {
            if (this.sessionState.get() == 0) continue;
            return true;
        } while (!this.sessionState.compareAndSet(0, 2));
        if (isAsync) {
            this.expirationTracker.closeAndRestartExpiredSessionAsync(this);
        } else {
            this.expirationTracker.closeAndRestartExpiredSession(this);
        }
        return true;
    }

    private final boolean shouldExpire() {
        return this.expirationNs != null && System.nanoTime() - this.expirationNs >= 0L;
    }

    @Override
    public void returnToSessionManager() throws Exception {
        this.parent.returnAfterUse(this);
    }

    @Override
    public TezSessionState reopen() throws Exception {
        return this.parent.reopen(this);
    }

    @Override
    public void destroy() throws Exception {
        this.parent.destroy(this);
    }

    boolean isOwnedBy(Manager parent) {
        return this.parent == parent;
    }

    void updateFromRegistry(TezAmInstance si, int ephSeqVersion) {
    }

    public static abstract class AbstractTriggerValidator {
        private ScheduledExecutorService scheduledExecutorService = null;

        abstract Runnable getTriggerValidatorRunnable();

        void startTriggerValidator(long triggerValidationIntervalMs) {
            if (this.scheduledExecutorService == null) {
                this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("TriggerValidator").build());
                Runnable triggerValidatorRunnable = this.getTriggerValidatorRunnable();
                this.scheduledExecutorService.scheduleWithFixedDelay(triggerValidatorRunnable, triggerValidationIntervalMs, triggerValidationIntervalMs, TimeUnit.MILLISECONDS);
                TezSessionState.LOG.info("Started trigger validator with interval: {} ms", (Object)triggerValidationIntervalMs);
            }
        }

        void stopTriggerValidator() {
            if (this.scheduledExecutorService != null) {
                this.scheduledExecutorService.shutdownNow();
                this.scheduledExecutorService = null;
                TezSessionState.LOG.info("Stopped trigger validator");
            }
        }
    }

    public static interface Manager {
        public void registerOpenSession(TezSessionPoolSession var1);

        public void unregisterOpenSession(TezSessionPoolSession var1);

        public void returnAfterUse(TezSessionPoolSession var1) throws Exception;

        public TezSessionState reopen(TezSessionState var1) throws Exception;

        public void destroy(TezSessionState var1) throws Exception;
    }
}

