/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.s3csvinput;

import java.util.Arrays;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageObject;
import org.pentaho.di.trans.steps.s3csvinput.Messages;

public class S3ObjectsProvider {
    private S3Service service;

    public S3ObjectsProvider(S3Service service) {
        this.service = service;
    }

    private S3Bucket[] getBuckets() throws S3ServiceException {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            S3Bucket[] s3BucketArray = this.service.listAllBuckets();
            return s3BucketArray;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    public String[] getBucketsNames() throws S3ServiceException {
        return (String[])Arrays.stream(this.getBuckets()).map(b -> b.getName()).toArray(String[]::new);
    }

    public S3Bucket getBucket(String bucketName) throws S3ServiceException {
        return Arrays.stream(this.getBuckets()).filter(x -> bucketName.equals(x.getName())).findFirst().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private S3Object[] getS3Objects(S3Bucket bucket) throws S3ServiceException {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            S3Object[] s3ObjectArray = this.service.listObjects(bucket);
            return s3ObjectArray;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    public String[] getS3ObjectsNames(String bucketName) throws Exception {
        S3Bucket bucket = this.getBucket(bucketName);
        if (bucket == null) {
            throw new Exception(Messages.getString("S3DefaultService.Exception.UnableToFindBucket.Message", bucketName));
        }
        return (String[])Arrays.stream(this.getS3Objects(bucket)).map(b -> b.getKey()).toArray(String[]::new);
    }

    public S3Object getS3Object(S3Bucket bucket, String objectKey, Long byteRangeStart, Long byteRangeEnd) throws S3ServiceException {
        return this.service.getObject(bucket, objectKey, null, null, null, null, byteRangeStart, byteRangeEnd);
    }

    public S3Object getS3Object(S3Bucket bucket, String objectKey) throws S3ServiceException {
        return this.getS3Object(bucket, objectKey, null, null);
    }

    private StorageObject getS3ObjectDetails(S3Bucket bucket, String objectKey) throws S3ServiceException {
        return this.service.getObjectDetails(bucket, objectKey, null, null, null, null);
    }

    public long getS3ObjectContentLenght(S3Bucket bucket, String objectKey) throws S3ServiceException {
        return this.getS3ObjectDetails(bucket, objectKey).getContentLength();
    }
}

