/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.jms;

import com.google.common.collect.ImmutableList;
import io.reactivex.Observable;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.schedulers.Schedulers;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.JMSConsumer;
import javax.jms.JMSRuntimeException;
import javax.jms.Message;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.jms.JmsConstants;
import org.pentaho.di.trans.step.jms.JmsDelegate;
import org.pentaho.di.trans.streaming.common.BaseStreamStep;
import org.pentaho.di.trans.streaming.common.BlockingQueueStreamSource;

public class JmsStreamSource
extends BlockingQueueStreamSource<List<Object>> {
    private final JmsDelegate jmsDelegate;
    private final int receiverTimeout;
    private JMSConsumer consumer;
    private AtomicBoolean closed = new AtomicBoolean(false);

    JmsStreamSource(BaseStreamStep streamStep, JmsDelegate jmsDelegate, int receiverTimeout) {
        super(streamStep);
        this.jmsDelegate = jmsDelegate;
        this.receiverTimeout = receiverTimeout;
    }

    public void open() {
        this.consumer = this.jmsDelegate.getJmsContext((VariableSpace)this.streamStep).createConsumer(this.jmsDelegate.getDestination((VariableSpace)this.streamStep));
        Observable.create(this.receiveLoop()).subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).doOnNext(message -> this.acceptRows(Collections.singletonList(ImmutableList.of((Object)message, (Object)this.jmsDelegate.destinationName)))).doOnComplete(this::close).doOnError(arg_0 -> ((JmsStreamSource)this).error(arg_0)).publish().connect();
    }

    private ObservableOnSubscribe<Object> receiveLoop() {
        return emitter -> {
            try {
                Message message;
                while ((message = this.consumer.receive((long)this.receiverTimeout)) != null) {
                    this.streamStep.logDebug(message.toString());
                    emitter.onNext(message.getBody(Object.class));
                }
            }
            catch (JMSRuntimeException jmsException) {
                emitter.onError((Throwable)jmsException);
            }
            if (!this.closed.get()) {
                this.streamStep.logBasic(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsStreamSource.HitReceiveTimeout", (String[])new String[0]));
            }
            emitter.onComplete();
        };
    }

    public void close() {
        super.close();
        this.closed.set(true);
        if (this.consumer != null) {
            this.consumer.close();
        }
    }
}

