/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.analyzer.kettle;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.file.BaseFileInputMeta;
import org.pentaho.di.trans.steps.file.BaseFileInputStep;
import org.pentaho.metaverse.api.MetaverseException;
import org.pentaho.metaverse.api.model.ExternalResourceInfoFactory;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;

public class KettleAnalyzerUtil {
    public static String normalizeFilePath(String filePath) throws MetaverseException {
        try {
            String path = filePath;
            FileObject fo = KettleVFS.getFileObject((String)filePath);
            try {
                path = fo.getURL().getPath();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            File f = new File(path);
            return f.getAbsolutePath();
        }
        catch (Exception e) {
            throw new MetaverseException(e);
        }
    }

    public static Collection<IExternalResourceInfo> getResourcesFromMeta(StepMeta parentStepMeta, String[] filePaths) {
        List<IExternalResourceInfo> resources = Collections.emptyList();
        if (parentStepMeta != null && filePaths != null && filePaths.length > 0) {
            resources = new ArrayList<IExternalResourceInfo>(filePaths.length);
            for (String path : filePaths) {
                if (Const.isEmpty((String)path)) continue;
                try {
                    IExternalResourceInfo resource = ExternalResourceInfoFactory.createFileResource(KettleVFS.getFileObject((String)path), true);
                    if (resource == null) {
                        throw new KettleFileException("Error getting file resource!");
                    }
                    resources.add(resource);
                }
                catch (KettleFileException kettleFileException) {
                    // empty catch block
                }
            }
        }
        return resources;
    }

    public static Collection<IExternalResourceInfo> getResourcesFromRow(BaseFileInputStep step, RowMetaInterface rowMeta, Object[] row) {
        LinkedList<IExternalResourceInfo> resources = new LinkedList<IExternalResourceInfo>();
        BaseFileInputMeta meta = (BaseFileInputMeta)step.getStepMetaInterface();
        if (meta == null) {
            meta = (BaseFileInputMeta)step.getStepMeta().getStepMetaInterface();
        }
        try {
            String filename;
            String string = filename = meta == null ? null : step.environmentSubstitute(rowMeta.getString(row, meta.getAcceptingField(), null));
            if (!Const.isEmpty(filename)) {
                FileObject fileObject = KettleVFS.getFileObject((String)filename, (VariableSpace)step);
                resources.add(ExternalResourceInfoFactory.createFileResource(fileObject, true));
            }
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        return resources;
    }
}

