/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.analyzer.kettle;

import java.io.Serializable;
import java.util.UUID;
import org.pentaho.dictionary.DictionaryConst;
import org.pentaho.metaverse.api.IComponentDescriptor;
import org.pentaho.metaverse.api.ILogicalIdGenerator;
import org.pentaho.metaverse.api.IMetaverseBuilder;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.IMetaverseObjectFactory;
import org.pentaho.metaverse.api.INamespace;
import org.pentaho.metaverse.api.IRequiresMetaverseBuilder;
import org.pentaho.metaverse.api.MetaverseException;
import org.pentaho.metaverse.api.analyzer.kettle.KettleAnalyzerUtil;

public abstract class BaseKettleMetaverseComponent
implements IRequiresMetaverseBuilder,
Serializable {
    private static final long serialVersionUID = 8122643311387257050L;
    protected IMetaverseBuilder metaverseBuilder;
    protected IMetaverseObjectFactory metaverseObjectFactory;

    @Override
    public void setMetaverseBuilder(IMetaverseBuilder metaverseBuilder) {
        this.metaverseBuilder = metaverseBuilder;
        if (metaverseBuilder != null) {
            this.metaverseObjectFactory = metaverseBuilder.getMetaverseObjectFactory();
        }
    }

    @Override
    public IMetaverseBuilder getMetaverseBuilder() {
        return this.metaverseBuilder;
    }

    protected INamespace getSiblingNamespace(INamespace namespace, String siblingName, String siblingType) {
        if (namespace == null) {
            return null;
        }
        return namespace.getSiblingNamespace(siblingName, siblingType);
    }

    protected IMetaverseNode createNodeFromDescriptor(IComponentDescriptor descriptor) {
        return this.createNodeFromDescriptor(descriptor, this.getLogicalIdGenerator());
    }

    protected IMetaverseNode createNodeFromDescriptor(IComponentDescriptor descriptor, ILogicalIdGenerator idGenerator) {
        String uuid = UUID.randomUUID().toString();
        IMetaverseNode node = null;
        if (descriptor != null) {
            node = this.metaverseObjectFactory.createNodeObject(uuid, descriptor.getName(), descriptor.getType());
            if (idGenerator.getLogicalIdPropertyKeys().contains("namespace") && descriptor.getParentNamespace() != null) {
                node.setProperty("namespace", descriptor.getNamespace().getNamespaceId());
            }
            node.setLogicalIdGenerator(idGenerator);
        }
        return node;
    }

    protected IMetaverseNode createFileNode(String fileName, IComponentDescriptor descriptor) throws MetaverseException {
        return this.createFileNode(fileName, descriptor, "File");
    }

    protected IMetaverseNode createFileNode(String fileName, IComponentDescriptor descriptor, String nodeType) throws MetaverseException {
        IMetaverseNode fileNode = null;
        if (fileName != null && descriptor != null) {
            String normalized = KettleAnalyzerUtil.normalizeFilePath(fileName);
            INamespace ns = descriptor.getNamespace();
            INamespace parentNs = ns.getParentNamespace();
            fileNode = this.metaverseObjectFactory.createNodeObject(parentNs == null ? ns : parentNs, normalized, nodeType);
            fileNode.setProperty("path", normalized);
            fileNode.setLogicalIdGenerator(DictionaryConst.LOGICAL_ID_GENERATOR_FILE);
        }
        return fileNode;
    }

    protected ILogicalIdGenerator getLogicalIdGenerator() {
        return DictionaryConst.LOGICAL_ID_GENERATOR_DEFAULT;
    }
}

